/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class GettextResource
extends ResourceBundle {
    static final boolean DEBUG = false;
    static final int[] MAGIC = new int[]{-107, 4, 18, -34};
    static final int[] MAGIC_REVERSED = new int[]{-34, 18, 4, -107};
    public static final String DEFAULT_LOCALES_DIRECTORY = "/usr/share/locale";
    private static Map<String, GettextResource> cachedGettextResource = new HashMap<String, GettextResource>();
    private static byte CONTEXT_SPECIFIER = (byte)4;
    private boolean useContextSpecifier = false;
    private transient Boolean reversed;
    private transient int revision;
    private transient int n;
    private transient int o;
    private transient int oj;
    private transient int[] oo_length;
    private transient int[] oo_offset;
    private transient int t;
    private transient int tj;
    private transient int[] tt_length;
    private transient int[] tt_offset;
    private transient int s;
    private transient int h;
    private ByteBuffer[] msgidByteBuffers;
    private ByteBuffer[] msgstrByteBuffers;
    private boolean showMissingTranslation = false;
    private Charset charset = Charset.defaultCharset();

    public GettextResource(File moFile) {
        this.init(moFile);
    }

    public GettextResource(Locale loc, String localedir, String textdomain) {
        String moFilename = GettextResource.findMoFile(loc, localedir, textdomain);
        if (moFilename == null) {
            throw new IOError(new FileNotFoundException("Cannot find resource " + moFilename));
        }
        this.init(new File(moFilename));
    }

    public GettextResource(String localedir, String textdomain) {
        this(Locale.getDefault(), localedir, textdomain);
    }

    public GettextResource(Locale loc, String textdomain) {
        this(loc, DEFAULT_LOCALES_DIRECTORY, textdomain);
    }

    private static String findMoFile(Locale loc, String localedir, String textdomain) {
        String moFilename = localedir + File.separator + loc.toString() + File.separator + "LC_MESSAGES" + File.separator + textdomain + ".mo";
        if (!new File(moFilename).exists() && !new File(moFilename = localedir + File.separator + loc.getLanguage() + File.separator + "LC_MESSAGES" + File.separator + textdomain + ".mo").exists()) {
            return null;
        }
        return moFilename;
    }

    private void copyInstance(GettextResource instance) {
        this.msgidByteBuffers = instance.msgidByteBuffers;
        this.msgstrByteBuffers = instance.msgstrByteBuffers;
        this.showMissingTranslation = instance.showMissingTranslation;
        this.charset = instance.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File moFile) {
        try {
            String key = moFile.getAbsolutePath();
            GettextResource instance = cachedGettextResource.get(key);
            if (instance != null) {
                this.copyInstance(instance);
                return;
            }
            this.readOffsetsAndLenghts(moFile);
            this.logOffsetAndLenghtInfo();
            AbstractInterruptibleChannel channel = null;
            try {
                channel = new RandomAccessFile(moFile, "r").getChannel();
                for (int i = 0; i < this.n; ++i) {
                    this.msgidByteBuffers[i] = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, this.oo_offset[i], this.oo_length[i]);
                    this.msgstrByteBuffers[i] = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, this.tt_offset[i], this.tt_length[i]);
                }
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
            this.releaseOffsetAndLenghtArrays();
            this.setCharset();
            cachedGettextResource.put(key, this);
            this.logMessages();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void setCharset() {
        String info = this.getInfoMessage();
        int chIndexOf = info.indexOf("charset");
        if (chIndexOf >= 0) {
            String charsetName;
            int start = chIndexOf + "charset".length() + 1;
            int end = -1;
            for (int i = start; i < info.length(); ++i) {
                if (info.charAt(i) != '\n') continue;
                end = i;
                break;
            }
            if (end > start && Charset.isSupported(charsetName = info.substring(start, end))) {
                this.charset = Charset.forName(charsetName);
            }
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOffsetsAndLenghts(File file) {
        try {
            FileInputStream is = null;
            try {
                int n;
                is = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                int index = 0;
                block7: while ((n = ((InputStream)is).read(buffer)) != -1) {
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.handleByte(buffer[i], index);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            e.printStackTrace();
                            throw new ArrayIndexOutOfBoundsException("index: " + index);
                        }
                        if (++index > 12 && index == this.h) continue block7;
                    }
                }
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void handleByte(byte b, int index) {
        if (index == 0) {
            this.reversed = b == -34;
        }
        if (!this.useContextSpecifier && b == CONTEXT_SPECIFIER) {
            this.useContextSpecifier = true;
        }
        if (index == 12) {
            this.oo_length = new int[this.n];
            this.oo_offset = new int[this.n];
            this.tt_length = new int[this.n];
            this.tt_offset = new int[this.n];
            this.msgidByteBuffers = new ByteBuffer[this.n];
            this.msgstrByteBuffers = new ByteBuffer[this.n];
        }
        if (index == 28) {
            this.logInitOffset();
        }
        if (index < 4) {
            if (b != MAGIC[index] && b != MAGIC_REVERSED[index]) {
                throw new IOError(new IOException(String.format("Invalid .mo file: byte[%d]=%h", index, b & 0xFF)));
            }
        } else if (index >= 4 && index < 8) {
            int k = 4;
            this.revision = this.swap(b, index, this.revision, k);
        } else if (index >= 8 && index < 12) {
            int k = 8;
            this.n = this.swap(b, index, this.n, k);
        } else if (index >= 12 && index < 16) {
            int k = 12;
            this.o = this.swap(b, index, this.o, k);
        } else if (index >= 16 && index < 20) {
            int k = 16;
            this.t = this.swap(b, index, this.t, k);
        } else if (index >= 20 && index < 24) {
            int k = 20;
            this.s = this.swap(b, index, this.s, k);
        } else if (index >= 24 && index < 28) {
            int k = 24;
            this.h = this.swap(b, index, this.h, k);
        } else if (index >= this.o + this.oj * 8 && index < this.o + this.oj * 8 + 4 && index < this.o + (this.n - 1) * 8 + 4) {
            this.oo_length[this.oj] = this.swap(b, index, this.oo_length[this.oj], this.o + this.oj * 8);
            if (index == this.o + this.oj * 8 + 3) {
                ++this.oj;
            }
        } else if (this.oj > 0 && index >= this.o + (this.oj - 1) * 8 + 4 && index < this.o + (this.oj - 1) * 8 + 4 + 4 && index < this.o + (this.n - 1) * 8 + 4 + 4) {
            this.oo_offset[this.oj - 1] = this.swap(b, index, this.oo_offset[this.oj - 1], this.o + (this.oj - 1) * 8 + 4);
        } else if (index >= this.t + this.tj * 8 && index < this.t + this.tj * 8 + 4 && index < this.t + (this.n - 1) * 8 + 4) {
            this.tt_length[this.tj] = this.swap(b, index, this.tt_length[this.tj], this.t + this.tj * 8);
            if (index == this.t + this.tj * 8 + 3) {
                ++this.tj;
            }
        } else if (this.tj > 0 && index >= this.t + (this.tj - 1) * 8 + 4 && index < this.t + (this.tj - 1) * 8 + 4 + 4 && index < this.t + (this.n - 1) * 8 + 4 + 4) {
            this.tt_offset[this.tj - 1] = this.swap(b, index, this.tt_offset[this.tj - 1], this.t + (this.tj - 1) * 8 + 4);
        }
    }

    private int swap(byte b, int index, int n, int k) {
        int x;
        int n2 = x = this.reversed != false ? (index - k) * 8 : (3 - index - k) * 8;
        n = x != 0 ? (n |= (b & 0xFF) << x) : (n |= b & 0xFF);
        return n;
    }

    private void releaseOffsetAndLenghtArrays() {
        this.oo_length = null;
        this.oo_offset = null;
        this.tt_length = null;
        this.tt_offset = null;
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> en = new Enumeration<String>(){
            private int elementIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.elementIndex < GettextResource.this.msgidByteBuffers.length;
            }

            @Override
            public String nextElement() {
                String nextElement = GettextResource.this.toString(GettextResource.this.msgidByteBuffers[this.elementIndex]);
                ++this.elementIndex;
                return nextElement;
            }
        };
        return en;
    }

    @Override
    protected Object handleGetObject(String key) {
        return this._(key);
    }

    public String _(String msgid) {
        ByteBuffer msgidByteBuffer;
        int idx;
        byte[] array = msgid.getBytes();
        if (this.useContextSpecifier) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != 124) continue;
                array[i] = CONTEXT_SPECIFIER;
            }
        }
        if ((idx = Arrays.binarySearch(this.msgidByteBuffers, msgidByteBuffer = ByteBuffer.wrap(array))) < 0) {
            return this.handleMissingTranslation(msgid);
        }
        String msgstr = this.toString(this.msgstrByteBuffers[idx]);
        if (msgstr.isEmpty()) {
            return this.handleMissingTranslation(msgid);
        }
        return msgstr;
    }

    private String handleMissingTranslation(String msgid) {
        String tmpMsgid;
        String msgstr = tmpMsgid = msgid;
        int indexOf = tmpMsgid.indexOf(124);
        if (indexOf > 0) {
            tmpMsgid = tmpMsgid.substring(indexOf + 1);
            msgstr = this._(tmpMsgid);
        }
        return this.showMissingTranslation ? "*" + msgstr + "*" : msgstr;
    }

    public String getInfoMessage() {
        return this._("");
    }

    public void markMissingTranslation(boolean showMissingTranslation) {
        this.showMissingTranslation = showMissingTranslation;
    }

    private String toString(ByteBuffer buf) {
        byte[] array = new byte[buf.limit()];
        buf.position(0);
        buf.get(array);
        buf.position(0);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != CONTEXT_SPECIFIER) continue;
            array[i] = 124;
        }
        return new String(array, Charset.forName("UTF-8"));
    }

    public static boolean hasTranslation(Locale loc, String localedir, String textdomain) {
        return GettextResource.findMoFile(loc, localedir, textdomain) != null;
    }

    public static boolean hasTranslation(Locale loc, String textdomain) {
        return GettextResource.hasTranslation(loc, DEFAULT_LOCALES_DIRECTORY, textdomain);
    }

    public static boolean hasTranslation(String textdomain) {
        return GettextResource.hasTranslation(Locale.getDefault(), DEFAULT_LOCALES_DIRECTORY, textdomain);
    }

    private void logInitOffset() {
    }

    private void logOffsetAndLenghtInfo() {
    }

    private void logMessages() {
    }

    private void debug(Object ... msgs) {
    }

    private static void printUsage() {
        System.out.println("Usage: gettextResource [-k MSGID] | [-i] FILENAME");
        System.out.println();
        System.out.println("Get the translation for the given MSGID or list all");
        System.out.println("MSGID/MGSSTR pairs when no option is given.");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -h, --help            Show this help message and exit");
        System.out.println("  -i, --info            Show the .mo file info");
        System.out.println("  -k MSGID              Get the associated msgstr");
        System.out.println();
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  gettextResource -k Search /usr/share/locale/it/LC_MESSAGES/gtk20.mo");
        System.out.println("  gettextResource /usr/share/locale/it/LC_MESSAGES/gtk20.mo");
    }

    public static void main(String ... args) {
        if (args.length == 0) {
            GettextResource.printUsage();
            System.exit(0);
        }
        try {
            String msgid = null;
            String filename = null;
            boolean showInfo = false;
            if ("-h".equals(args[0]) || "--help".equals(args[0])) {
                GettextResource.printUsage();
                System.exit(0);
            }
            if ("-i".equals(args[0]) || "--info".equals(args[0])) {
                showInfo = true;
                filename = args[1];
            } else if ("-k".equals(args[0]) || "-k".equals(args[0])) {
                msgid = args[1];
                filename = args[2];
            } else {
                filename = args[0];
            }
            if (filename != null && !new File(filename).isAbsolute()) {
                filename = System.getProperty("user.dir") + File.separator + filename;
            }
            GettextResource r = new GettextResource(new File(filename));
            if (showInfo) {
                System.out.println(r.getInfoMessage());
            } else if (msgid != null) {
                System.out.println(r._(msgid));
            } else {
                Enumeration<String> en = r.getKeys();
                while (en.hasMoreElements()) {
                    String id = en.nextElement();
                    String msgstr = r._(id);
                    System.out.println("msgid \"" + id + "\"");
                    System.out.println("msgstr \"" + msgstr + "\"");
                    System.out.println();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            GettextResource.printUsage();
        }
    }
}

