/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.BasicPath;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Platform;
import eu.kostia.gtkjfilechooser.RemovableDevice;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;

public class FreeDesktopUtil {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private static final String HUMAN_READABLE_FMT = "%.1f %s";
    private static Properties userDirsProps;

    public static File getWellKnownDirPath(WellKnownDir type) {
        String pathname;
        if (userDirsProps == null) {
            FreeDesktopUtil.initUserDirsProps();
        }
        String property = FreeDesktopUtil.expandEnv((pathname = userDirsProps.getProperty("XDG_" + (Object)((Object)type) + "_DIR")) != null ? pathname : type.getDefaultPath());
        File path = new File(property);
        return path.exists() ? path : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initUserDirsProps() throws IOError {
        userDirsProps = new Properties();
        File userDirsFile = new File(System.getProperty("user.home") + "/.config/user-dirs.dirs");
        if (userDirsFile.exists()) {
            try {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(userDirsFile);
                    userDirsProps.load(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static String expandEnv(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('$' == ch) {
                ch = str.charAt(++i);
                int start = i;
                while (Character.isLetter(ch)) {
                    ch = str.charAt(i);
                    ++i;
                }
                int end = i - 1;
                sb.append(System.getenv(str.substring(start, end)));
                i = end;
                continue;
            }
            if ('\\' == ch) {
                ch = str.charAt(++i);
                sb.append(ch);
                continue;
            }
            if ('\"' == ch) {
                ++i;
                continue;
            }
            if ('~' == ch) {
                sb.append(System.getProperty("user.home"));
                ++i;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RemovableDevice> getRemovableDevices() {
        ArrayList<RemovableDevice> devices = new ArrayList<RemovableDevice>();
        Object[] diskUUIDs = !Platform.isSolaris() ? new File("/dev/disk/by-uuid/").list() : new String[]{};
        Arrays.sort(diskUUIDs);
        Scanner fileScanner = null;
        try {
            fileScanner = new Scanner(new File(Platform.isSolaris() ? "/etc/mnttab" : "/proc/mounts"));
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                Scanner lineScanner = null;
                try {
                    lineScanner = new Scanner(line);
                    String dev = lineScanner.next();
                    String location = lineScanner.next();
                    if (!location.startsWith("/media/")) continue;
                    RemovableDevice device = new RemovableDevice();
                    device.setLocation(FreeDesktopUtil.escapes(location));
                    device.setType(RemovableDevice.RemovableDeviceType.getType(dev));
                    String name = location.substring("/media/".length());
                    name = FreeDesktopUtil.escapes(name);
                    if (Arrays.binarySearch(diskUUIDs, name) >= 0) {
                        name = FreeDesktopUtil.humanreadble(new File(location).getTotalSpace(), 0x20000000) + " " + I18N._("File System");
                    }
                    device.setName(name);
                    devices.add(device);
                }
                finally {
                    if (lineScanner == null) continue;
                    lineScanner.close();
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            if (fileScanner != null) {
                fileScanner.close();
            }
        }
        return devices;
    }

    private static String escapes(String name) {
        name = name.replace("\\040", " ");
        return name;
    }

    public static String humanreadble(long bytes, int roundFactor) {
        long mod;
        long roundedBytes = bytes;
        if (roundFactor > 0 && (mod = bytes % (long)roundFactor) != 0L) {
            roundedBytes += (long)roundFactor - mod;
        }
        if (roundedBytes >= 0x40000000L) {
            return String.format(HUMAN_READABLE_FMT, (double)roundedBytes / 1.073741824E9, "GB");
        }
        if (roundedBytes >= 0x100000L) {
            return String.format(HUMAN_READABLE_FMT, (double)roundedBytes / 1048576.0, "MB");
        }
        if (roundedBytes >= 1024L) {
            return String.format(HUMAN_READABLE_FMT, (double)roundedBytes / 1024.0, "KB");
        }
        return roundedBytes + " Bytes";
    }

    public static List<BasicPath> getBasicLocations() {
        ArrayList<BasicPath> basicLocations = new ArrayList<BasicPath>();
        basicLocations.add(BasicPath.HOME);
        if (BasicPath.DESKTOP != null) {
            basicLocations.add(BasicPath.DESKTOP);
        }
        basicLocations.add(BasicPath.ROOT);
        return basicLocations;
    }

    public static enum WellKnownDir {
        DESKTOP("~/Desktop"),
        DOWNLOAD("~/Download"),
        TEMPLATES("~/Templates"),
        PUBLICSHARE("~/Public"),
        DOCUMENTS("~/Documents"),
        MUSIC("~/Music"),
        PICTURES("~/Pictures"),
        VIDEOS("~/Videos");

        private String defaultPath;

        private WellKnownDir(String defaultPath) {
            this.defaultPath = defaultPath;
        }

        public String getDefaultPath() {
            return this.defaultPath;
        }
    }
}

