/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.formats.services.JAIIIOService;

public class JAIIIOServiceImpl
extends AbstractService
implements JAIIIOService {
    public static final String NO_J2K_MSG = "The JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/ome/formats-library.html";

    public JAIIIOServiceImpl() {
        this.checkClassDependency(J2KImageWriteParam.class);
        this.checkClassDependency(J2KImageWriter.class);
        this.checkClassDependency(J2KImageWriterSpi.class);
        this.checkClassDependency(J2KImageReader.class);
        this.checkClassDependency(J2KImageReaderSpi.class);
    }

    public void writeImage(OutputStream out, BufferedImage img, boolean lossless, int[] codeBlockSize, double quality) throws IOException, ServiceException {
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageWriterSpi> iter = ServiceRegistry.lookupProviders(J2KImageWriterSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageWriterSpi spi = registry.getServiceProviderByClass(J2KImageWriterSpi.class);
        J2KImageWriter writer = new J2KImageWriter(spi);
        writer.setOutput(ios);
        String filter = lossless ? "w5x3" : "w9x7";
        IIOImage iioImage = new IIOImage(img, null, null);
        J2KImageWriteParam param = (J2KImageWriteParam)writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("JPEG2000");
        param.setLossless(lossless);
        param.setFilter(filter);
        param.setCodeBlockSize(codeBlockSize);
        param.setEncodingRate(quality);
        writer.write(null, iioImage, param);
        ios.close();
    }

    public BufferedImage readImage(InputStream in) throws IOException, ServiceException {
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageReaderSpi> iter = ServiceRegistry.lookupProviders(J2KImageReaderSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageReaderSpi spi = registry.getServiceProviderByClass(J2KImageReaderSpi.class);
        J2KImageReader reader = new J2KImageReader(spi);
        reader.setInput(mciis);
        return reader.read(0);
    }
}

