/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ScanrReader
extends FormatReader {
    private static final String XML_FILE = "experiment_descriptor.xml";
    private static final String EXPERIMENT_FILE = "experiment_descriptor.dat";
    private static final String ACQUISITION_FILE = "AcquisitionLog.dat";
    private static final String[] METADATA_SUFFIXES = new String[]{"dat", "xml"};
    private Vector<String> metadataFiles = new Vector();
    private int wellRows;
    private int wellColumns;
    private int fieldRows;
    private int fieldColumns;
    private int wellCount = 0;
    private Vector<String> channelNames = new Vector();
    private Hashtable<String, Integer> wellLabels = new Hashtable();
    private Hashtable<Integer, Integer> wellNumbers = new Hashtable();
    private String plateName;
    private Double pixelSize;
    private String[] tiffs;
    private MinimalTiffReader reader;

    public ScanrReader() {
        super("Olympus ScanR", new String[]{"dat", "xml", "tif"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        Location file = new Location(id).getAbsoluteFile();
        String name = file.getName();
        if (name.equals(XML_FILE) || name.equals(EXPERIMENT_FILE) || name.equals(ACQUISITION_FILE)) {
            return true;
        }
        Location parent = file.getParentFile();
        if (parent != null) {
            parent = parent.getParentFile();
        }
        return new Location(parent, XML_FILE).exists();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals(XML_FILE) || localName.equals(EXPERIMENT_FILE) || localName.equals(ACQUISITION_FILE)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(305);
        if (s == null) {
            return false;
        }
        String software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.trim().equals("National Instruments IMAQ");
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        for (String file : this.metadataFiles) {
            if (file == null) continue;
            files.add(file);
        }
        if (!noPixels && this.tiffs != null) {
            int offset = this.getSeries() * this.getImageCount();
            for (int i = 0; i < this.getImageCount(); ++i) {
                if (this.tiffs[offset + i] == null) continue;
                files.add(this.tiffs[offset + i]);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.tiffs = null;
            this.plateName = null;
            this.channelNames.clear();
            this.fieldColumns = 0;
            this.fieldRows = 0;
            this.wellColumns = 0;
            this.wellRows = 0;
            this.metadataFiles.clear();
            this.wellLabels.clear();
            this.wellNumbers.clear();
            this.wellCount = 0;
            this.pixelSize = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = this.getSeries() * this.getImageCount() + no;
        if (this.tiffs[index] != null) {
            this.reader.setId(this.tiffs[index]);
            this.reader.openBytes(0, buf, x, y, w, h);
            this.reader.close();
            ByteArrayHandle pixels = new ByteArrayHandle(buf);
            pixels.setOrder(this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < buf.length; i += 2) {
                pixels.seek(i);
                short value = pixels.readShort();
                value = (short)(value & 0xFFF);
                pixels.seek(i);
                pixels.writeShort(value);
            }
            buf = pixels.getBytes();
            pixels.close();
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Location dataDir;
        int nChannels;
        String[] list;
        super.initFile(id);
        if (this.metadataFiles.size() > 0) {
            return;
        }
        if (!ScanrReader.checkSuffix(id, "xml") && this.isGroupFiles()) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            if (ScanrReader.checkSuffix(id, "tif")) {
                parent = parent.getParentFile();
            }
            for (String file : list = parent.list()) {
                if (!file.equals(XML_FILE)) continue;
                id = new Location(parent, file).getAbsolutePath();
                super.initFile(id);
                break;
            }
            if (!ScanrReader.checkSuffix(id, "xml")) {
                throw new FormatException("Could not find experiment_descriptor.xml in " + parent.getAbsolutePath());
            }
        } else if (!this.isGroupFiles() && ScanrReader.checkSuffix(id, "tif")) {
            TiffReader r = new TiffReader();
            r.setMetadataStore(this.getMetadataStore());
            r.setId(id);
            this.core = r.getCoreMetadata();
            this.metadataStore = r.getMetadataStore();
            Hashtable<String, Object> globalMetadata = r.getGlobalMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key.toString(), globalMetadata.get(key));
            }
            r.close();
            this.tiffs = new String[]{id};
            this.reader = new MinimalTiffReader();
            return;
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        for (String file : list = dir.list(true)) {
            Location f = new Location(dir, file);
            if (f.isDirectory() || !ScanrReader.checkSuffix(file, METADATA_SUFFIXES)) continue;
            this.metadataFiles.add(f.getAbsolutePath());
        }
        String xml = DataTools.readFile(id).trim();
        if (xml.startsWith("<?")) {
            xml = xml.substring(xml.indexOf("?>") + 2);
        }
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + xml;
        XMLTools.parseXML(xml, (DefaultHandler)new ScanrHandler());
        Vector<String> uniqueRows = new Vector<String>();
        Vector<String> uniqueColumns = new Vector<String>();
        for (String well : this.wellLabels.keySet()) {
            if (!Character.isLetter(well.charAt(0))) continue;
            String row = well.substring(0, 1).trim();
            String column = well.substring(1).trim();
            if (!uniqueRows.contains(row) && row.length() > 0) {
                uniqueRows.add(row);
            }
            if (uniqueColumns.contains(column) || column.length() <= 0) continue;
            uniqueColumns.add(column);
        }
        this.wellRows = uniqueRows.size();
        this.wellColumns = uniqueColumns.size();
        if (this.wellRows * this.wellColumns != this.wellCount) {
            this.adjustWellDimensions();
        }
        int n = nChannels = this.getSizeC() == 0 ? this.channelNames.size() : this.getSizeC();
        if (nChannels == 0) {
            nChannels = 1;
        }
        int nSlices = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
        int nTimepoints = this.getSizeT();
        int nWells = this.wellCount;
        int nPos = this.fieldRows * this.fieldColumns;
        if (nPos == 0) {
            nPos = 1;
        }
        if ((list = (dataDir = new Location(dir, "data")).list(true)) == null) {
            list = dir.list(true);
        } else {
            dir = dataDir;
        }
        if ((nTimepoints == 0 || list.length < nTimepoints * nChannels * nSlices * nWells * nPos) && (nTimepoints = list.length / (nChannels * nWells * nPos * nSlices)) == 0) {
            nTimepoints = 1;
        }
        this.tiffs = new String[nChannels * nWells * nPos * nTimepoints * nSlices];
        int next = 0;
        String[] keys = this.wellLabels.keySet().toArray(new String[this.wellLabels.size()]);
        int realPosCount = 0;
        for (int well = 0; well < nWells; ++well) {
            int wellIndex = this.wellNumbers.get(well);
            String wellPos = this.getBlock(wellIndex, "W");
            int originalIndex = next;
            for (int pos = 0; pos < nPos; ++pos) {
                String posPos = this.getBlock(pos + 1, "P");
                int posIndex = next;
                for (int z = 0; z < nSlices; ++z) {
                    String zPos = this.getBlock(z, "Z");
                    for (int t = 0; t < nTimepoints; ++t) {
                        String tPos = this.getBlock(t, "T");
                        block12: for (int c = 0; c < nChannels; ++c) {
                            for (String file : list) {
                                if (file.indexOf(wellPos) == -1 || file.indexOf(zPos) == -1 || file.indexOf(posPos) == -1 || file.indexOf(tPos) == -1 || file.indexOf(this.channelNames.get(c)) == -1) continue;
                                this.tiffs[next++] = new Location(dir, file).getAbsolutePath();
                                continue block12;
                            }
                        }
                    }
                }
                if (posIndex == next) continue;
                ++realPosCount;
            }
            if (next != originalIndex || well >= keys.length) continue;
            this.wellLabels.remove(keys[well]);
        }
        if (this.wellLabels.size() > 0 && this.wellLabels.size() != nWells) {
            uniqueRows.clear();
            uniqueColumns.clear();
            for (String well : this.wellLabels.keySet()) {
                if (!Character.isLetter(well.charAt(0))) continue;
                String row = well.substring(0, 1).trim();
                String column = well.substring(1).trim();
                if (!uniqueRows.contains(row) && row.length() > 0) {
                    uniqueRows.add(row);
                }
                if (uniqueColumns.contains(column) || column.length() <= 0) continue;
                uniqueColumns.add(column);
            }
            nWells = uniqueRows.size() * uniqueColumns.size();
            this.adjustWellDimensions();
        }
        if (realPosCount < nPos) {
            nPos = realPosCount;
        }
        this.reader = new MinimalTiffReader();
        this.reader.setId(this.tiffs[0]);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int pixelType = this.reader.getPixelType();
        switch (pixelType) {
            case 0: {
                pixelType = 1;
                break;
            }
            case 2: {
                pixelType = 3;
            }
        }
        boolean rgb = this.reader.isRGB();
        boolean interleaved = this.reader.isInterleaved();
        boolean indexed = this.reader.isIndexed();
        boolean littleEndian = this.reader.isLittleEndian();
        this.reader.close();
        this.core = new CoreMetadata[nWells * nPos];
        for (int i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            this.core[i2] = new CoreMetadata();
            this.core[i2].sizeC = nChannels;
            this.core[i2].sizeZ = nSlices;
            this.core[i2].sizeT = nTimepoints;
            this.core[i2].sizeX = sizeX;
            this.core[i2].sizeY = sizeY;
            this.core[i2].pixelType = pixelType;
            this.core[i2].rgb = rgb;
            this.core[i2].interleaved = interleaved;
            this.core[i2].indexed = indexed;
            this.core[i2].littleEndian = littleEndian;
            this.core[i2].dimensionOrder = "XYCTZ";
            this.core[i2].imageCount = nSlices * nTimepoints * nChannels;
            this.core[i2].bitsPerPixel = 12;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        int nFields = this.fieldRows * this.fieldColumns;
        for (i = 0; i < this.getSeriesCount(); ++i) {
            MetadataTools.setDefaultCreationDate(store, id, i);
            int field = i % nFields;
            int well = i / nFields;
            int wellIndex = this.wellNumbers.get(well) - 1;
            int wellRow = wellIndex / this.wellColumns;
            int wellCol = wellIndex % this.wellColumns;
            store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
            store.setWellColumn(new NonNegativeInteger(Integer.valueOf(wellCol)), 0, well);
            store.setWellRow(new NonNegativeInteger(Integer.valueOf(wellRow)), 0, well);
            String wellSample = MetadataTools.createLSID("WellSample", 0, well, field);
            store.setWellSampleID(wellSample, 0, well, field);
            store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(i)), 0, well, field);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setWellSampleImageRef(imageID, 0, well, field);
            store.setImageID(imageID, i);
            String name = "Well " + (wellIndex + 1) + ", Field " + (field + 1) + " (Spot " + (i + 1) + ")";
            store.setImageName(name, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int c = 0; c < this.getSizeC(); ++c) {
                    store.setChannelName(this.channelNames.get(c), i, c);
                }
                if (this.pixelSize == null) continue;
                store.setPixelsPhysicalSizeX(this.pixelSize, i);
                store.setPixelsPhysicalSizeY(this.pixelSize, i);
            }
            String row = this.wellRows > 26 ? "Number" : "Letter";
            String col = this.wellRows > 26 ? "Letter" : "Number";
            store.setPlateRowNamingConvention(this.getNamingConvention(row), 0);
            store.setPlateColumnNamingConvention(this.getNamingConvention(col), 0);
            store.setPlateName(this.plateName, 0);
        }
    }

    private String getBlock(int index, String axis) {
        String b = String.valueOf(index);
        while (b.length() < 5) {
            b = "0" + b;
        }
        return axis + b;
    }

    private void adjustWellDimensions() {
        if (this.wellCount <= 8) {
            this.wellColumns = 2;
            this.wellRows = 4;
        } else if (this.wellCount <= 96) {
            this.wellColumns = 12;
            this.wellRows = 8;
        } else if (this.wellCount <= 384) {
            this.wellColumns = 24;
            this.wellRows = 16;
        }
    }

    class ScanrHandler
    extends DefaultHandler {
        private String key;
        private String value;
        private String qName;
        private String wellIndex;

        ScanrHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            String v = new String(ch, start, length);
            if (v.trim().length() == 0) {
                return;
            }
            if (this.qName.equals("Name")) {
                this.key = v;
            } else if (this.qName.equals("Val")) {
                this.value = v.trim();
                ScanrReader.this.addGlobalMeta(this.key, this.value);
                if (this.key.equals("columns/well")) {
                    ScanrReader.this.fieldColumns = Integer.parseInt(this.value);
                } else if (this.key.equals("rows/well")) {
                    ScanrReader.this.fieldRows = Integer.parseInt(this.value);
                } else if (this.key.equals("# slices")) {
                    ((ScanrReader)ScanrReader.this).core[0].sizeZ = Integer.parseInt(this.value);
                } else if (this.key.equals("timeloop real")) {
                    ((ScanrReader)ScanrReader.this).core[0].sizeT = Integer.parseInt(this.value);
                } else if (this.key.equals("timeloop count")) {
                    ((ScanrReader)ScanrReader.this).core[0].sizeT = Integer.parseInt(this.value) + 1;
                } else if (this.key.equals("name")) {
                    ScanrReader.this.channelNames.add(this.value);
                } else if (this.key.equals("plate name")) {
                    ScanrReader.this.plateName = this.value;
                } else if (this.key.equals("idle")) {
                    int lastIndex = ScanrReader.this.channelNames.size() - 1;
                    if (this.value.equals("0") && !((String)ScanrReader.this.channelNames.get(lastIndex)).equals("Autofocus")) {
                        ++((ScanrReader)ScanrReader.this).core[0].sizeC;
                    } else {
                        ScanrReader.this.channelNames.remove(lastIndex);
                    }
                } else if (this.key.equals("well selection table + cDNA")) {
                    if (Character.isDigit(this.value.charAt(0))) {
                        this.wellIndex = this.value;
                        ScanrReader.this.wellNumbers.put(new Integer(ScanrReader.this.wellCount), new Integer(this.value));
                        ScanrReader.this.wellCount++;
                    } else {
                        ScanrReader.this.wellLabels.put(this.value, new Integer(this.wellIndex));
                    }
                } else if (this.key.equals("conversion factor um/pixel")) {
                    ScanrReader.this.pixelSize = new Double(this.value);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.qName = qName;
        }
    }
}

