/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public abstract class ImageIOReader
extends BIFormatReader {
    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
        this.domains = new String[]{"Graphics"};
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(ras, 4096));
        BufferedImage b = ImageIO.read(dis);
        ras.close();
        dis.close();
        return b.getSubimage(x, y, w, h);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = 1;
        RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
        DataInputStream dis = new DataInputStream(ras);
        BufferedImage img = ImageIO.read(dis);
        dis.close();
        if (img == null) {
            throw new FormatException("Invalid image stream");
        }
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].rgb = img.getRaster().getNumBands() > 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? 3 : 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

