/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class AliconaReader
extends FormatReader {
    public static final String AL3D_MAGIC_STRING = "Alicona";
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).indexOf(AL3D_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int pad = (8 - this.getSizeX() % 8) % 8;
        int planeSize = (this.getSizeX() + pad) * this.getSizeY();
        for (int i = 0; i < this.numBytes; ++i) {
            this.in.seek(this.textureOffset + no * planeSize * (i + 1));
            this.in.skipBytes(y * (this.getSizeX() + pad));
            if (this.getSizeX() == w) {
                this.in.read(buf, i * w * h, w * h);
                continue;
            }
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x);
                this.in.read(buf, i * w * h + row * w, w);
                this.in.skipBytes(this.getSizeX() + pad - x - w);
            }
        }
        if (this.numBytes > 1) {
            byte[] tmp = new byte[buf.length];
            for (int i = 0; i < planeSize; ++i) {
                for (int j = 0; j < this.numBytes; ++j) {
                    tmp[i * this.numBytes + j] = buf[planeSize * j + i];
                }
            }
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = null;
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.numBytes = 0;
            this.textureOffset = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        LOGGER.info("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String workingDistance = null;
        String pntX = null;
        String pntY = null;
        for (int i = 0; i < count; ++i) {
            String key = this.in.readString(20).trim();
            String value = this.in.readString(30).trim();
            this.addGlobalMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
                continue;
            }
            if (key.equals("Rows")) {
                this.core[0].sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Cols")) {
                this.core[0].sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("NumberOfPlanes")) {
                this.core[0].imageCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
                continue;
            }
            if (key.equals("Voltage")) {
                voltage = value;
                continue;
            }
            if (key.equals("Magnification")) {
                magnification = value;
                continue;
            }
            if (key.equals("PixelSizeXMeter")) {
                pntX = value;
                continue;
            }
            if (key.equals("PixelSizeYMeter")) {
                pntY = value;
                continue;
            }
            if (!key.equals("WorkingDistance")) continue;
            workingDistance = value;
        }
        LOGGER.info("Populating metadata");
        this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.getSizeX() * this.getSizeY() * this.getImageCount());
        this.core[0].sizeC = hasC ? 3 : 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount() / this.getSizeC();
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = true;
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(this.numBytes, false, false);
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (voltage != null) {
                store.setDetectorSettingsVoltage(new Double(voltage), 0, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorSettingsID(detectorID, 0, 0);
                store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            }
            if (magnification != null) {
                store.setObjectiveCalibratedMagnification(new Double(magnification), 0, 0);
            }
            if (workingDistance != null) {
                store.setObjectiveWorkingDistance(new Double(workingDistance), 0, 0);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
            if (pntX != null && pntY != null) {
                double pixelSizeX = Double.parseDouble(pntX) * 1000000.0;
                double pixelSizeY = Double.parseDouble(pntY) * 1000000.0;
                store.setPixelsPhysicalSizeX(pixelSizeX, 0);
                store.setPixelsPhysicalSizeY(pixelSizeY, 0);
            }
        }
    }
}

