/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Path
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Path.class);
    private String definition;

    public Path() {
    }

    public Path(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Path".equals(tagName)) {
            LOGGER.debug("Expecting node name of Path got {}", (Object)tagName);
        }
        if (element.hasAttribute("Definition")) {
            this.setDefinition(String.valueOf(element.getAttribute("Definition")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Path_element) {
        if (Path_element == null) {
            Path_element = document.createElementNS(NAMESPACE, "Path");
        }
        if (this.definition != null) {
            Path_element.setAttribute("Definition", this.definition.toString());
        }
        return super.asXMLElement(document, Path_element);
    }
}

