/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.BinData;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mask
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Mask.class);
    private Double y;
    private Double x;
    private Double height;
    private Double width;
    private List<BinData> binDataList = new ArrayList<BinData>();

    public Mask() {
    }

    public Mask(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Mask".equals(tagName)) {
            LOGGER.debug("Expecting node name of Mask got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
        if (element.hasAttribute("Height")) {
            this.setHeight(Double.valueOf(element.getAttribute("Height")));
        }
        if (element.hasAttribute("Width")) {
            this.setWidth(Double.valueOf(element.getAttribute("Width")));
        }
        List<Element> BinData_nodeList = Mask.getChildrenByTagName(element, "BinData");
        for (Element BinData_element : BinData_nodeList) {
            this.addBinData(new BinData(BinData_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public int sizeOfBinDataList() {
        return this.binDataList.size();
    }

    public List<BinData> copyBinDataList() {
        return new ArrayList<BinData>(this.binDataList);
    }

    public BinData getBinData(int index) {
        return this.binDataList.get(index);
    }

    public BinData setBinData(int index, BinData binData) {
        return this.binDataList.set(index, binData);
    }

    public void addBinData(BinData binData) {
        this.binDataList.add(binData);
    }

    public void removeBinData(BinData binData) {
        this.binDataList.remove(binData);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Mask_element) {
        if (Mask_element == null) {
            Mask_element = document.createElementNS(NAMESPACE, "Mask");
        }
        if (this.y != null) {
            Mask_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Mask_element.setAttribute("X", this.x.toString());
        }
        if (this.height != null) {
            Mask_element.setAttribute("Height", this.height.toString());
        }
        if (this.width != null) {
            Mask_element.setAttribute("Width", this.width.toString());
        }
        if (this.binDataList != null) {
            for (BinData binDataList_value : this.binDataList) {
                Mask_element.appendChild(binDataList_value.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Mask_element);
    }
}

