/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Arc;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import ome.xml.model.Microscope;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.OTF;
import ome.xml.model.Objective;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrument
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Instrument.class);
    private String id;
    private Microscope microscope;
    private List<LightSource> lightSourceList = new ArrayList<LightSource>();
    private List<Detector> detectorList = new ArrayList<Detector>();
    private List<Objective> objectiveList = new ArrayList<Objective>();
    private List<FilterSet> filterSetList = new ArrayList<FilterSet>();
    private List<Filter> filterList = new ArrayList<Filter>();
    private List<Dichroic> dichroicList = new ArrayList<Dichroic>();
    private List<OTF> otfList = new ArrayList<OTF>();
    private List<Image> image_BackReferenceList = new ArrayList<Image>();

    public Instrument() {
    }

    public Instrument(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Microscope_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Instrument".equals(tagName)) {
            LOGGER.debug("Expecting node name of Instrument got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Instrument missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Microscope_nodeList = Instrument.getChildrenByTagName(element, "Microscope")).size() > 1) {
            throw new RuntimeException(String.format("Microscope node list size %d != 1", Microscope_nodeList.size()));
        }
        if (Microscope_nodeList.size() != 0) {
            this.setMicroscope(new Microscope(Microscope_nodeList.get(0), model));
        }
        List<Element> LightSource_nodeList = Instrument.getChildrenByTagName(element, "LightSource");
        for (Element LightSource_element : LightSource_nodeList) {
            List<Element> Laser_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Laser");
            for (Element Laser_element : Laser_nodeList) {
                Laser o = new Laser(LightSource_element, model);
                o.update(Laser_element, model);
                this.addLightSource(o);
            }
            List<Element> Filament_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Filament");
            for (Element Filament_element : Filament_nodeList) {
                Filament o = new Filament(LightSource_element, model);
                o.update(Filament_element, model);
                this.addLightSource(o);
            }
            List<Element> Arc_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Arc");
            for (Element Arc_element : Arc_nodeList) {
                Arc o = new Arc(LightSource_element, model);
                o.update(Arc_element, model);
                this.addLightSource(o);
            }
            List<Element> LightEmittingDiode_nodeList = Instrument.getChildrenByTagName(LightSource_element, "LightEmittingDiode");
            for (Element LightEmittingDiode_element : LightEmittingDiode_nodeList) {
                LightEmittingDiode o = new LightEmittingDiode(LightSource_element, model);
                o.update(LightEmittingDiode_element, model);
                this.addLightSource(o);
            }
        }
        List<Element> Detector_nodeList = Instrument.getChildrenByTagName(element, "Detector");
        for (Element Detector_element : Detector_nodeList) {
            this.addDetector(new Detector(Detector_element, model));
        }
        List<Element> Objective_nodeList = Instrument.getChildrenByTagName(element, "Objective");
        for (Element Objective_element : Objective_nodeList) {
            this.addObjective(new Objective(Objective_element, model));
        }
        List<Element> FilterSet_nodeList = Instrument.getChildrenByTagName(element, "FilterSet");
        for (Element FilterSet_element : FilterSet_nodeList) {
            this.addFilterSet(new FilterSet(FilterSet_element, model));
        }
        List<Element> Filter_nodeList = Instrument.getChildrenByTagName(element, "Filter");
        for (Element Filter_element : Filter_nodeList) {
            this.addFilter(new Filter(Filter_element, model));
        }
        List<Element> Dichroic_nodeList = Instrument.getChildrenByTagName(element, "Dichroic");
        for (Element Dichroic_element : Dichroic_nodeList) {
            this.addDichroic(new Dichroic(Dichroic_element, model));
        }
        List<Element> OTF_nodeList = Instrument.getChildrenByTagName(element, "OTF");
        for (Element OTF_element : OTF_nodeList) {
            this.addOTF(new OTF(OTF_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Microscope getMicroscope() {
        return this.microscope;
    }

    public void setMicroscope(Microscope microscope) {
        this.microscope = microscope;
    }

    public int sizeOfLightSourceList() {
        return this.lightSourceList.size();
    }

    public List<LightSource> copyLightSourceList() {
        return new ArrayList<LightSource>(this.lightSourceList);
    }

    public LightSource getLightSource(int index) {
        return this.lightSourceList.get(index);
    }

    public LightSource setLightSource(int index, LightSource lightSource) {
        return this.lightSourceList.set(index, lightSource);
    }

    public void addLightSource(LightSource lightSource) {
        this.lightSourceList.add(lightSource);
    }

    public void removeLightSource(LightSource lightSource) {
        this.lightSourceList.remove(lightSource);
    }

    public int sizeOfDetectorList() {
        return this.detectorList.size();
    }

    public List<Detector> copyDetectorList() {
        return new ArrayList<Detector>(this.detectorList);
    }

    public Detector getDetector(int index) {
        return this.detectorList.get(index);
    }

    public Detector setDetector(int index, Detector detector) {
        return this.detectorList.set(index, detector);
    }

    public void addDetector(Detector detector) {
        this.detectorList.add(detector);
    }

    public void removeDetector(Detector detector) {
        this.detectorList.remove(detector);
    }

    public int sizeOfObjectiveList() {
        return this.objectiveList.size();
    }

    public List<Objective> copyObjectiveList() {
        return new ArrayList<Objective>(this.objectiveList);
    }

    public Objective getObjective(int index) {
        return this.objectiveList.get(index);
    }

    public Objective setObjective(int index, Objective objective) {
        return this.objectiveList.set(index, objective);
    }

    public void addObjective(Objective objective) {
        this.objectiveList.add(objective);
    }

    public void removeObjective(Objective objective) {
        this.objectiveList.remove(objective);
    }

    public int sizeOfFilterSetList() {
        return this.filterSetList.size();
    }

    public List<FilterSet> copyFilterSetList() {
        return new ArrayList<FilterSet>(this.filterSetList);
    }

    public FilterSet getFilterSet(int index) {
        return this.filterSetList.get(index);
    }

    public FilterSet setFilterSet(int index, FilterSet filterSet) {
        return this.filterSetList.set(index, filterSet);
    }

    public void addFilterSet(FilterSet filterSet) {
        this.filterSetList.add(filterSet);
    }

    public void removeFilterSet(FilterSet filterSet) {
        this.filterSetList.remove(filterSet);
    }

    public int sizeOfFilterList() {
        return this.filterList.size();
    }

    public List<Filter> copyFilterList() {
        return new ArrayList<Filter>(this.filterList);
    }

    public Filter getFilter(int index) {
        return this.filterList.get(index);
    }

    public Filter setFilter(int index, Filter filter) {
        return this.filterList.set(index, filter);
    }

    public void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filterList.remove(filter);
    }

    public int sizeOfDichroicList() {
        return this.dichroicList.size();
    }

    public List<Dichroic> copyDichroicList() {
        return new ArrayList<Dichroic>(this.dichroicList);
    }

    public Dichroic getDichroic(int index) {
        return this.dichroicList.get(index);
    }

    public Dichroic setDichroic(int index, Dichroic dichroic) {
        return this.dichroicList.set(index, dichroic);
    }

    public void addDichroic(Dichroic dichroic) {
        this.dichroicList.add(dichroic);
    }

    public void removeDichroic(Dichroic dichroic) {
        this.dichroicList.remove(dichroic);
    }

    public int sizeOfOTFList() {
        return this.otfList.size();
    }

    public List<OTF> copyOTFList() {
        return new ArrayList<OTF>(this.otfList);
    }

    public OTF getOTF(int index) {
        return this.otfList.get(index);
    }

    public OTF setOTF(int index, OTF otf) {
        return this.otfList.set(index, otf);
    }

    public void addOTF(OTF otf) {
        this.otfList.add(otf);
    }

    public void removeOTF(OTF otf) {
        this.otfList.remove(otf);
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Instrument_element) {
        if (Instrument_element == null) {
            Instrument_element = document.createElementNS(NAMESPACE, "Instrument");
        }
        if (this.id != null) {
            Instrument_element.setAttribute("ID", this.id.toString());
        }
        if (this.microscope != null) {
            Instrument_element.appendChild(this.microscope.asXMLElement(document));
        }
        if (this.lightSourceList != null) {
            for (LightSource lightSourceList_value : this.lightSourceList) {
                Instrument_element.appendChild(lightSourceList_value.asXMLElement(document));
            }
        }
        if (this.detectorList != null) {
            for (Detector detectorList_value : this.detectorList) {
                Instrument_element.appendChild(detectorList_value.asXMLElement(document));
            }
        }
        if (this.objectiveList != null) {
            for (Objective objectiveList_value : this.objectiveList) {
                Instrument_element.appendChild(objectiveList_value.asXMLElement(document));
            }
        }
        if (this.filterSetList != null) {
            for (FilterSet filterSetList_value : this.filterSetList) {
                Instrument_element.appendChild(filterSetList_value.asXMLElement(document));
            }
        }
        if (this.filterList != null) {
            for (Filter filterList_value : this.filterList) {
                Instrument_element.appendChild(filterList_value.asXMLElement(document));
            }
        }
        if (this.dichroicList != null) {
            for (Dichroic dichroicList_value : this.dichroicList) {
                Instrument_element.appendChild(dichroicList_value.asXMLElement(document));
            }
        }
        if (this.otfList != null) {
            for (OTF otfList_value : this.otfList) {
                Instrument_element.appendChild(otfList_value.asXMLElement(document));
            }
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Instrument_element);
    }
}

