/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.FilterSet;
import ome.xml.model.LightPath;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dichroic
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Dichroic.class);
    private String id;
    private List<FilterSet> filterSet_BackReferenceList = new ArrayList<FilterSet>();
    private List<LightPath> lightPath_BackReferenceList = new ArrayList<LightPath>();

    public Dichroic() {
    }

    public Dichroic(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Dichroic".equals(tagName)) {
            LOGGER.debug("Expecting node name of Dichroic got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Dichroic missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedFilterSetList() {
        return this.filterSet_BackReferenceList.size();
    }

    public List<FilterSet> copyLinkedFilterSetList() {
        return new ArrayList<FilterSet>(this.filterSet_BackReferenceList);
    }

    public FilterSet getLinkedFilterSet(int index) {
        return this.filterSet_BackReferenceList.get(index);
    }

    public FilterSet setLinkedFilterSet(int index, FilterSet o) {
        return this.filterSet_BackReferenceList.set(index, o);
    }

    public boolean linkFilterSet(FilterSet o) {
        return this.filterSet_BackReferenceList.add(o);
    }

    public boolean unlinkFilterSet(FilterSet o) {
        return this.filterSet_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedLightPathList() {
        return this.lightPath_BackReferenceList.size();
    }

    public List<LightPath> copyLinkedLightPathList() {
        return new ArrayList<LightPath>(this.lightPath_BackReferenceList);
    }

    public LightPath getLinkedLightPath(int index) {
        return this.lightPath_BackReferenceList.get(index);
    }

    public LightPath setLinkedLightPath(int index, LightPath o) {
        return this.lightPath_BackReferenceList.set(index, o);
    }

    public boolean linkLightPath(LightPath o) {
        return this.lightPath_BackReferenceList.add(o);
    }

    public boolean unlinkLightPath(LightPath o) {
        return this.lightPath_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Dichroic_element) {
        if (Dichroic_element == null) {
            Dichroic_element = document.createElementNS(NAMESPACE, "Dichroic");
        }
        if (this.id != null) {
            Dichroic_element.setAttribute("ID", this.id.toString());
        }
        if (this.filterSet_BackReferenceList != null) {
            // empty if block
        }
        if (this.lightPath_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Dichroic_element);
    }
}

