/*
 * Decompiled with CFR 0.152.
 */
package loci.common.services;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import loci.common.services.DependencyException;
import loci.common.services.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceFactory.class);
    private static final String DEFAULT_PROPERTIES_FILE = "services.properties";
    private static Map<Class<? extends Service>, Constructor<? extends Service>> constructorCache = new HashMap<Class<? extends Service>, Constructor<? extends Service>>();
    private Map<Class<? extends Service>, Class<? extends Service>> services = new HashMap<Class<? extends Service>, Class<? extends Service>>();

    public ServiceFactory() throws DependencyException {
        this(DEFAULT_PROPERTIES_FILE);
    }

    public ServiceFactory(String path) throws DependencyException {
        InputStream stream = this.getClass().getResourceAsStream(path);
        Properties properties = new Properties();
        if (stream == null) {
            throw new DependencyException(path + " not found on CLASSPATH");
        }
        try {
            properties.load(stream);
            LOGGER.debug("Loaded properties from: {}", (Object)path);
        }
        catch (Throwable t) {
            throw new DependencyException(t);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing properties file stream.", (Throwable)e);
            }
        }
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String interfaceName = (String)entry.getKey();
            String implementationName = (String)entry.getValue();
            Class<?> interfaceClass = null;
            Class<?> implementationClass = null;
            try {
                interfaceClass = Class.forName((String)entry.getKey());
            }
            catch (Throwable t) {
                LOGGER.debug("CLASSPATH missing interface: {}", (Object)interfaceName, (Object)t);
                continue;
            }
            try {
                implementationClass = Class.forName((String)entry.getValue());
            }
            catch (Throwable t) {
                LOGGER.debug("CLASSPATH missing implementation or implementation dependency: {}", (Object)implementationName, (Object)t);
            }
            this.services.put(interfaceClass, implementationClass);
            LOGGER.debug("Added interface {} and implementation {}", interfaceClass, implementationClass);
        }
    }

    public <T extends Service> T getInstance(Class<T> type) throws DependencyException {
        Class<? extends Service> impl = this.services.get(type);
        if (impl == null && this.services.containsKey(type)) {
            throw new DependencyException("Unable to instantiate service. Missing implementation or implementation dependency", type);
        }
        if (impl == null) {
            throw new DependencyException("Unknown service type: " + type);
        }
        Constructor<? extends Service> constructor = this.getConstructor(impl);
        try {
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new DependencyException("Unable to instantiate service", type, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Service> Constructor<T> getConstructor(Class<T> klass) throws DependencyException {
        Map<Class<? extends Service>, Constructor<? extends Service>> map = constructorCache;
        synchronized (map) {
            Constructor<Service> constructor = constructorCache.get(klass);
            if (constructor == null) {
                try {
                    Class<?> concreteClass = Class.forName(klass.getName());
                    constructor = concreteClass.getDeclaredConstructor(new Class[0]);
                    constructorCache.put(klass, constructor);
                }
                catch (Throwable t) {
                    throw new DependencyException("Unable to retrieve constructor", klass, t);
                }
            }
            return constructor;
        }
    }
}

