/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.DialogControl;

class ScreenControl {
    private int xAbs;
    private int yAbs;
    private int xView;
    private int yView;
    private boolean dragging;
    private Cursor initialCursor;
    private DialogControl controller;

    private void setCursor(Cursor c) {
        this.controller.getModel().getRootPane().setCursor(c);
    }

    private void moveFrame(MouseEvent e) {
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        int deltaX = this.xAbs - p.x;
        int deltaY = this.yAbs - p.y;
        Rectangle r = this.controller.getModel().getBounds();
        int newX = r.x - deltaX;
        int newY = r.y - deltaY;
        this.controller.getModel().setLocation(newX, newY);
    }

    ScreenControl(DialogControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.dragging = false;
        this.initialCursor = controller.getModel().getRootPane().getCursor();
    }

    void mousePressed(MouseEvent e) {
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        this.xView = e.getX();
        this.yView = e.getY();
        this.xAbs = p.x;
        this.yAbs = p.y;
        Insets i = this.controller.getModel().getInsets();
        Point ep = new Point(this.xView, this.yView);
        if (ep.x > i.left && ep.y > i.top && ep.x < this.controller.getModel().getWidth() - i.right) {
            this.dragging = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
            return;
        }
    }

    void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.moveFrame(e);
        this.setCursor(this.initialCursor);
        this.dragging = false;
    }

    void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        if ((e.getModifiers() & 0x10) != 16) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.moveFrame(e);
    }
}

