/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openmicroscopy.shoola.util.ui.omeeditpane.AttributeSetFactory;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMERegexFormatter;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

public class RegexTextPane
extends JTextPane
implements DocumentListener {
    public static final String FONT_FAMILY = "Arial";
    public static final int FONT_SIZE = 12;
    public static final String REGEX_DBL_CLICKED_PROPERTY = "regexDblClicked";
    private OMERegexFormatter regexFormatter;
    private SimpleAttributeSet plainText;
    private StyledDocument doc;
    private Set<String> regexStrings;

    private void parseRegex(int caretPosition) {
        this.regexFormatter.parseRegex(this.doc, true);
    }

    private void installListeners() {
        this.getDocument().addDocumentListener(this);
        this.addMouseListener(new UrlMouseListener());
    }

    private void initialize(String fontFamily, int fontSize) {
        if (fontFamily == null || fontFamily.length() == 0) {
            fontFamily = FONT_FAMILY;
        }
        if (fontSize < 4) {
            fontSize = 12;
        }
        this.doc = this.getStyledDocument();
        this.regexStrings = new HashSet<String>();
        this.plainText = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.plainText, fontFamily);
        StyleConstants.setFontSize(this.plainText, fontSize);
        this.regexFormatter = new OMERegexFormatter(this.plainText);
        this.installListeners();
    }

    public RegexTextPane() {
        this.initialize(this.getFont().getFamily(), this.getFont().getSize());
    }

    public RegexTextPane(String fontFamily, int fontSize) {
        this.initialize(fontFamily, fontSize);
    }

    public void installDefaultRegEx() {
        this.addRegex("(Image|image|Image's) (ID|id): ([0-9]+)", AttributeSetFactory.createURLAttributeSet());
        this.addRegex("(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", AttributeSetFactory.createURLAttributeSet());
    }

    public void addRegex(String regex, SimpleAttributeSet styleSet) {
        if (regex == null || styleSet == null) {
            return;
        }
        if (regex.trim().length() == 0) {
            return;
        }
        this.regexStrings.add(regex);
        this.regexFormatter.addRegex(regex, styleSet);
    }

    public void setText(String text) {
        int caret = this.getCaretPosition();
        super.setText(text);
        try {
            this.setCaretPosition(caret);
        }
        catch (IllegalArgumentException ex) {
            this.setCaretPosition(0);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.parseRegex(e.getOffset());
    }

    public void removeUpdate(DocumentEvent e) {
        this.parseRegex(e.getOffset());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    static /* synthetic */ StyledDocument access$000(RegexTextPane x0) {
        return x0.doc;
    }

    static /* synthetic */ Set access$100(RegexTextPane x0) {
        return x0.regexStrings;
    }

    static /* synthetic */ void access$200(RegexTextPane x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }

    private class UrlMouseListener
    extends MouseAdapter {
        private UrlMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point mouseLoc = e.getPoint();
            int offset = RegexTextPane.this.viewToModel(mouseLoc);
            if (e.getClickCount() == 2) {
                String text = "";
                try {
                    text = RegexTextPane.this.doc.getText(0, RegexTextPane.this.doc.getLength());
                    HashMap<Position, String> matches = new HashMap<Position, String>();
                    for (String regex : RegexTextPane.this.regexStrings) {
                        WikiView.findGroups(text, regex, matches);
                        for (Map.Entry entry : matches.entrySet()) {
                            Position p = (Position)entry.getKey();
                            if (!p.contains(offset, offset)) continue;
                            String fullMatch = RegexTextPane.this.doc.getText(p.getStart(), p.getEnd() - p.getStart());
                            String group = (String)entry.getValue();
                            RegexTextPane.this.firePropertyChange(RegexTextPane.REGEX_DBL_CLICKED_PROPERTY, null, new WikiDataObject(regex, group, fullMatch));
                            return;
                        }
                    }
                }
                catch (BadLocationException e2) {
                    // empty catch block
                }
            }
        }
    }
}

