/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.Timer;
import org.openmicroscopy.shoola.util.ui.omeeditpane.FormatSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEEditorKit;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.SelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OMEEditPane
extends JTextPane
implements ActionListener,
FocusListener {
    private static final int DELAY = 400;
    private static String DOC_TYPE = "text/wiki";
    private OMEEditorKit editorKit;
    private OMEWikiComponent component;
    private Timer timer;
    private int count;
    private Point location;

    private void handleMousePressed() {
        if (this.timer == null) {
            this.timer = new Timer(400, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    OMEEditPane(OMEWikiComponent component, Map<String, FormatSelectionAction> formatters) {
        this.component = component;
        this.editorKit = new OMEEditorKit(formatters);
        this.setEditorKitForContentType(DOC_TYPE, this.editorKit);
        this.setContentType(DOC_TYPE);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                OMEEditPane.this.handleMousePressed();
                OMEEditPane.this.count++;
                OMEEditPane.this.location = e.getPoint();
            }
        });
        this.addFocusListener(this);
    }

    void addFormatter(String value, FormatSelectionAction action) {
        this.editorKit.addFormatter(value, action);
    }

    @Override
    public void focusGained(FocusEvent e) {
        String text = this.getText();
        if (text != null) {
            if (this.component.getDefaultText().equals(text)) {
                this.selectAll();
            } else {
                this.setText(text);
                int n = this.getDocument().getLength();
                if (n >= 0) {
                    this.setCaretPosition(n);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.select(0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.count == 1 || this.count == 2) {
            int index = this.viewToModel(this.location);
            WikiView view = this.editorKit.getView();
            SelectionAction action = view.getSelectionAction(index);
            this.component.onSelection(action, view.getSelectedText(index), this.count);
            this.timer.stop();
            this.count = 0;
        }
    }

    static /* synthetic */ void access$000(OMEEditPane x0) {
        x0.handleMousePressed();
    }

    static /* synthetic */ int access$108(OMEEditPane x0) {
        return x0.count++;
    }

    static /* synthetic */ Point access$202(OMEEditPane x0, Point x1) {
        x0.location = x1;
        return x0.location;
    }
}

