/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import org.openmicroscopy.shoola.util.ui.colour.HSV;

class ColourSliderUI
extends BasicSliderUI {
    private static final Color TRACK_BORDER_COLOUR = new Color(128, 128, 128);
    private int colourSpace;
    private Color RGBStart;
    private Color RGBEnd;
    private HSV HSVStart;
    private int channel;
    private HSV HSVEnd;
    private Color trackBorderColour;
    private Rectangle smallTrack;
    private Rectangle smallTrackFilled;

    ColourSliderUI(JSlider slider, Color s, Color e) {
        super(slider);
        this.setColourSpace(0);
        this.RGBStart = s;
        this.RGBEnd = e;
        this.trackBorderColour = TRACK_BORDER_COLOUR;
    }

    ColourSliderUI(JSlider slider, HSV s, HSV e) {
        super(slider);
        this.setColourSpace(1);
        this.HSVStart = s;
        this.HSVEnd = e;
        this.channel = 2;
        this.trackBorderColour = TRACK_BORDER_COLOUR;
    }

    void setColourSpace(int colourSpace) {
        this.colourSpace = colourSpace;
    }

    int getColourSpace() {
        return this.colourSpace;
    }

    void setHSVStart(HSV c) {
        this.HSVStart = new HSV(c);
    }

    void setHSVEnd(HSV c) {
        this.HSVEnd = new HSV(c);
    }

    void setHSVStart(Color c) {
        this.HSVStart = new HSV(c);
    }

    void setHSVEnd(Color c) {
        this.HSVEnd = new HSV(c);
    }

    void setChannel(int c) {
        this.channel = c;
    }

    void setRGBStart(Color s) {
        this.RGBStart = new Color(s.getRed(), s.getGreen(), s.getBlue(), s.getAlpha());
    }

    void setRGBEnd(Color e) {
        this.RGBEnd = new Color(e.getRed(), e.getGreen(), e.getBlue(), e.getAlpha());
    }

    public void paintTrack(Graphics og) {
        Graphics2D g = (Graphics2D)og;
        this.smallTrack = new Rectangle(this.trackRect);
        if (this.slider.getOrientation() == 0) {
            this.smallTrack.y += this.smallTrack.height / 3;
            this.smallTrack.height = (int)((float)this.smallTrack.height * 0.75f);
            this.smallTrackFilled = new Rectangle(this.smallTrack);
            ++this.smallTrackFilled.x;
            ++this.smallTrackFilled.y;
            --this.smallTrackFilled.height;
            --this.smallTrackFilled.width;
            g.setColor(this.trackBorderColour);
            g.fillRect(this.smallTrack.x + 1, this.smallTrack.y + this.smallTrack.height + 1, 1, 8);
            g.fillRect(this.smallTrack.x + this.smallTrack.width / 2, this.smallTrack.y + this.smallTrack.height + 1, 1, 8);
            g.fillRect(this.smallTrack.x + this.smallTrack.width - 2, this.smallTrack.y + this.smallTrack.height + 1, 1, 8);
            g.setPaint(this.trackBorderColour);
            g.draw(this.smallTrack);
            if (this.colourSpace == 0) {
                GradientPaint gp = new GradientPaint((int)this.smallTrackFilled.getX(), (int)this.smallTrackFilled.getY(), this.RGBStart, (int)this.smallTrackFilled.getWidth(), (int)this.smallTrackFilled.getHeight(), this.RGBEnd, false);
                g.setPaint(gp);
                g.fill(this.smallTrackFilled);
            } else {
                g.fill(this.smallTrackFilled);
                float start = this.slider.getMinimum();
                float end = this.slider.getMaximum();
                float range = end - start;
                start /= 255.0f;
                end /= 255.0f;
                range /= 255.0f;
                float steps = (float)(this.smallTrackFilled.getWidth() / 255.0);
                for (int x = 0; x < 255; ++x) {
                    if (this.channel == 0) {
                        this.HSVStart.setHue(start + (float)x / 255.0f * range);
                    }
                    if (this.channel == 1) {
                        this.HSVStart.setSaturation(start + (float)x / 255.0f * range);
                    }
                    if (this.channel == 2) {
                        this.HSVStart.setValue(start + (float)x / 255.0f * range);
                    }
                    g.setPaint(this.HSVStart.toColor());
                    g.fillRect((int)(this.smallTrackFilled.getX() + (double)((float)x * steps)), (int)this.smallTrackFilled.getY(), (int)Math.ceil(steps), (int)this.smallTrackFilled.getHeight());
                }
            }
        } else {
            this.smallTrack.width = (int)((float)this.smallTrack.width * 0.75f);
            this.smallTrackFilled = new Rectangle(this.smallTrack);
            ++this.smallTrackFilled.x;
            ++this.smallTrackFilled.y;
            --this.smallTrackFilled.height;
            --this.smallTrackFilled.width;
            if (this.colourSpace == 0) {
                GradientPaint gp = new GradientPaint((int)this.smallTrackFilled.getX(), (int)this.smallTrackFilled.getY(), this.RGBEnd, (int)this.smallTrackFilled.getWidth(), (int)this.smallTrackFilled.getHeight(), this.RGBStart, false);
                g.setPaint(gp);
                g.fill(this.smallTrackFilled);
            } else {
                g.fill(this.smallTrackFilled);
                float start = this.slider.getMinimum();
                float end = this.slider.getMaximum();
                float range = end - start;
                start /= 255.0f;
                end /= 255.0f;
                range /= 255.0f;
                float steps = (float)(this.smallTrackFilled.getHeight() / 255.0);
                for (int x = 0; x < 255; ++x) {
                    if (this.channel == 0) {
                        this.HSVStart.setHue(end - (float)x / 255.0f * range);
                    }
                    if (this.channel == 1) {
                        this.HSVStart.setSaturation(end - (float)x / 255.0f * range);
                    }
                    if (this.channel == 2) {
                        this.HSVStart.setValue(end - (float)x / 255.0f * range);
                    }
                    g.setPaint(this.HSVStart.toColor());
                    g.fillRect((int)this.smallTrackFilled.getX(), (int)(this.smallTrackFilled.getY() + (double)((float)x * steps)), (int)this.smallTrackFilled.getWidth(), (int)Math.ceil(steps));
                }
            }
            g.setColor(this.trackBorderColour);
            g.fillRect(this.smallTrack.x + this.smallTrack.width + 1, this.smallTrack.y + 1, 8, 1);
            g.fillRect(this.smallTrack.x + this.smallTrack.width + 1, this.smallTrack.y + this.smallTrack.height / 2, 8, 1);
            g.fillRect(this.smallTrack.x + this.smallTrack.width + 1, this.smallTrack.y + this.smallTrack.height - 2, 8, 1);
            g.setPaint(this.trackBorderColour);
            g.draw(this.smallTrack);
        }
    }
}

