/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.util.ui.FileTable;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MessengerDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final int ERROR_TYPE = 0;
    public static final int COMMENT_TYPE = 1;
    public static final int SUBMIT_ERROR_TYPE = 2;
    public static final String SEND_PROPERTY = "send";
    public static final String CLOSE_MESSENGER_PROPERTY = "closeMessenger";
    private static final int CANCEL = 0;
    private static final int SEND = 1;
    private static final int COPY = 4;
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 400);
    private static final String CANCEL_TOOLTIP = "Cancel your message";
    private static final String SEND_TOOLTIP = "Send the information to the development team";
    private static final String COPY_TOOLTIP = "Copy the Exception Message to the clipboard";
    private static final String MESSAGE = "Thank you for taking the time to send us your comments. \n\nYour feedback will be used to further the development of OMERO and improve our software. Any personal details you provide are purely optional, and will only be used for development purposes.\n\n";
    private static final String DEBUG_MESSAGE = "An error message has been generated by the application.\n\nTo help us improve our software, please fill out the following form. Your personal details are purely optional, and will only be used for development purposes.\n\nPlease note that your application may need to be restarted to work properly.";
    private static final String SUBMIT_MESSAGE = "Review TEXT.";
    private static final String EMAIL_MESSAGE = "The e-mail address entered \n does not seem to be valid. \n Please enter a new e-mail address.";
    private static final String COMMENT_FIELD = "Comment: ";
    private static final String DEBUG_COMMENT_FIELD = "What you were doing when you crashed?";
    private static final String EMAIL_FIELD = "Email: ";
    private static final String EMAIL_TOOLTIP = "Enter your email address here.";
    private static final String EMAIL_SUFFIX = " (Optional)";
    private static final String ERROR_BRIEF = "Brief Description:";
    private int dialogType;
    private JButton cancelButton;
    private JButton sendButton;
    private JTextField emailArea;
    private MultilineLabel commentArea;
    private String emailAddress;
    private Exception exception;
    private JTextPane debugArea;
    private JButton copyButton;
    private String serverVersion;
    private String errorDescription;
    private FileTable table;
    private JXBusyLabel submitStatus;

    private void formatButton(JButton b, int mnemonic, String tooltip, int actionID) {
        b.setMnemonic(mnemonic);
        b.setOpaque(false);
        b.setToolTipText(tooltip);
        b.addActionListener(this);
        b.setActionCommand("" + actionID);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CLOSE_MESSENGER_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void copy() {
        if (this.debugArea != null) {
            this.debugArea.selectAll();
            this.debugArea.copy();
        }
    }

    private void sendError(String propertyName) {
        String email = this.emailArea.getText().trim();
        String comment = this.commentArea.getText().trim();
        String error = null;
        if (this.debugArea != null) {
            error = this.debugArea.getText().trim();
        }
        MessengerDetails details = new MessengerDetails(email, comment);
        details.setExtra(this.serverVersion);
        details.setError(error);
        this.firePropertyChange(propertyName, null, details);
        this.close();
    }

    private void send(String propertyName) {
        if (this.dialogType == 2) {
            List<FileTableNode> files = null;
            if (this.table != null) {
                files = this.table.getSelectedFiles();
            }
            if (files == null || files.size() == 0) {
                this.sendError(propertyName);
            } else {
                String email = this.emailArea.getText().trim();
                String comment = this.commentArea.getText().trim();
                MessengerDetails details = new MessengerDetails(email, comment);
                details.setExtra(this.serverVersion);
                details.setObjectToSubmit(files);
                this.submitStatus.setVisible(true);
                this.submitStatus.setBusy(true);
                this.firePropertyChange(propertyName, null, details);
            }
        } else {
            this.sendError(propertyName);
        }
        this.sendButton.setEnabled(false);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MessengerDialog.this.close();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.formatButton(this.cancelButton, 67, CANCEL_TOOLTIP, 0);
        this.sendButton = new JButton("Send");
        this.formatButton(this.sendButton, 83, SEND_TOOLTIP, 1);
        this.emailArea = new JTextField(20);
        this.emailArea.setToolTipText(EMAIL_TOOLTIP);
        this.emailArea.setText(this.emailAddress);
        this.commentArea = new MultilineLabel();
        this.commentArea.setEditable(true);
        this.commentArea.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.commentArea.setOpaque(true);
        if (this.exception != null) {
            this.debugArea = this.buildExceptionArea();
            this.copyButton = new JButton("Copy to Clipboard");
            this.formatButton(this.copyButton, 67, COPY_TOOLTIP, 4);
        }
        this.setAlwaysOnTop(true);
        if (this.dialogType == 1) {
            this.sendButton.setEnabled(false);
            this.commentArea.getDocument().addDocumentListener(this);
        }
        this.submitStatus = new JXBusyLabel(new Dimension(16, 16));
        this.submitStatus.setText("Uploading files");
        this.submitStatus.setVisible(false);
    }

    private JTextPane buildExceptionArea() {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        float pos = 15.0f;
        int align = 0;
        int leader = 0;
        TabStop tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 1;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 2;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 4;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        TabSet tabs = new TabSet(list.toArray(new TabStop[0]));
        Style style = textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, tabs);
        textPane.setLogicalStyle(style);
        Style debugStyle = document.addStyle("StyleName", null);
        StyleConstants.setForeground(debugStyle, Color.BLACK);
        StyleConstants.setFontFamily(debugStyle, "SansSerif");
        StyleConstants.setFontSize(debugStyle, 12);
        StyleConstants.setBold(debugStyle, false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        try {
            document.insertString(document.getLength(), sw.toString(), style);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return textPane;
    }

    private JPanel buildCommentAreaPanel(String comment, int mnemonic) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JScrollPane areaScrollPane = new JScrollPane(this.commentArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        JLabel label = new JLabel(comment);
        label.setOpaque(false);
        label.setDisplayedMnemonic(mnemonic);
        panel.add((Component)label, "0, 0, LEFT, CENTER");
        panel.add((Component)areaScrollPane, "0, 1");
        return panel;
    }

    private JPanel buildEmailAreaPanel(int mnemonic) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = EMAIL_SUFFIX.length() == 0 ? (Object)new double[][]{{-2.0, -1.0}, {30.0}} : (Object)new double[][]{{-2.0, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(EMAIL_FIELD);
        label.setDisplayedMnemonic(mnemonic);
        label.setLabelFor(this.emailArea);
        label.setOpaque(false);
        panel.add((Component)label, "0, 0, RIGHT, CENTER");
        panel.add((Component)this.emailArea, "1, 0, FULL, CENTER");
        if (EMAIL_SUFFIX.length() != 0) {
            panel.add((Component)new JLabel(EMAIL_SUFFIX), "2, 0, LEFT, CENTER");
        }
        return panel;
    }

    private JPanel buildDebugPane() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0}, {-1.0, 32.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane pane = new JScrollPane(this.debugArea);
        panel.add((Component)pane, "0, 0");
        panel.add((Component)this.copyButton, "0, 1, CENTER, BOTTOM");
        return panel;
    }

    private JPanel buildFilesToSubmitPane(Map toSubmit) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0}, {-1.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.table = new FileTable(toSubmit);
        JScrollPane pane = new JScrollPane(this.table);
        panel.add((Component)pane, "0, 0");
        return panel;
    }

    private JPanel buildCommentPane(String comment) {
        JPanel commentPanel = new JPanel();
        int iconSpace = 0;
        double[][] tableSize = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {0.0, 0.0, 30.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        commentPanel.setLayout((LayoutManager)layout);
        commentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        commentPanel.add((Component)this.buildEmailAreaPanel(69), "0, 2, 2, 2");
        commentPanel.add((Component)this.buildCommentAreaPanel(comment, 87), "0, 3, 2, 3");
        if (this.errorDescription != null && this.errorDescription.length() > 0) {
            layout.setRow(1, 30.0);
            JPanel p = new JPanel();
            p.add(UIUtilities.setTextFont(ERROR_BRIEF));
            p.add(new JLabel(this.errorDescription));
            commentPanel.add((Component)UIUtilities.buildComponentPanel(p), "0, 1, 2, 1");
        }
        return commentPanel;
    }

    private JTabbedPane buildExceptionPane(Map toSubmit) {
        JTabbedPane tPane = new JTabbedPane();
        tPane.setOpaque(false);
        if (this.dialogType == 2) {
            tPane.addTab("Comments", null, this.buildCommentPane(COMMENT_FIELD), "Your comments go here.");
            tPane.addTab("Files to Submit", null, this.buildFilesToSubmitPane(toSubmit), "The files to send to the development team.");
        } else {
            tPane.addTab("Comments", null, this.buildCommentPane(DEBUG_COMMENT_FIELD), "Your comments go here.");
            tPane.addTab("Error Message", null, this.buildDebugPane(), "The Exception Message.");
        }
        return tPane;
    }

    private JPanel buildToolBar() {
        JPanel bars = new JPanel();
        bars.setLayout(new BoxLayout(bars, 0));
        JPanel p = UIUtilities.buildComponentPanel((JComponent)this.submitStatus);
        bars.add(p);
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.sendButton);
        bar.add(Box.createHorizontalStrut(10));
        p = UIUtilities.buildComponentPanelRight(bar);
        bars.add(p);
        return bars;
    }

    private void buildGUI(Map toSubmit) {
        Icon icon;
        JComponent component;
        String message;
        IconManager icons = IconManager.getInstance();
        if (this.dialogType == 2) {
            message = SUBMIT_MESSAGE;
            component = this.buildExceptionPane(toSubmit);
            icon = icons.getIcon(132);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.errorIcon");
            }
        } else if (this.exception == null) {
            message = MESSAGE;
            icon = icons.getIcon(21);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.questionIcon");
            }
            component = this.buildCommentPane(COMMENT_FIELD);
        } else {
            message = DEBUG_MESSAGE;
            component = this.buildExceptionPane(null);
            icon = icons.getIcon(22);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.errorIcon");
            }
        }
        Container c = this.getContentPane();
        TitlePanel tp = new TitlePanel(this.getTitle(), message, icon);
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)component, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void initialize(String title, Map toSubmit) {
        this.setTitle(title);
        this.initComponents();
        this.buildGUI(toSubmit);
        this.setSize(DEFAULT_SIZE);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress) {
        super(parent);
        this.emailAddress = emailAddress;
        this.dialogType = 1;
        this.initialize(title, null);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress, Exception exception) {
        super(parent);
        this.dialogType = 0;
        this.emailAddress = emailAddress;
        this.exception = exception;
        this.initialize(title, null);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress, Map toSubmit) {
        super(parent);
        this.dialogType = 2;
        this.emailAddress = emailAddress;
        this.initialize(title, toSubmit);
    }

    public void setErrorDescription(String description) {
        this.errorDescription = description;
    }

    public void setComment(String comment) {
        if (comment != null && comment.trim().length() > 0) {
            this.commentArea.setText(comment);
        }
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.send(SEND_PROPERTY);
                break;
            }
            case 4: {
                this.copy();
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.dialogType == 1) {
            String text = this.commentArea.getText();
            this.sendButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.dialogType == 1) {
            String text = this.commentArea.getText();
            this.sendButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    static /* synthetic */ void access$000(MessengerDialog x0) {
        x0.close();
    }
}

