/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.RectangleTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureRectangleFigure
extends RectangleTextFigure
implements ROIFigure {
    protected boolean readOnly;
    protected boolean clientObject;
    protected boolean dirty;
    protected Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    protected MeasurementUnits units;
    protected int status;

    public MeasureRectangleFigure() {
        this("Text", 0.0, 0.0, 0.0, 0.0, false, true);
    }

    public MeasureRectangleFigure(boolean readOnly, boolean clientObject) {
        this("Text", 0.0, 0.0, 0.0, 0.0, readOnly, clientObject);
    }

    public MeasureRectangleFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0, false, true);
    }

    public MeasureRectangleFigure(double x, double y, double width, double height) {
        this("Text", x, y, width, height, false, true);
    }

    public MeasureRectangleFigure(double x, double y, double width, double height, boolean readOnly, boolean clientObject) {
        this("Text", x, y, width, height, readOnly, clientObject);
    }

    public MeasureRectangleFigure(String text, double x, double y, double width, double height, boolean readOnly, boolean clientObject) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.HEIGHT, true);
        this.setAttributeEnabled(MeasurementAttributes.WIDTH, true);
        this.setAttribute(MeasurementAttributes.WIDTH, width);
        this.setAttribute(MeasurementAttributes.HEIGHT, height);
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
    }

    public double getMeasurementX() {
        if (this.units.isInMicrons()) {
            return this.getX() * this.units.getMicronsPixelX();
        }
        return this.getX();
    }

    public double getMeasurementY() {
        if (this.units.isInMicrons()) {
            return this.getY() * this.units.getMicronsPixelY();
        }
        return this.getY();
    }

    public double getMeasurementWidth() {
        if (this.units.isInMicrons()) {
            return this.getWidth() * this.units.getMicronsPixelX();
        }
        return this.getWidth();
    }

    public double getMeasurementHeight() {
        if (this.units.isInMicrons()) {
            return this.getHeight() * this.units.getMicronsPixelY();
        }
        return this.getHeight();
    }

    public double getX() {
        return this.rectangle.getX();
    }

    public double getY() {
        return this.rectangle.getY();
    }

    public double getWidth() {
        return this.rectangle.getWidth();
    }

    public double getHeight() {
        return this.rectangle.getHeight();
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue() || ((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            DecimalFormat formatter = new DecimalFormat("###.#");
            String rectangleArea = formatter.format(this.getArea());
            rectangleArea = this.addUnits(rectangleArea);
            double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            g.setFont(new Font("Arial", 0, (int)sz));
            this.bounds = g.getFontMetrics().getStringBounds(rectangleArea, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(rectangleArea, (int)this.bounds.getX(), (int)this.bounds.getY());
            }
            if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                g.setColor(this.getTextColor());
                this.bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                g.drawString(this.getROI().getID() + "", (int)this.bounds.getX(), (int)this.bounds.getY());
            }
        }
    }

    public void transform(AffineTransform tx) {
        if (!this.readOnly) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    public double getArea() {
        return this.getMeasurementWidth() * this.getMeasurementHeight();
    }

    public double getPerimeter() {
        return this.getMeasurementWidth() * 2.0 + this.getMeasurementHeight() * 2.0;
    }

    public Point2D getCentre() {
        if (this.units.isInMicrons()) {
            return new Point2D.Double(this.rectangle.getCenterX() * this.units.getMicronsPixelX(), this.rectangle.getCenterY() * this.units.getMicronsPixelY());
        }
        return new Point2D.Double(this.rectangle.getCenterX(), this.rectangle.getCenterY());
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.AREA.set(this.shape, (Double)this.getArea());
        AnnotationKeys.WIDTH.set(this.shape, (Double)this.getMeasurementWidth());
        AnnotationKeys.HEIGHT.set(this.shape, (Double)this.getMeasurementHeight());
        AnnotationKeys.PERIMETER.set(this.shape, (Double)this.getPerimeter());
        AnnotationKeys.CENTREX.set(this.shape, (Double)this.getCentre().getX());
        AnnotationKeys.CENTREY.set(this.shape, (Double)this.getCentre().getY());
    }

    @Override
    public String getType() {
        return "Rectangle";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        Rectangle r = this.rectangle.getBounds();
        ArrayList<Point> vector = new ArrayList<Point>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.rectangle.contains(x, y)) continue;
                vector.add(new Point(x, y));
            }
        }
        return vector;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureRectangleFigure clone() {
        MeasureRectangleFigure that = (MeasureRectangleFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        return that;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }
}

