/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class JPEGFilter
extends CustomizedFileFilter {
    public static final String MIMETYPE = "image/jpeg";
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String JPE = "jpe";
    public static final String[] extensions = new String[3];
    private static final String description;

    public String getMIMEType() {
        return MIMETYPE;
    }

    public String getExtension() {
        return JPEG;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        JPEGFilter.extensions[0] = JPEG;
        JPEGFilter.extensions[1] = JPG;
        JPEGFilter.extensions[2] = JPE;
        String s = "JPEG (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

