/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.PDFFilter;
import org.openmicroscopy.shoola.util.filter.file.WordFilter;

public class IOUtil {
    private static final WordFilter WORD_FILTER = new WordFilter();
    private static final ExcelFilter EXCEL_FILTER;
    private static final PDFFilter PDF_FILTER;

    private static String readWordFile(File file) throws Exception {
        return null;
    }

    private static String readExcelFile(File file) throws Exception {
        return null;
    }

    private static String readPDFFile(File file) throws Exception {
        return null;
    }

    public static InputStream readFileAsInputStream(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileInputStream input = null;
        try {
            input = new FileInputStream(f);
            return new BufferedInputStream(input);
        }
        catch (Exception e) {
            if (input != null) {
                input.close();
            }
            throw new IOException("Cannot read the file " + fileName + ". " + "Error: " + e.getMessage());
        }
    }

    public static OutputStream writeFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            return new BufferedOutputStream(out);
        }
        catch (Exception e) {
            if (out != null) {
                out.close();
            }
            throw new IOException("Cannot write the file " + fileName + ". " + "Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            input.close();
        }
        return contents.toString();
    }

    public static String readTextFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        return IOUtil.readTextFile(new File(fileName));
    }

    public static String readFile(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        if (WORD_FILTER.accept(file)) {
            return IOUtil.readWordFile(file);
        }
        if (EXCEL_FILTER.accept(file)) {
            return IOUtil.readExcelFile(file);
        }
        if (PDF_FILTER.accept(file)) {
            return IOUtil.readPDFFile(file);
        }
        return null;
    }

    public static String readFile(String fileName) throws Exception {
        if (fileName == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("No file name specified.");
        }
        return IOUtil.readFile(new File(fileName));
    }

    public static InputStream readConfigFile(String fileName) throws IOException {
        if (System.getProperty("javawebstart.version", null) != null) {
            return IOUtil.class.getClassLoader().getResourceAsStream(new File(fileName).getName());
        }
        return new FileInputStream(fileName);
    }

    static {
        PDF_FILTER = new PDFFilter();
        EXCEL_FILTER = new ExcelFilter();
    }
}

