/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import javax.swing.Icon;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ScriptRunner;
import org.openmicroscopy.shoola.env.ui.ScriptUploader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ScriptActivity
extends ActivityComponent {
    public static final int RUN = 0;
    public static final int UPLOAD = 1;
    public static final int DOWNLOAD = 2;
    public static final int VIEW = 3;
    private static final String DESCRIPTION_RUN_CREATION = "Running ";
    private static final String DESCRIPTION_RUN_CREATED = " finished";
    private static final String DESCRIPTION_UPLOAD_CREATION = "Uploading ";
    private static final String DESCRIPTION_UPLOAD_CREATED = " uploaded";
    private static final String DESCRIPTION_UPLOAD_CANCEL = "Upload cancelled";
    private static final String DESCRIPTION_RUN_CANCEL = "Run cancelled";
    private ScriptObject script;
    private int index;

    public ScriptActivity(UserNotifier viewer, Registry registry, ScriptObject script, int index) {
        super(viewer, registry, DESCRIPTION_RUN_CREATION + script.getDisplayedName(), script.getIcon());
        switch (index) {
            case 1: {
                this.type.setText(DESCRIPTION_UPLOAD_CREATION + script.getName());
            }
        }
        if (script == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.script = script;
        this.index = index;
        Icon icon = script.getIcon();
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
    }

    protected UserNotifierLoader createLoader() {
        switch (this.index) {
            case 1: {
                this.loader = new ScriptUploader(this.viewer, this.registry, this.script, this);
                break;
            }
            case 0: {
                this.loader = new ScriptRunner(this.viewer, this.registry, this.script, this);
            }
        }
        return this.loader;
    }

    protected void notifyActivityEnd() {
        switch (this.index) {
            case 1: {
                this.type.setText(this.script.getName() + DESCRIPTION_UPLOAD_CREATED);
                break;
            }
            case 0: {
                this.type.setText(this.script.getDisplayedName() + DESCRIPTION_RUN_CREATED);
            }
        }
    }

    protected void notifyActivityCancelled() {
        switch (this.index) {
            case 1: {
                this.type.setText(DESCRIPTION_UPLOAD_CANCEL);
                break;
            }
            case 0: {
                this.type.setText(DESCRIPTION_RUN_CANCEL);
            }
        }
    }

    protected void notifyActivityError() {
    }
}

