/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.FigureCreator;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class FigureActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Creating a figure";
    private static final String DESCRIPTION_CREATED = "Figure created";
    private static final String DESCRIPTION_CANCEL = "Figure creation cancelled";
    private FigureActivityParam parameters;

    public FigureActivity(UserNotifier viewer, Registry registry, FigureActivityParam parameters) {
        super(viewer, registry, DESCRIPTION_CREATION, parameters.getIcon());
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
    }

    protected UserNotifierLoader createLoader() {
        this.loader = new FigureCreator(this.viewer, this.registry, this.parameters.getParameters(), this.parameters.getIds(), this.parameters.getObjectType(), this);
        return this.loader;
    }

    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
        Object p = this.parameters.getParameters();
        if (p instanceof FigureParam) {
            DataObject data = ((FigureParam)p).getAnchor();
            if (data == null) {
                return;
            }
            String name = null;
            if (data instanceof ImageData) {
                name = "image: " + ((ImageData)data).getName();
            } else if (data instanceof DatasetData) {
                name = "dataset: " + ((DatasetData)data).getName();
            } else if (data instanceof ProjectData) {
                name = "project: " + ((ProjectData)data).getName();
            }
            if (name != null && this.messageLabel.getText().trim().length() == 0) {
                this.messageLabel.setText("Attached to " + name);
            }
        }
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityError() {
    }
}

