/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import omero.model.FileAnnotation;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.FileAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesLoader
extends BatchCallTree {
    public static final int ORIGINAL_FILE = 0;
    public static final int FILE_ANNOTATION = 1;
    private BatchCall loadCall;
    private Object result;
    private Object currentFile;
    private Map<FileAnnotationData, File> files;

    private BatchCall makeBatchCall(final File file, final long fileID, final long size) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                File f = service.downloadFile(file, fileID, size);
                FilesLoader.this.result = f;
            }
        };
    }

    private BatchCall makeFileBatchCall(final long id) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FileAnnotationData fa = (FileAnnotationData)service.loadAnnotation(id);
                HashMap m = new HashMap();
                File f = service.downloadFile(new File(fa.getFileName()), fa.getFileID(), fa.getFileSize());
                FilesLoader.this.result = f;
            }
        };
    }

    private BatchCall makeBatchCall(final long fileAnnotationID) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FileAnnotationData fa = (FileAnnotationData)service.loadAnnotation(fileAnnotationID);
                HashMap<FileAnnotationData, File> m = new HashMap<FileAnnotationData, File>();
                File f = service.downloadFile(new File(fa.getFileName()), fa.getFileID(), fa.getFileSize());
                m.put(fa, f);
                FilesLoader.this.result = m;
            }
        };
    }

    private BatchCall makeBatchCall(final Map<FileAnnotationData, File> files) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                HashMap m = new HashMap();
                for (Map.Entry entry : files.entrySet()) {
                    FileAnnotationData fa = (FileAnnotationData)entry.getKey();
                    File f = (File)entry.getValue();
                    System.err.println(f.getAbsolutePath());
                    OriginalFile of = ((FileAnnotation)fa.asAnnotation()).getFile();
                    service.downloadFile(f, of.getId().getValue(), of.getSize().getValue());
                }
                FilesLoader.this.result = files;
            }
        };
    }

    private void loadFile(FileAnnotationData fa, File f) {
        OmeroMetadataService service = this.context.getMetadataService();
        HashMap<FileAnnotationData, File> m = new HashMap<FileAnnotationData, File>();
        OriginalFile of = ((FileAnnotation)fa.asAnnotation()).getFile();
        try {
            service.downloadFile(f, of.getId().getValue(), of.getSize().getValue());
            m.put(fa, f);
            this.currentFile = m;
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve fie: " + e.getMessage());
        }
    }

    private BatchCall makeLoadFilesBatchCall(final int type, final long userID) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FilesLoader.this.result = service.loadFiles(type, userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        if (this.files == null && this.loadCall != null) {
            this.add(this.loadCall);
        } else {
            Iterator<Map.Entry<FileAnnotationData, File>> i = this.files.entrySet().iterator();
            String description = "Loading file";
            while (i.hasNext()) {
                Map.Entry<FileAnnotationData, File> entry = i.next();
                final FileAnnotationData fa = entry.getKey();
                final File f = entry.getValue();
                this.add(new BatchCall(description){

                    public void doCall() {
                        FilesLoader.this.loadFile(fa, f);
                    }
                });
            }
        }
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentFile;
    }

    public FilesLoader(File file, long fileID, long size) {
        this.loadCall = file == null ? this.makeBatchCall(fileID) : this.makeBatchCall(file, fileID, size);
    }

    public FilesLoader(File file, long fileID, int index) {
        this.loadCall = file == null || index == 1 ? this.makeFileBatchCall(fileID) : this.makeBatchCall(file, fileID, -1L);
    }

    public FilesLoader(Map<FileAnnotationData, File> files) {
        if (files == null) {
            throw new IllegalArgumentException("No files to load.");
        }
        this.files = files;
    }

    public FilesLoader(int type, long userID) {
        this.loadCall = this.makeLoadFilesBatchCall(type, userID);
    }
}

