/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.PlateData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerCounterLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final List<Long> ids, final Class type) {
        return new BatchCall("Counting items."){

            public void doCall() throws Exception {
                OmeroDataService os = ContainerCounterLoader.this.context.getDataService();
                if (PlateData.class.equals((Object)type)) {
                    Iterator i = ids.iterator();
                    OmeroImageService ms = ContainerCounterLoader.this.context.getImageService();
                    ExperimenterData exp = (ExperimenterData)ContainerCounterLoader.this.context.lookup("/current_user/details");
                    HashMap<Long, Long> m = new HashMap<Long, Long>();
                    long userID = exp.getId();
                    while (i.hasNext()) {
                        Long id = (Long)i.next();
                        m.put(id, new Long(ms.loadROIMeasurements(type, id, userID).size()));
                    }
                    ContainerCounterLoader.this.result = m;
                } else if (GroupData.class.equals((Object)type)) {
                    AdminService svc = ContainerCounterLoader.this.context.getAdminService();
                    ContainerCounterLoader.this.result = svc.countExperimenters(ids);
                } else {
                    ContainerCounterLoader.this.result = os.getCollectionCount(type, "images", ids);
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ContainerCounterLoader(Set<DataObject> rootIDs) {
        if (rootIDs == null) {
            throw new NullPointerException("No root nodes.");
        }
        Iterator<DataObject> i = rootIDs.iterator();
        Long id = null;
        Class<DatasetData> rootType = null;
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            DataObject root = i.next();
            if (root instanceof DatasetData) {
                rootType = DatasetData.class;
                id = ((DatasetData)root).getId();
            } else if (root instanceof TagAnnotationData) {
                rootType = TagAnnotationData.class;
                id = ((TagAnnotationData)root).getId();
            } else if (root instanceof PlateData) {
                rootType = PlateData.class;
                id = ((PlateData)root).getId();
            } else if (root instanceof GroupData) {
                rootType = GroupData.class;
                id = ((GroupData)root).getId();
            }
            if (id == null) continue;
            ids.add(id);
        }
        this.loadCall = this.makeBatchCall(ids, rootType);
    }
}

