/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.Iterator;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivedFilesLoader
extends BatchCallTree {
    private Object result;
    private Collection<Long> pixelsID;

    private void downloadFile(long id) {
        try {
            OmeroDataService os = this.context.getDataService();
            this.result = os.getOriginalFiles(id);
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve download the file: " + e.getMessage());
        }
    }

    @Override
    protected void buildTree() {
        Iterator<Long> i = this.pixelsID.iterator();
        String description = "Downloading original files.";
        while (i.hasNext()) {
            Long id;
            final Long pix = id = i.next();
            this.add(new BatchCall(description){

                public void doCall() {
                    ArchivedFilesLoader.this.downloadFile(pix);
                }
            });
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.result;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ArchivedFilesLoader(Collection<Long> pixelsID) {
        this.pixelsID = pixelsID;
    }
}

