/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.CompositeBatchCall;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.data.views.MonitorFactory;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.util.concur.tasks.CmdProcessor;
import org.openmicroscopy.shoola.util.concur.tasks.ExecMonitor;
import org.openmicroscopy.shoola.util.concur.tasks.Future;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;

public abstract class BatchCallTree {
    private boolean executed;
    private CompositeBatchCall root = new CompositeBatchCall();
    protected final Registry context = DataViewsFactory.getContext();

    protected BatchCallTree() {
    }

    private synchronized boolean hasExecuted() {
        boolean currentState = this.executed;
        this.executed = true;
        return currentState;
    }

    int countCalls() {
        return this.root.countCalls();
    }

    BatchCall getCurCall() {
        return this.root.getCurCall();
    }

    CallHandle exec(AgentEventListener observer) {
        if (this.hasExecuted()) {
            throw new IllegalStateException();
        }
        this.buildTree();
        Future handle = this.getProcessor().exec((MultiStepTask)this.root, this.getMonitor(observer));
        return new CallHandle(handle);
    }

    protected CmdProcessor getProcessor() {
        return (CmdProcessor)this.context.lookup("/services/CmdProcessor");
    }

    protected ExecMonitor getMonitor(AgentEventListener observer) {
        MonitorFactory mf = (MonitorFactory)this.context.lookup("/services/data/views/MonitorFactory");
        return mf.makeNew(this, observer);
    }

    protected void add(BatchCall bc) {
        this.root.add(bc);
    }

    protected abstract void buildTree();

    protected abstract Object getResult();

    protected Object getPartialResult() {
        return null;
    }
}

