/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.model.Annotation;
import omero.model.Channel;
import omero.model.DatasetAnnotationLink;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImagingEnvironment;
import omero.model.ImagingEnvironmentI;
import omero.model.LogicalChannel;
import omero.model.Medium;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.ObjectiveSettingsI;
import omero.model.OriginalFile;
import omero.model.ProjectAnnotationLink;
import omero.model.StageLabel;
import omero.model.StageLabelI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections.ListUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.model.TableResult;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import pojos.AnnotationData;
import pojos.BooleanAnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.TagAnnotationData;
import pojos.TermAnnotationData;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OmeroMetadataServiceImpl
implements OmeroMetadataService {
    private Registry context;
    private OMEROGateway gateway;

    private DataObject removeAnnotation(AnnotationData annotation, DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (annotation == null) {
            throw new IllegalArgumentException("No annotation to remove.");
        }
        if (object == null) {
            throw new IllegalArgumentException("No object to handle.");
        }
        IObject ho = this.gateway.findIObject(annotation.asIObject());
        ExperimenterData exp = this.getUserDetails();
        IObject link = this.gateway.findAnnotationLink(object.getClass(), object.getId(), ho.getId().getValue(), exp.getId());
        if (ho != null && link != null) {
            this.gateway.deleteObject(link);
        }
        return PojoMapper.asDataObject(this.gateway.findIObject(object.asIObject()));
    }

    private void saveChannelData(ChannelData data) throws DSOutOfServiceException, DSAccessException {
        LogicalChannel lc = data.asChannel().getLogicalChannel();
        ModelMapper.unloadCollections((IObject)lc);
        this.gateway.updateObject((IObject)lc, new Parameters());
    }

    private void saveChannelAcquisitionData(ChannelAcquisitionData data) {
    }

    private void saveImageAcquisitionData(ImageAcquisitionData data) throws DSOutOfServiceException, DSAccessException {
        Iterator<IObject> i;
        List<IObject> l;
        Medium object;
        Object o;
        long id;
        Image image = data.asImage();
        ArrayList<IObject> toCreate = new ArrayList<IObject>();
        ArrayList<IObject> toUpdate = new ArrayList<IObject>();
        if (data.isStageLabelDirty()) {
            StageLabelI label;
            id = data.getStageLabelId();
            if (id < 0L) {
                label = new StageLabelI();
                toCreate.add((IObject)label);
            } else {
                label = (StageLabel)this.gateway.findIObject(StageLabel.class.getName(), id);
                toUpdate.add((IObject)label);
            }
            label.setName(rtypes.rstring((String)data.getLabelName()));
            o = data.getPositionX();
            if (o != null) {
                label.setPositionX(rtypes.rdouble((double)((Float)o).floatValue()));
            }
            if ((o = data.getPositionY()) != null) {
                label.setPositionY(rtypes.rdouble((double)((Float)o).floatValue()));
            }
            if ((o = data.getPositionZ()) != null) {
                label.setPositionZ(rtypes.rdouble((double)((Float)o).floatValue()));
            }
        }
        if (data.isImagingEnvironmentDirty()) {
            ImagingEnvironmentI condition;
            id = data.getImagingEnvironmentId();
            if (id < 0L) {
                condition = new ImagingEnvironmentI();
                toCreate.add((IObject)condition);
            } else {
                condition = (ImagingEnvironment)this.gateway.findIObject(ImagingEnvironment.class.getName(), id);
                toUpdate.add((IObject)condition);
            }
            condition.setAirPressure(rtypes.rdouble((double)data.getAirPressure()));
            condition.setHumidity(rtypes.rdouble((double)data.getHumidity()));
            o = data.getTemperature();
            if (o != null) {
                condition.setTemperature(rtypes.rdouble((double)((Float)o).floatValue()));
            }
            condition.setCo2percent(rtypes.rdouble((double)data.getCo2Percent()));
        }
        if (data.isObjectiveSettingsDirty()) {
            ObjectiveSettingsI settings;
            id = data.getObjectiveSettingsId();
            if (id < 0L) {
                settings = new ObjectiveSettingsI();
                toCreate.add((IObject)settings);
            } else {
                settings = (ObjectiveSettings)this.gateway.findIObject(ObjectiveSettings.class.getName(), id);
                toUpdate.add((IObject)settings);
            }
            settings.setCorrectionCollar(rtypes.rdouble((double)data.getCorrectionCollar()));
            settings.setRefractiveIndex(rtypes.rdouble((double)data.getRefractiveIndex()));
            object = data.getMediumAsEnum();
            if (object != null) {
                settings.setMedium(object);
            }
        }
        long objectiveSettingsID = data.getObjectiveSettingsId();
        if (toUpdate.size() > 0) {
            this.gateway.updateObjects(toUpdate, new Parameters());
        }
        if (toCreate.size() > 0) {
            l = this.gateway.createObjects(toCreate);
            i = l.iterator();
            image = (Image)this.gateway.findIObject(data.asIObject());
            while (i.hasNext()) {
                object = i.next();
                if (object instanceof StageLabel) {
                    image.setStageLabel((StageLabel)object);
                    continue;
                }
                if (object instanceof ImagingEnvironment) {
                    image.setImagingEnvironment((ImagingEnvironment)object);
                    continue;
                }
                if (!(object instanceof ObjectiveSettings)) continue;
                objectiveSettingsID = object.getId().getValue();
                image.setObjectiveSettings((ObjectiveSettings)object);
            }
            ModelMapper.unloadCollections((IObject)image);
            this.gateway.updateObject((IObject)image, new Parameters());
        }
        toUpdate.clear();
        toCreate.clear();
        if (toUpdate.size() > 0) {
            this.gateway.updateObjects(toUpdate, new Parameters());
        } else {
            l = this.gateway.createObjects(toCreate);
            i = l.iterator();
            ObjectiveSettings settings = (ObjectiveSettings)this.gateway.findIObject(ObjectiveSettings.class.getName(), objectiveSettingsID);
            while (i.hasNext()) {
                object = i.next();
                if (!(object instanceof Objective)) continue;
                settings.setObjective((Objective)object);
            }
            ModelMapper.unloadCollections((IObject)settings);
            this.gateway.updateObject((IObject)settings, new Parameters());
        }
    }

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)this.context.lookup("/current_user/details");
    }

    private List<AnnotationData> prepareAnnotationToAdd(List<AnnotationData> toAdd) throws DSOutOfServiceException, DSAccessException {
        ArrayList<AnnotationData> annotations = new ArrayList<AnnotationData>();
        if (toAdd == null || toAdd.size() == 0) {
            return annotations;
        }
        Iterator<Object> i = toAdd.iterator();
        Annotation iobject = null;
        ArrayList<Annotation> toCreate = new ArrayList<Annotation>();
        while (i.hasNext()) {
            AnnotationData ann = i.next();
            if (ann.getId() < 0L) {
                if (ann instanceof FileAnnotationData) {
                    FileAnnotationData fileAnn = (FileAnnotationData)ann;
                    OriginalFile of = this.gateway.uploadFile(fileAnn.getAttachedFile(), fileAnn.getServerFileMimetype(), -1L);
                    FileAnnotationI fa = new FileAnnotationI();
                    fa.setFile(of);
                    iobject = fa;
                } else {
                    iobject = ModelMapper.createAnnotation(ann);
                }
                if (iobject == null) continue;
                toCreate.add(iobject);
                continue;
            }
            if (ann instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)ann;
                ann = (TagAnnotationData)this.updateAnnotationData((DataObject)tag);
            }
            annotations.add(ann);
        }
        if (toCreate.size() > 0) {
            i = toCreate.iterator();
            ArrayList<IObject> l = new ArrayList<IObject>(toCreate.size());
            while (i.hasNext()) {
                l.add((IObject)i.next());
            }
            List<IObject> r = this.gateway.createObjects(l);
            annotations.addAll(PojoMapper.asDataObjects(r));
        }
        return annotations;
    }

    private void linkAnnotation(DataObject data, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        String ioType = this.gateway.convertPojos(data).getName();
        IObject ho = this.gateway.findIObject(ioType, data.getId());
        ModelMapper.unloadCollections(ho);
        IObject link = null;
        boolean exist = false;
        Annotation an = annotation.asAnnotation();
        ExperimenterData exp = this.getUserDetails();
        if (annotation instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)annotation;
            if (TagAnnotationData.class.equals(data.getClass())) {
                link = this.gateway.findAnnotationLink(AnnotationData.class, tag.getId(), ho.getId().getValue(), exp.getId());
                if (link == null) {
                    link = ModelMapper.linkAnnotation((IObject)an, (Annotation)ho);
                } else {
                    exist = true;
                }
            } else {
                link = this.gateway.findAnnotationLink(ho.getClass(), ho.getId().getValue(), tag.getId(), exp.getId());
                if (link == null) {
                    link = ModelMapper.linkAnnotation(ho, an);
                } else {
                    this.updateAnnotationData((DataObject)tag);
                    exist = true;
                }
            }
        } else if (annotation instanceof RatingAnnotationData) {
            this.clearAnnotation(data.getClass(), data.getId(), RatingAnnotationData.class);
            link = ModelMapper.linkAnnotation(ho, an);
        } else {
            link = ModelMapper.linkAnnotation(ho, an);
        }
        if (link != null && !exist) {
            this.gateway.createObject(link);
        }
    }

    private DataObject updateAnnotationData(DataObject ann) throws DSOutOfServiceException, DSAccessException {
        Object link = null;
        if (ann instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)ann;
            long id = tag.getId();
            String ioType = this.gateway.convertPojos(TagAnnotationData.class).getName();
            TagAnnotation ho = (TagAnnotation)this.gateway.findIObject(ioType, id);
            ho.setTextValue(rtypes.rstring((String)tag.getTagValue()));
            ho.setDescription(rtypes.rstring((String)tag.getTagDescription()));
            IObject object = this.gateway.updateObject((IObject)ho, new Parameters());
            return PojoMapper.asDataObject(object);
        }
        return ann;
    }

    private void convert(List<DataObject> all, Collection l) {
        if (l == null || l.size() == 0) {
            return;
        }
        for (IObject object : l) {
            if (object instanceof ProjectAnnotationLink) {
                all.add(PojoMapper.asDataObject((IObject)((ProjectAnnotationLink)object).getChild()));
                continue;
            }
            if (object instanceof DatasetAnnotationLink) {
                all.add(PojoMapper.asDataObject((IObject)((DatasetAnnotationLink)object).getChild()));
                continue;
            }
            if (!(object instanceof ImageAnnotationLink)) continue;
            all.add(PojoMapper.asDataObject((IObject)((ImageAnnotationLink)object).getChild()));
        }
    }

    private Collection loadAllAttachments(Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<DataObject> all = new ArrayList<DataObject>();
        if (type == null) {
            Collection l = this.gateway.findAllAnnotations(ProjectData.class, userID);
            if (l != null && l.size() > 0) {
                this.convert(all, l);
            }
            if ((l = this.gateway.findAllAnnotations(DatasetData.class, userID)) != null && l.size() > 0) {
                this.convert(all, l);
            }
            if ((l = this.gateway.findAllAnnotations(ImageData.class, userID)) != null && l.size() > 0) {
                this.convert(all, l);
            }
            return this.getFileAnnotations(all);
        }
        this.convert(all, this.gateway.findAllAnnotations(type, userID));
        return this.getFileAnnotations(all);
    }

    private List<AnnotationData> getFileAnnotations(Collection annotations) throws DSOutOfServiceException, DSAccessException {
        ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
        if (annotations == null || annotations.size() == 0) {
            return result;
        }
        for (AnnotationData data : annotations) {
            if (!(data instanceof FileAnnotationData)) continue;
            FileAnnotation fa = (FileAnnotation)data.asAnnotation();
            long fileID = fa.getFile().getId().getValue();
            OriginalFile of = this.gateway.getOriginalFile(fileID);
            if (of != null) {
                ((FileAnnotationData)data).setContent((Object)of);
            }
            result.add(data);
        }
        return result;
    }

    OmeroMetadataServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public Collection loadRatings(Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(id);
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(RatingAnnotationData.class);
        Map map = this.gateway.loadAnnotations(type, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return new ArrayList();
        }
        return (Collection)map.get(id);
    }

    @Override
    public StructuredDataResults loadStructuredData(Object object, long userID, boolean viewed) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        StructuredDataResults results = null;
        DataObject r = null;
        if (object instanceof File) {
            File f = (File)object;
            DataObject fd = this.gateway.loadFolder(f.getAbsolutePath());
            results = new StructuredDataResults(fd);
            return results;
        }
        if (object instanceof DataObject) {
            r = (DataObject)object;
            results = new StructuredDataResults(r);
        }
        if (r == null) {
            throw new IllegalArgumentException("Data Object not initialized.");
        }
        Collection annotations = this.loadStructuredAnnotations(object.getClass(), r.getId(), userID);
        if (annotations != null && annotations.size() > 0) {
            List links;
            ArrayList<AnnotationData> texts = new ArrayList<AnnotationData>();
            ArrayList<AnnotationData> tags = new ArrayList<AnnotationData>();
            ArrayList<AnnotationData> terms = new ArrayList<AnnotationData>();
            ArrayList<AnnotationData> attachments = new ArrayList<AnnotationData>();
            ArrayList<AnnotationData> ratings = new ArrayList<AnnotationData>();
            ArrayList<AnnotationData> published = new ArrayList<AnnotationData>();
            Iterator i = annotations.iterator();
            HashMap<Long, AnnotationData> map = new HashMap<Long, AnnotationData>();
            ArrayList<Long> annotationIds = new ArrayList<Long>();
            while (i.hasNext()) {
                BooleanAnnotationData b;
                AnnotationData data = (AnnotationData)i.next();
                if (data instanceof TermAnnotationData) {
                    terms.add(data);
                    continue;
                }
                if (data instanceof TextualAnnotationData) {
                    texts.add(data);
                    continue;
                }
                if (data instanceof TagAnnotationData) {
                    annotationIds.add(data.getId());
                    map.put(data.getId(), data);
                    tags.add(data);
                    continue;
                }
                if (data instanceof RatingAnnotationData) {
                    ratings.add(data);
                    continue;
                }
                if (data instanceof FileAnnotationData) {
                    annotationIds.add(data.getId());
                    map.put(data.getId(), data);
                    attachments.add(data);
                    continue;
                }
                if (!(data instanceof BooleanAnnotationData) || !"openmicroscopy.org/omero/insight/published".equals((b = (BooleanAnnotationData)data).getNameSpace())) continue;
                published.add(data);
            }
            if (annotationIds.size() > 0 && !(object instanceof TagAnnotationData) && !(object instanceof FileAnnotationData) && (links = this.gateway.findAnnotationLinks(object.getClass(), r.getId(), annotationIds, -1L)) != null) {
                HashMap<DataObject, ExperimenterData> m = new HashMap<DataObject, ExperimenterData>();
                for (IObject link : links) {
                    DataObject d = PojoMapper.asDataObject(ModelMapper.getChildFromLink(link));
                    if (d == null) continue;
                    m.put(d, (ExperimenterData)PojoMapper.asDataObject((IObject)link.getDetails().getOwner()));
                }
                results.setLinks(m);
            }
            results.setTextualAnnotations(texts);
            results.setTerms(terms);
            results.setTags(tags);
            results.setRatings(ratings);
            results.setAttachments(attachments);
            results.setPublished(published);
            if (map.size() > 0) {
                // empty if block
            }
        }
        return results;
    }

    @Override
    public Map loadStructuredData(List<DataObject> data, long userID, boolean viewed) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("Object not valid.");
        }
        HashMap<Long, StructuredDataResults> results = new HashMap<Long, StructuredDataResults>();
        for (DataObject node : data) {
            if (node == null) continue;
            results.put(node.getId(), this.loadStructuredData(node, userID, viewed));
        }
        return results;
    }

    @Override
    public DataObject annotate(DataObject toAnnotate, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        if (toAnnotate == null) {
            throw new IllegalArgumentException("DataObject cannot be null");
        }
        return this.annotate(toAnnotate.getClass(), toAnnotate.getId(), annotation);
    }

    @Override
    public DataObject annotate(Class type, long id, AnnotationData annotation) throws DSOutOfServiceException, DSAccessException {
        if (annotation == null) {
            throw new IllegalArgumentException("DataObject cannot be null");
        }
        String ioType = this.gateway.convertPojos(type).getName();
        IObject ho = this.gateway.findIObject(ioType, id);
        ModelMapper.unloadCollections(ho);
        IObject link = null;
        boolean exist = false;
        ExperimenterData exp = this.getUserDetails();
        if (annotation instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)annotation;
            if (TagAnnotationData.class.equals((Object)type)) {
                if (tag.getId() <= 0L) {
                    TagAnnotationI ann = new TagAnnotationI();
                    ann.setTextValue(rtypes.rstring((String)tag.getContentAsString()));
                    ann.setDescription(rtypes.rstring((String)tag.getTagDescription()));
                    link = ModelMapper.linkAnnotation((IObject)ann, (Annotation)ho);
                } else {
                    IObject annObject = tag.asIObject();
                    ModelMapper.unloadCollections(annObject);
                    link = this.gateway.findAnnotationLink(AnnotationData.class, tag.getId(), ho.getId().getValue(), exp.getId());
                    if (link == null) {
                        link = ModelMapper.linkAnnotation(annObject, (Annotation)ho);
                    }
                }
            } else if (tag.getId() <= 0L) {
                link = ModelMapper.createAnnotationAndLink(ho, annotation);
            } else {
                IObject annObject = tag.asIObject();
                ModelMapper.unloadCollections(annObject);
                link = this.gateway.findAnnotationLink(ho.getClass(), ho.getId().getValue(), tag.getId(), exp.getId());
                if (link == null) {
                    link = ModelMapper.linkAnnotation(ho, (Annotation)annObject);
                } else {
                    exist = true;
                }
            }
        } else if (annotation instanceof RatingAnnotationData) {
            this.clearAnnotation(type, id, RatingAnnotationData.class);
            link = ModelMapper.createAnnotationAndLink(ho, annotation);
        } else if (annotation instanceof FileAnnotationData) {
            FileAnnotationData ann = (FileAnnotationData)annotation;
            if (ann.getId() < 0L) {
                OriginalFile of = this.gateway.uploadFile(ann.getAttachedFile(), ann.getServerFileMimetype(), -1L);
                FileAnnotationI fa = new FileAnnotationI();
                fa.setFile(of);
                link = ModelMapper.linkAnnotation(ho, (Annotation)fa);
            } else {
                IObject annObject = ann.asIObject();
                ModelMapper.unloadCollections(annObject);
                link = ModelMapper.linkAnnotation(ho, (Annotation)annObject);
            }
        } else {
            link = ModelMapper.createAnnotationAndLink(ho, annotation);
        }
        if (link != null) {
            IObject object = exist ? link : this.gateway.createObject(link);
            return PojoMapper.asDataObject(ModelMapper.getAnnotatedObject(object));
        }
        return null;
    }

    @Override
    public void clearAnnotation(Class type, long id, Class annotationType) throws DSOutOfServiceException, DSAccessException {
        if (type == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        long userID = this.getUserDetails().getId();
        Collection annotations = this.loadStructuredAnnotations(type, id, userID);
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        ArrayList<IObject> toRemove = new ArrayList<IObject>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (AnnotationData data : annotations) {
            if (annotationType != null && !data.getClass().equals(annotationType)) continue;
            toRemove.add(data.asIObject());
            ids.add(data.getId());
        }
        List l = null;
        String klass = this.gateway.convertPojos(type).getName();
        if (ids.size() != 0) {
            l = this.gateway.findAnnotationLinks(klass, id, ids);
        }
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.gateway.deleteObject((IObject)i.next());
            }
            for (IObject obj : toRemove) {
                ids = new ArrayList();
                ids.add(obj.getId().getValue());
                l = this.gateway.findAnnotationLinks(klass, -1L, ids);
                if (l != null && l.size() != 0) continue;
                this.gateway.deleteObject(obj);
            }
        }
    }

    @Override
    public void clearAnnotation(DataObject object, Class annotationType) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        this.clearAnnotation(object.getClass(), object.getId(), annotationType);
    }

    @Override
    public void clearAnnotation(DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        this.clearAnnotation(object.getClass(), object.getId(), null);
    }

    @Override
    public Collection loadStructuredAnnotations(Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        if (id < 0L) {
            new ArrayList();
        }
        if (type == null) {
            throw new IllegalArgumentException("No type specified.");
        }
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> objects = new ArrayList<Long>(1);
        objects.add(id);
        Map map = this.gateway.loadAnnotations(type, objects, null, ids, new Parameters());
        return (Collection)map.get(id);
    }

    @Override
    public Collection loadAnnotations(Class annotationType, String nameSpace, long userID, long groupID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        ArrayList<String> toInclude = new ArrayList<String>();
        ArrayList<String> toExclude = new ArrayList<String>();
        if (nameSpace != null) {
            toInclude.add(nameSpace);
        }
        if (FileAnnotationData.class.equals((Object)annotationType)) {
            toExclude.add("openmicroscopy.org/omero/import/companionFile");
            toExclude.add("openmicroscopy.org/omero/measurement");
            toExclude.add("openmicroscopy.org/omero/analysis/flim");
        }
        return this.gateway.loadSpecificAnnotation(annotationType, toInclude, toExclude, (Parameters)po);
    }

    @Override
    public Object saveData(Collection<DataObject> data, List<AnnotationData> toAdd, List<AnnotationData> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        OmeroDataService service = this.context.getDataService();
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(toAdd);
        for (DataObject object : data) {
            if (object instanceof AnnotationData) {
                this.updateAnnotationData(object);
            } else if (object.isLoaded()) {
                service.updateDataObject(object);
            }
            if (annotations.size() > 0) {
                for (AnnotationData ann : annotations) {
                    if (ann == null) continue;
                    this.linkAnnotation(object, ann);
                }
            }
            if (toRemove == null) continue;
            for (AnnotationData ann : toRemove) {
                if (ann == null) continue;
                this.removeAnnotation(ann, object);
            }
        }
        return data;
    }

    @Override
    public Object saveBatchData(Collection<DataObject> data, List<AnnotationData> toAdd, List<AnnotationData> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        OmeroDataService service = this.context.getDataService();
        Iterator<DataObject> j = data.iterator();
        Set images = null;
        Parameters po = new Parameters();
        ArrayList<DataObject> result = null;
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(toAdd);
        ArrayList<Long> childrenIds = new ArrayList<Long>();
        while (j.hasNext()) {
            Iterator<AnnotationData> i;
            DataObject object = j.next();
            if (result == null) {
                result = new ArrayList<DataObject>();
            }
            if (object instanceof DatasetData) {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(object.getId());
                images = this.gateway.getContainerImages(DatasetData.class, ids, po);
                if (images == null) continue;
                for (DataObject child : images) {
                    if (childrenIds.contains(child.getId())) continue;
                    result.add(child);
                    childrenIds.add(child.getId());
                    if (annotations != null) {
                        i = annotations.iterator();
                        while (i.hasNext()) {
                            this.linkAnnotation(child, i.next());
                        }
                    }
                    if (toRemove == null) continue;
                    i = toRemove.iterator();
                    while (i.hasNext()) {
                        this.removeAnnotation(i.next(), child);
                    }
                }
                continue;
            }
            if (object instanceof PlateData) {
                images = this.gateway.loadPlateWells(object.getId(), -1L, userID);
                if (images == null) continue;
                for (DataObject child : images) {
                    if (childrenIds.contains(child.getId())) continue;
                    result.add(child);
                    childrenIds.add(child.getId());
                    if (annotations != null) {
                        i = annotations.iterator();
                        while (i.hasNext()) {
                            this.linkAnnotation(child, i.next());
                        }
                    }
                    if (toRemove == null) continue;
                    i = toRemove.iterator();
                    while (i.hasNext()) {
                        this.removeAnnotation(i.next(), child);
                    }
                }
                continue;
            }
            if (!(object instanceof ImageData)) continue;
            service.updateDataObject(object);
            if (annotations != null) {
                i = annotations.iterator();
                while (i.hasNext()) {
                    this.linkAnnotation(object, i.next());
                }
            }
            if (toRemove == null) continue;
            i = toRemove.iterator();
            while (i.hasNext()) {
                this.removeAnnotation(i.next(), object);
            }
        }
        if (result == null) {
            return data;
        }
        return result;
    }

    @Override
    public Object saveBatchData(TimeRefObject data, List<AnnotationData> toAdd, List<AnnotationData> toRemove, long userID) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No data to save");
        }
        OmeroDataService service = this.context.getDataService();
        Collection images = service.getImagesPeriod(data.getStartTime(), data.getEndTime(), userID, true);
        ArrayList<DataObject> r = new ArrayList<DataObject>();
        if (images == null) {
            return r;
        }
        Iterator i = images.iterator();
        List<AnnotationData> annotations = this.prepareAnnotationToAdd(toAdd);
        while (i.hasNext()) {
            Iterator<AnnotationData> j;
            DataObject child = (DataObject)i.next();
            r.add(child);
            if (annotations != null) {
                j = annotations.iterator();
                while (j.hasNext()) {
                    this.linkAnnotation(child, (AnnotationData)i.next());
                }
            }
            if (toRemove == null) continue;
            j = toRemove.iterator();
            while (j.hasNext()) {
                this.removeAnnotation(j.next(), child);
            }
        }
        return r;
    }

    @Override
    public File downloadFile(File file, long fileID, long size) throws DSOutOfServiceException, DSAccessException {
        if (fileID < 0L) {
            throw new IllegalArgumentException("File ID not valid");
        }
        if (file == null) {
            throw new IllegalArgumentException("File path not valid");
        }
        return this.gateway.downloadFile(file, fileID, size);
    }

    @Override
    public Map<Long, Collection> loadRatings(Class nodeType, List<Long> nodeIds, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(RatingAnnotationData.class);
        Map map = this.gateway.loadAnnotations(nodeType, nodeIds, types, ids, new Parameters());
        HashMap<Long, Collection> results = new HashMap<Long, Collection>();
        if (map == null) {
            return results;
        }
        for (Map.Entry entry : map.entrySet()) {
            Long id = (Long)entry.getKey();
            Collection l = (Collection)entry.getValue();
            ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
            for (AnnotationData data : l) {
                if (!(data instanceof RatingAnnotationData)) continue;
                result.add(data);
            }
            if (result.size() <= 0) continue;
            results.put(id, result);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotation(Class nodeType, List<Long> nodeIds, Class annotationType, List<String> terms, long userID) throws DSOutOfServiceException, DSAccessException {
        List<Long> nodes;
        long id;
        List results = new ArrayList();
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(annotationType);
        Map map = this.gateway.loadAnnotations(nodeType, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return results;
        }
        ExperimenterData exp = this.getUserDetails();
        HashMap m = new HashMap();
        if (terms != null && terms.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || !terms.contains(((TagAnnotationData)data).getTagValue())) continue;
                        nodes = (List)m.get(data.getId());
                        if (nodes == null) {
                            nodes = new ArrayList<Long>();
                            nodes.add(id);
                        }
                        if (!nodes.contains(id)) {
                            nodes.add(id);
                        }
                        m.put(data.getId(), nodes);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || !(data instanceof TextualAnnotationData) || !terms.contains(((TextualAnnotationData)data).getText())) continue;
                    nodes = (List)m.get(data.getId());
                    if (nodes == null) {
                        nodes = new ArrayList();
                        nodes.add(id);
                    }
                    if (!nodes.contains(id)) {
                        nodes.add(id);
                    }
                    m.put(data.getId(), nodes);
                }
            }
        } else {
            return this.filterByAnnotated(nodeType, nodeIds, annotationType, true, userID);
        }
        for (Map.Entry entry : m.entrySet()) {
            id = (Long)entry.getKey();
            nodes = (ArrayList<Long>)entry.getValue();
            if (results.size() == 0) {
                results.addAll(nodes);
                continue;
            }
            results = ListUtils.intersection(results, (List)nodes);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotated(Class nodeType, List<Long> nodeIds, Class annotationType, boolean annotated, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> results = new ArrayList<Long>();
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(annotationType);
        Map map = this.gateway.loadAnnotations(nodeType, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return results;
        }
        Iterator i = map.entrySet().iterator();
        if (annotated) {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                long id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || results.contains(id)) continue;
                        results.add(id);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || data instanceof TagAnnotationData || results.contains(id)) continue;
                    results.add(id);
                }
            }
        } else {
            ArrayList<Long> toExclude = new ArrayList<Long>();
            results.addAll(nodeIds);
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                long id = (Long)entry.getKey();
                Collection l = (Collection)entry.getValue();
                for (AnnotationData data : l) {
                    if (annotationType.equals(TagAnnotationData.class)) {
                        if (!(data instanceof TagAnnotationData) || toExclude.contains(id)) continue;
                        toExclude.add(id);
                        continue;
                    }
                    if (!annotationType.equals(TextualAnnotationData.class) || data instanceof TagAnnotationData || toExclude.contains(id)) continue;
                    toExclude.add(id);
                }
            }
            results.removeAll(toExclude);
        }
        return results;
    }

    @Override
    public Collection filterByAnnotation(Class nodeType, List<Long> ids, FilterContext filter, long userID) throws DSOutOfServiceException, DSAccessException {
        Collection l;
        List found;
        Iterator<Map.Entry<Class<Object>, List<String>>> i;
        ArrayList<Class> annotationTypes;
        Map map;
        if (filter == null) {
            throw new IllegalArgumentException("No filtering context.");
        }
        int rateIndex = filter.getIndex();
        List<Long> filteredNodes = new ArrayList();
        ArrayList<Long> userIDs = null;
        if (userID != -1L) {
            userIDs = new ArrayList<Long>(1);
            userIDs.add(userID);
        }
        if (((map = this.gateway.loadAnnotations(nodeType, ids, annotationTypes = new ArrayList<Class>(), userIDs, new Parameters())) == null || map.size() == 0) && rateIndex == 2 && filter.getRate() == 0) {
            return ids;
        }
        ExperimenterData exp = this.getUserDetails();
        Timestamp start = filter.getFromDate();
        Timestamp end = filter.getToDate();
        HashSet<Long> annotationsIds = new HashSet<Long>();
        int resultType = filter.getResultType();
        Map<Class, List<String>> types = filter.getAnnotationType();
        HashMap r = new HashMap();
        if (types != null && types.size() > 0) {
            List annotations;
            Class<Object> type;
            i = types.entrySet().iterator();
            HashMap m = new HashMap();
            if (resultType == 101) {
                while (i.hasNext()) {
                    List<Long> nodes;
                    Long id;
                    Map.Entry<Class<Object>, List<String>> entry = i.next();
                    type = entry.getKey();
                    found = new ArrayList();
                    annotations = this.gateway.filterBy(type, entry.getValue(), start, end, exp);
                    Iterator<Object> j = annotations.iterator();
                    while (j.hasNext()) {
                        annotationsIds.add((Long)j.next());
                    }
                    for (Map.Entry entry2 : map.entrySet()) {
                        id = (Long)entry2.getKey();
                        l = (Collection)entry2.getValue();
                        if (l.size() < annotations.size()) continue;
                        for (AnnotationData data : l) {
                            if (!annotations.contains(data.getId())) continue;
                            nodes = (List)m.get(data.getId());
                            if (nodes == null) {
                                nodes = new ArrayList<Long>();
                                nodes.add(id);
                            }
                            if (!nodes.contains(id)) {
                                nodes.add(id);
                            }
                            m.put(data.getId(), nodes);
                        }
                    }
                    for (Map.Entry entry3 : m.entrySet()) {
                        id = (Long)entry3.getKey();
                        nodes = (ArrayList<Long>)entry3.getValue();
                        if (found.size() == 0) {
                            found.addAll(nodes);
                            continue;
                        }
                        found = ListUtils.intersection(found, (List)nodes);
                    }
                    r.put(type, found);
                }
            } else if (resultType == 100) {
                while (i.hasNext()) {
                    type = (Class<Object>)((Object)i.next());
                    annotations = this.gateway.filterBy(type, types.get(type), start, end, exp);
                    i = annotations.iterator();
                    while (i.hasNext()) {
                        annotationsIds.add((Long)((Object)i.next()));
                    }
                }
                for (Long id : map.keySet()) {
                    l = (Collection)map.get(id);
                    for (AnnotationData data : l) {
                        if (!annotationsIds.contains(data.getId())) continue;
                        filteredNodes.add(id);
                    }
                }
            }
        }
        if (rateIndex != -1) {
            int rate = filter.getRate();
            i = map.keySet().iterator();
            found = new ArrayList();
            switch (rateIndex) {
                case 2: {
                    Long id2;
                    if (rate == 0) {
                        found.addAll(ids);
                        while (i.hasNext()) {
                            found.remove(i.next());
                        }
                    } else {
                        while (i.hasNext()) {
                            id2 = (Long)((Object)i.next());
                            l = (Collection)map.get(id2);
                            for (AnnotationData data : l) {
                                int value;
                                if (!(data instanceof RatingAnnotationData) || rate != (value = ((RatingAnnotationData)data).getRating())) continue;
                                found.add(id2);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    Long id2;
                    if (rate == 0) {
                        found.addAll(ids);
                        while (i.hasNext()) {
                            found.remove(i.next());
                        }
                    } else {
                        while (i.hasNext()) {
                            id2 = (Long)((Object)i.next());
                            l = (Collection)map.get(id2);
                            for (AnnotationData data : l) {
                                int value;
                                if (!(data instanceof RatingAnnotationData) || (value = ((RatingAnnotationData)data).getRating()) > rate) continue;
                                found.add(id2);
                            }
                        }
                    }
                    break;
                }
                case 0: {
                    Long id2;
                    while (i.hasNext()) {
                        id2 = (Long)((Object)i.next());
                        l = (Collection)map.get(id2);
                        for (AnnotationData data : l) {
                            int value;
                            if (!(data instanceof RatingAnnotationData) || (value = ((RatingAnnotationData)data).getRating()) < rate) continue;
                            found.add(id2);
                        }
                    }
                    break;
                }
            }
            if (resultType == 100) {
                filteredNodes.addAll(found);
            } else if (resultType == 101) {
                r.put((Class<Object>)RatingAnnotationData.class, found);
            }
        }
        if (resultType == 100) {
            return filteredNodes;
        }
        filteredNodes.clear();
        if (r.size() == 0) {
            return filteredNodes;
        }
        i = r.keySet().iterator();
        boolean index = false;
        Class type22 = null;
        for (Class type22 : r.keySet()) {
            if (filteredNodes.size() == 0) {
                filteredNodes.addAll((Collection)r.get(type22));
                continue;
            }
            filteredNodes = ListUtils.intersection(filteredNodes, (List)((List)r.get(type22)));
        }
        return filteredNodes;
    }

    @Override
    public Collection getEnumeration(String type) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getEnumerations(type);
    }

    @Override
    public Object loadAcquisitionData(Object refObject) throws DSOutOfServiceException, DSAccessException {
        if (refObject instanceof ImageData) {
            return this.gateway.loadImageAcquisitionData(((ImageData)refObject).getId());
        }
        if (refObject instanceof ChannelData) {
            Channel c = ((ChannelData)refObject).asChannel();
            if (c.getLogicalChannel() == null) {
                return null;
            }
            long id = c.getLogicalChannel().getId().getValue();
            return this.gateway.loadChannelAcquisitionData(id);
        }
        return null;
    }

    @Override
    public Object loadInstrument(long instrumentID) throws DSOutOfServiceException, DSAccessException {
        if (instrumentID <= 0L) {
            return null;
        }
        return this.gateway.loadInstrument(instrumentID);
    }

    @Override
    public Object saveAcquisitionData(Object refObject) throws DSOutOfServiceException, DSAccessException {
        if (refObject instanceof ImageAcquisitionData) {
            ImageAcquisitionData data = (ImageAcquisitionData)refObject;
            this.saveImageAcquisitionData(data);
            return null;
        }
        if (refObject instanceof ChannelData) {
            ChannelData data = (ChannelData)refObject;
            this.saveChannelData(data);
        } else if (refObject instanceof ChannelAcquisitionData) {
            ChannelAcquisitionData data = (ChannelAcquisitionData)refObject;
            this.saveChannelAcquisitionData(data);
        }
        return null;
    }

    @Override
    public Object archivedFile(FileAnnotationData fileAnnotation, File file, int index, DataObject linkTo) throws DSOutOfServiceException, DSAccessException {
        FileAnnotationI fa;
        if (file == null) {
            throw new IllegalArgumentException("No file to save.");
        }
        String ns = null;
        switch (index) {
            case 0: {
                ns = "openmicroscopy.org/omero/editor/protocol";
                break;
            }
            case 1: {
                ns = "openmicroscopy.org/omero/editor/experiment";
            }
        }
        long id = fileAnnotation.getId();
        long originalID = fileAnnotation.getFileID();
        OriginalFile of = this.gateway.uploadFile(file, fileAnnotation.getServerFileMimetype(), originalID);
        String desc = fileAnnotation.getDescription();
        if (id < 0L) {
            fa = new FileAnnotationI();
            fa.setFile(of);
            if (desc != null) {
                fa.setDescription(rtypes.rstring((String)desc));
            }
            if (ns != null) {
                fa.setNs(rtypes.rstring((String)ns));
            }
            IObject object = this.gateway.createObject((IObject)fa);
            id = object.getId().getValue();
        } else {
            fa = (FileAnnotation)this.gateway.findIObject(FileAnnotation.class.getName(), id);
            fa.setFile(of);
            if (desc != null) {
                fa.setDescription(rtypes.rstring((String)desc));
            }
            if (ns != null) {
                fa.setNs(rtypes.rstring((String)ns));
            }
            this.gateway.updateObject((IObject)fa, new Parameters());
        }
        fa = (FileAnnotation)this.gateway.findIObject(FileAnnotation.class.getName(), id);
        FileAnnotationData data = (FileAnnotationData)PojoMapper.asDataObject((IObject)fa);
        if (of != null) {
            data.setContent((Object)of);
        }
        if (linkTo != null && linkTo.getId() > 0L) {
            this.annotate(linkTo, (AnnotationData)data);
        }
        return data;
    }

    @Override
    public Collection loadTags(Long id, boolean dataObject, boolean topLevel, long userID, long groupID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        if (groupID >= 0L) {
            po.grp(rtypes.rlong((long)groupID));
        }
        if (topLevel) {
            po.orphan();
            return this.gateway.loadTagSets((Parameters)po);
        }
        Collection l = this.gateway.loadTags(id, (Parameters)po);
        return l;
    }

    @Override
    public long countFileType(long userID, int fileType) throws DSOutOfServiceException, DSAccessException {
        ArrayList<String> include = new ArrayList<String>();
        ArrayList<String> exclude = new ArrayList<String>();
        switch (fileType) {
            case 0: {
                include.add("openmicroscopy.org/omero/editor/protocol");
                break;
            }
            case 1: {
                include.add("openmicroscopy.org/omero/editor/experiment");
                break;
            }
            case 2: {
                include.add("openmicroscopy.org/omero/movie");
                break;
            }
            case 4: {
                return this.gateway.countAnnotationsUsedNotOwned(TagAnnotationData.class, userID);
            }
            default: {
                exclude.add("openmicroscopy.org/omero/editor/protocol");
                exclude.add("openmicroscopy.org/omero/editor/experiment");
                exclude.add("openmicroscopy.org/omero/movie");
                exclude.add("openmicroscopy.org/omero/import/companionFile");
                exclude.add("openmicroscopy.org/omero/measurement");
                exclude.add("openmicroscopy.org/omero/analysis/flim");
            }
        }
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        return this.gateway.countSpecificAnnotation(FileAnnotationData.class, include, exclude, (Parameters)po);
    }

    @Override
    public Collection loadFiles(int fileType, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<String> include = new ArrayList<String>();
        ArrayList<String> exclude = new ArrayList<String>();
        ParametersI po = new ParametersI();
        if (userID >= 0L) {
            po.exp(rtypes.rlong((long)userID));
        }
        switch (fileType) {
            case 0: {
                include.add("openmicroscopy.org/omero/editor/protocol");
                break;
            }
            case 1: {
                include.add("openmicroscopy.org/omero/editor/experiment");
                break;
            }
            case 2: {
                include.add("openmicroscopy.org/omero/movie");
                break;
            }
            case 4: {
                return this.gateway.loadAnnotationsUsedNotOwned(TagAnnotationData.class, userID);
            }
            default: {
                exclude.add("openmicroscopy.org/omero/movie");
                exclude.add("openmicroscopy.org/omero/editor/protocol");
                exclude.add("openmicroscopy.org/omero/editor/experiment");
                exclude.add("openmicroscopy.org/omero/import/companionFile");
                exclude.add("openmicroscopy.org/omero/measurement");
                exclude.add("openmicroscopy.org/omero/analysis/flim");
            }
        }
        return this.gateway.loadSpecificAnnotation(FileAnnotationData.class, include, exclude, (Parameters)po);
    }

    @Override
    public DataObject loadAnnotation(long annotationID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(annotationID);
        Set<DataObject> set = this.gateway.loadAnnotation(ids);
        if (set.size() != 1) {
            return null;
        }
        Iterator<DataObject> i = set.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public List<TableResult> loadTabularData(TableParameters parameters, long userID) throws DSOutOfServiceException, DSAccessException {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        return this.gateway.loadTabularData(parameters, userID);
    }
}

