/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.api.delete.DeleteCommand;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.Channel;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetImageLink;
import omero.model.Event;
import omero.model.FileAnnotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.LongAnnotation;
import omero.model.Pixels;
import omero.model.PlateAnnotationLink;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectDatasetLink;
import omero.model.Screen;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenPlateLink;
import omero.model.TagAnnotation;
import omero.model.WellAnnotationLink;
import omero.model.WellSampleAnnotationLink;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DeleteCallback;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OmeroDataServiceImpl
implements OmeroDataService {
    private Registry context;
    private OMEROGateway gateway;

    private void cut(DataObject parent, Set children) throws DSOutOfServiceException, DSAccessException {
        IObject mParent = parent.asIObject();
        Iterator i = children.iterator();
        ArrayList<Long> ids = new ArrayList<Long>(children.size());
        while (i.hasNext()) {
            ids.add(new Long(((DataObject)i.next()).getId()));
        }
        List links = this.gateway.findLinks(mParent, ids);
        if (links != null) {
            this.gateway.deleteObjects(links);
        }
    }

    private List<IObject> isRelatedToOther(List<IObject> objects) {
        ArrayList<IObject> others = new ArrayList<IObject>();
        if (objects == null) {
            return others;
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        long id = exp.getId();
        for (IObject obj : objects) {
            long ownerID = obj.getDetails().getOwner().getId().getValue();
            if (ownerID == id) continue;
            others.add(obj);
        }
        return others;
    }

    private List<DeletableObject> deleteTagLinks(IObject object) throws DSOutOfServiceException, DSAccessException {
        long id = object.getId().getValue();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        List l = this.gateway.findAnnotationLinks(ImageData.class.getName(), -1L, ids);
        ArrayList<IObject> links = new ArrayList<IObject>();
        if (l != null && l.size() > 0) {
            links.addAll(l);
        }
        if ((l = this.gateway.findAnnotationLinks(DatasetData.class.getName(), -1L, ids)) != null && l.size() > 0) {
            links.addAll(l);
        }
        if ((l = this.gateway.findAnnotationLinks(ProjectData.class.getName(), -1L, ids)) != null && l.size() > 0) {
            links.addAll(l);
        }
        if ((l = this.gateway.findAnnotationLinks(TagAnnotationData.class.getName(), -1L, ids)) != null && l.size() > 0) {
            links.addAll(l);
        }
        if (links.size() > 0) {
            this.gateway.deleteObjects(links);
        }
        this.context.getMetadataService().clearAnnotation(TagAnnotationData.class, id, null);
        return null;
    }

    private List<DataObject> deleteTagSet(long id) throws DSOutOfServiceException, DSAccessException {
        List l = this.gateway.findAnnotationLinks(Annotation.class.getName(), id, null);
        ArrayList<Long> tagIds = new ArrayList<Long>();
        ArrayList<DataObject> tags = new ArrayList<DataObject>();
        for (AnnotationAnnotationLink link : l) {
            long tagID = link.getChild().getId().getValue();
            if (tagIds.contains(tagID)) continue;
            tagIds.add(tagID);
            tags.add(PojoMapper.asDataObject((IObject)link.getChild()));
        }
        this.gateway.deleteObjects(l);
        return tags;
    }

    private List<IObject> annotationsLinkToDelete(List<Class> types, List<IObject> annotations, Class parentType) {
        ArrayList<IObject> toDelete = new ArrayList<IObject>();
        if (types == null || types.size() == 0) {
            return toDelete;
        }
        List<Class> annoTypes = this.convert(types);
        if (annoTypes.size() == 0) {
            return toDelete;
        }
        Iterator<IObject> k = annotations.iterator();
        Annotation child = null;
        while (k.hasNext()) {
            IObject ann = k.next();
            if (ImageData.class.equals((Object)parentType)) {
                child = ((ImageAnnotationLink)ann).getChild();
            } else if (DatasetData.class.equals((Object)parentType)) {
                child = ((DatasetAnnotationLink)ann).getChild();
            } else if (ProjectData.class.equals((Object)parentType)) {
                child = ((ProjectAnnotationLink)ann).getChild();
            } else if (ScreenData.class.equals((Object)parentType)) {
                child = ((ScreenAnnotationLink)ann).getChild();
            } else if (PlateData.class.equals((Object)parentType)) {
                child = ((PlateAnnotationLink)ann).getChild();
            } else if (WellData.class.equals((Object)parentType)) {
                child = ((WellAnnotationLink)ann).getChild();
            } else if (WellSampleData.class.equals((Object)parentType)) {
                child = ((WellSampleAnnotationLink)ann).getChild();
            }
            if (child == null) continue;
            if (child instanceof LongAnnotation) {
                LongAnnotation longA = (LongAnnotation)child;
                RString name = longA.getNs();
                if (name == null || !name.getValue().equals("openmicroscopy.org/omero/insight/rating") || annoTypes.contains(child.getClass())) continue;
                toDelete.add(ann);
                continue;
            }
            if (annoTypes.contains(child.getClass())) continue;
            toDelete.add(ann);
        }
        return toDelete;
    }

    private List<Class> convert(List<Class> list) {
        ArrayList<Class> newList = new ArrayList<Class>();
        for (Class klass : list) {
            Class convertedClass = this.gateway.convertPojos(klass);
            if (convertedClass == null) continue;
            newList.add(convertedClass);
        }
        return newList;
    }

    OmeroDataServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public Set loadContainerHierarchy(Class rootNodeType, List rootNodeIDs, boolean withLeaves, long userID, long groupID) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        if (rootNodeIDs == null) {
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            if (userID < 0L) {
                userID = exp.getId();
            }
            if (groupID < 0L) {
                groupID = exp.getDefaultGroup().getId();
            }
            param.exp(rtypes.rlong((long)userID));
        }
        if (withLeaves) {
            param.leaves();
        } else {
            param.noLeaves();
        }
        if ((rootNodeIDs == null || rootNodeIDs.size() == 0) && (ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType))) {
            param.orphan();
        }
        Set parents = this.gateway.loadContainerHierarchy(rootNodeType, rootNodeIDs, (Parameters)param);
        return parents;
    }

    @Override
    public Set loadTopContainerHierarchy(Class rootNodeType, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        param.exp(rtypes.rlong((long)userID));
        return this.gateway.loadContainerHierarchy(rootNodeType, null, (Parameters)param);
    }

    @Override
    public Set findContainerHierarchy(Class rootNodeType, List leavesIDs, long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        po.leaves();
        po.exp(rtypes.rlong((long)userID));
        return this.gateway.findContainerHierarchy(rootNodeType, leavesIDs, (Parameters)po);
    }

    @Override
    public Set getImages(Class nodeType, List nodeIDs, long userID) throws DSOutOfServiceException, DSAccessException {
        if (nodeType == null) {
            throw new IllegalArgumentException("No type specified.");
        }
        ParametersI po = new ParametersI();
        po.exp(rtypes.rlong((long)userID));
        return this.gateway.getContainerImages(nodeType, nodeIDs, (Parameters)po);
    }

    @Override
    public Set getExperimenterImages(long userID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        po.exp(rtypes.rlong((long)userID));
        return this.gateway.getUserImages((Parameters)po);
    }

    @Override
    public Map getCollectionCount(Class rootNodeType, String property, List rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        if (!property.equals("images")) {
            throw new IllegalArgumentException("Property not supported.");
        }
        return this.gateway.getCollectionCount(rootNodeType, property, rootNodeIDs, new Parameters());
    }

    @Override
    public DataObject createDataObject(DataObject child, DataObject parent, Collection children) throws DSOutOfServiceException, DSAccessException {
        if (child == null) {
            throw new IllegalArgumentException("The child cannot be null.");
        }
        IObject obj = ModelMapper.createIObject(child, parent);
        if (obj == null) {
            throw new NullPointerException("Cannot convert the object.");
        }
        IObject created = this.gateway.createObject(obj);
        if (parent != null) {
            IObject link = ModelMapper.linkParentToChild(created, parent.asIObject());
            if (child instanceof TagAnnotationData && link != null) {
                this.gateway.createObject(link);
            }
        }
        if (children != null && children.size() > 0) {
            Iterator i = children.iterator();
            ArrayList<IObject> links = new ArrayList<IObject>();
            while (i.hasNext()) {
                Object node = i.next();
                if (!(node instanceof DataObject)) continue;
                links.add(ModelMapper.linkParentToChild(((DataObject)node).asIObject(), created));
            }
            if (links.size() > 0) {
                this.gateway.createObjects(links);
            }
        }
        return PojoMapper.asDataObject(created);
    }

    @Override
    public DataObject updateDataObject(DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new DSAccessException("No object to update.");
        }
        if (object instanceof ExperimenterData) {
            return this.updateExperimenter((ExperimenterData)object, null);
        }
        if (!object.isLoaded()) {
            return object;
        }
        IObject ho = null;
        IObject oldObject = null;
        oldObject = object.asIObject();
        ho = this.gateway.findIObject(oldObject);
        if (ho == null) {
            return null;
        }
        ModelMapper.fillIObject(oldObject, ho);
        ModelMapper.unloadCollections(ho);
        IObject updated = this.gateway.updateObject(ho, new Parameters());
        return PojoMapper.asDataObject(updated);
    }

    @Override
    public void addExistingObjects(DataObject parent, Collection children) throws DSOutOfServiceException, DSAccessException {
        if (parent instanceof ProjectData) {
            try {
                children.toArray(new DatasetData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be datasets.");
            }
        } else if (parent instanceof GroupData) {
            try {
                children.toArray(new ExperimenterData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be experimenters.");
            }
        } else if (parent instanceof DatasetData) {
            try {
                children.toArray(new ImageData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be images.");
            }
        } else if (parent instanceof ScreenData) {
            try {
                children.toArray(new PlateData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be plate.");
            }
        } else if (parent instanceof TagAnnotationData) {
            TagAnnotationData tagSet = (TagAnnotationData)parent;
            if (!"openmicroscopy.org/omero/insight/tagset".equals(tagSet.getNameSpace())) {
                throw new IllegalArgumentException("Parent not supported");
            }
            for (Object object : children) {
                if (!(object instanceof TagAnnotationData)) {
                    throw new IllegalArgumentException("items can only be Tag.");
                }
                TagAnnotationData tag = (TagAnnotationData)object;
                if (tag.getNameSpace() == null) continue;
                throw new IllegalArgumentException("items can only be Tag.");
            }
        } else {
            throw new IllegalArgumentException("Parent not supported");
        }
        ArrayList<IObject> objects = new ArrayList<IObject>();
        IObject ioParent = parent.asIObject();
        Iterator child = children.iterator();
        while (child.hasNext()) {
            IObject ioChild = ((DataObject)child.next()).asIObject();
            if (this.gateway.findLink(ioParent, ioChild) != null) continue;
            objects.add(ModelMapper.linkParentToChild(ioChild, ioParent));
        }
        if (objects.size() != 0) {
            this.gateway.createObjects(objects);
        }
    }

    @Override
    public void cutAndPaste(Map toPaste, Map toCut) throws DSOutOfServiceException, DSAccessException {
        Object parent;
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        if (toCut == null) {
            toCut = new HashMap();
        }
        for (Map.Entry entry : toCut.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof DataObject)) continue;
            this.cut((DataObject)parent, (Set)entry.getValue());
        }
        for (Map.Entry entry : toPaste.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof DataObject)) continue;
            this.addExistingObjects((DataObject)parent, (Set)entry.getValue());
        }
    }

    @Override
    public List getChannelsMetadata(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        Pixels pixels = this.gateway.getPixels(pixelsID);
        if (pixels == null) {
            return new ArrayList();
        }
        List l = pixels.copyChannels();
        if (l == null) {
            return new ArrayList();
        }
        Iterator i = l.iterator();
        ArrayList<ChannelData> m = new ArrayList<ChannelData>(l.size());
        int index = 0;
        while (i.hasNext()) {
            m.add(new ChannelData(index, (Channel)i.next()));
            ++index;
        }
        return m;
    }

    @Override
    public Map<Boolean, Object> getArchivedImage(String path, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.context.getLogger().debug((Object)this, path);
        return this.gateway.getArchivedFiles(path, pixelsID);
    }

    public ExperimenterData updateExperimenter(ExperimenterData exp, GroupData group) throws DSOutOfServiceException, DSAccessException {
        if (exp == null) {
            throw new DSAccessException("No object to update.");
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        ExperimenterData user = (ExperimenterData)this.context.lookup("/current_user/details");
        this.gateway.updateExperimenter(exp.asExperimenter(), user.getId());
        if (group != null && exp.getDefaultGroup().getId() != group.getId()) {
            this.gateway.changeCurrentGroup(exp, group.getId());
        }
        ExperimenterData data = this.gateway.getUserDetails(uc.getUserName());
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
        return data;
    }

    @Override
    public Collection getImagesPeriod(Timestamp startTime, Timestamp endTime, long userID, boolean asDataObject) throws DSOutOfServiceException, DSAccessException {
        if (startTime == null && endTime == null) {
            throw new NullPointerException("Time not specified.");
        }
        ParametersI po = new ParametersI();
        po.leaves();
        po.exp(rtypes.rlong((long)userID));
        if (startTime != null) {
            po.startTime(rtypes.rtime((long)startTime.getTime()));
        }
        if (endTime != null) {
            po.endTime(rtypes.rtime((long)endTime.getTime()));
        }
        return this.gateway.getImages((Parameters)po, asDataObject);
    }

    @Override
    public List getImagesAllPeriodCount(Timestamp startTime, Timestamp endTime, long userID) throws DSOutOfServiceException, DSAccessException {
        if (startTime == null || endTime == null) {
            throw new NullPointerException("Time not specified.");
        }
        Collection imgs = this.getImagesPeriod(startTime, endTime, userID, false);
        Iterator i = imgs.iterator();
        ArrayList<Timestamp> times = new ArrayList<Timestamp>(imgs.size());
        while (i.hasNext()) {
            Image object = (Image)i.next();
            Event evt = object.getDetails().getCreationEvent();
            if (evt == null) continue;
            times.add(new Timestamp(evt.getTime().getValue()));
        }
        return times;
    }

    @Override
    public Object advancedSearchFor(SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        if (context == null) {
            throw new IllegalArgumentException("No search context defined.");
        }
        if (!context.isValid()) {
            throw new IllegalArgumentException("Search context not valid.");
        }
        HashMap<Integer, Object> results = new HashMap<Integer, Object>();
        if (!context.hasTextToSearch()) {
            List<ExperimenterData> l = context.getOwners();
            results.put(6, this.gateway.searchByTime(context));
            return results;
        }
        Object result = this.gateway.performSearch(context);
        Map m = (Map)result;
        Iterator i = m.keySet().iterator();
        HashSet<Long> imageIDs = new HashSet<Long>();
        List<ExperimenterData> owners = context.getOwners();
        HashSet<Long> ownerIDs = new HashSet<Long>(owners.size());
        Iterator<Object> k = owners.iterator();
        while (k.hasNext()) {
            ownerIDs.add(((DataObject)k.next()).getId());
        }
        while (i.hasNext()) {
            Integer key = (Integer)i.next();
            Object v = m.get(key);
            if (v instanceof Integer) {
                results.put(key, v);
                continue;
            }
            List value = (List)v;
            HashSet<DataObject> nodes = new HashSet<DataObject>();
            results.put(key, nodes);
            if (value.size() <= 0) continue;
            switch (key) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    Set images = this.gateway.getContainerImages(ImageData.class, value, new Parameters());
                    for (DataObject img : images) {
                        if (imageIDs.contains(img.getId())) continue;
                        imageIDs.add(img.getId());
                        nodes.add(img);
                    }
                    break;
                }
            }
        }
        return results;
    }

    @Override
    public Collection findContainerPaths(Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            Class<Project> parentClass = null;
            if (DatasetData.class.equals((Object)type)) {
                parentClass = Project.class;
            } else if (ImageData.class.equals((Object)type)) {
                parentClass = Dataset.class;
            } else if (PlateData.class.equals((Object)type)) {
                parentClass = Screen.class;
            } else if (TagAnnotationData.class.equals((Object)type)) {
                parentClass = TagAnnotation.class;
            } else if (FileAnnotationData.class.equals((Object)type)) {
                parentClass = FileAnnotation.class;
            }
            if (parentClass == null) {
                return new HashSet();
            }
            List links = this.gateway.findLinks(parentClass, id, userID);
            if (links == null) {
                return new HashSet();
            }
            Iterator i = links.iterator();
            HashSet<DataObject> nodes = new HashSet<DataObject>();
            Project parent = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                long parentId;
                if (parentClass.equals(Project.class)) {
                    parent = ((ProjectDatasetLink)i.next()).getParent();
                } else if (parentClass.equals(Dataset.class)) {
                    parent = ((DatasetImageLink)i.next()).getParent();
                } else if (parentClass.equals(Screen.class)) {
                    parent = ((ScreenPlateLink)i.next()).getParent();
                } else if (parentClass.equals(TagAnnotation.class)) {
                    parent = ((AnnotationAnnotationLink)i.next()).getParent();
                } else if (parentClass.equals(FileAnnotation.class)) {
                    IObject link = (IObject)i.next();
                    if (link instanceof ProjectAnnotationLink) {
                        parent = ((ProjectAnnotationLink)link).getParent();
                    } else if (link instanceof DatasetAnnotationLink) {
                        parent = ((DatasetAnnotationLink)link).getParent();
                    } else if (link instanceof ImageAnnotationLink) {
                        parent = ((ImageAnnotationLink)link).getParent();
                    }
                }
                if (ids.contains(parentId = parent.getId().getValue())) continue;
                IObject object = this.gateway.findIObject(parent.getClass().getName(), parent.getId().getValue());
                DataObject data = PojoMapper.asDataObject(object);
                if (TagAnnotation.class.equals(parentClass)) {
                    TagAnnotationData tag;
                    if (data instanceof TagAnnotationData && "openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)data).getNameSpace())) {
                        nodes.add(data);
                    }
                } else {
                    nodes.add(data);
                }
                ids.add(parentId);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new DSAccessException(e.getMessage());
        }
    }

    @Override
    public Collection getOriginalFiles(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels set ID not valid.");
        }
        return this.gateway.getOriginalFiles(pixelsID);
    }

    @Override
    public Collection loadPlateWells(long plateID, long acquisitionID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadPlateWells(plateID, acquisitionID, userID);
    }

    @Override
    public DeleteCallback delete(Collection<DeletableObject> objects) throws DSOutOfServiceException, DSAccessException, ProcessException {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Iterator<DeletableObject> i = objects.iterator();
        ArrayList<DeleteCommand> commands = new ArrayList<DeleteCommand>();
        Object groups = null;
        while (i.hasNext()) {
            List<DataObject> contents = null;
            DeletableObject object = i.next();
            DataObject data = object.getObjectToDelete();
            List<Class> annotations = object.getAnnotations();
            HashMap<String, String> options = null;
            if (annotations != null && annotations.size() > 0) {
                options = new HashMap<String, String>();
                Iterator<Class> j = annotations.iterator();
                while (j.hasNext()) {
                    options.put(this.gateway.createDeleteOption(j.next().getName()), "KEEP");
                }
            }
            if (!object.deleteContent()) {
                if (options == null) {
                    options = new HashMap();
                }
                if (data instanceof DatasetData) {
                    options.put(this.gateway.createDeleteCommand(ImageData.class.getName()), "KEEP");
                } else if (data instanceof ProjectData) {
                    options.put(this.gateway.createDeleteCommand(DatasetData.class.getName()), "KEEP");
                    options.put(this.gateway.createDeleteCommand(ImageData.class.getName()), "KEEP");
                } else if (data instanceof ScreenData) {
                    options.put(this.gateway.createDeleteCommand(PlateData.class.getName()), "KEEP");
                    options.put(this.gateway.createDeleteCommand(WellData.class.getName()), "KEEP");
                    options.put(this.gateway.createDeleteCommand(PlateAcquisitionData.class.getName()), "KEEP");
                    options.put(this.gateway.createDeleteCommand(ImageData.class.getName()), "KEEP");
                } else if (data instanceof TagAnnotationData) {
                    options = null;
                    String ns = ((TagAnnotationData)data).getNameSpace();
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                        contents = this.deleteTagSet(data.getId());
                    }
                }
            }
            DeleteCommand cmd = new DeleteCommand(this.gateway.createDeleteCommand(data.getClass().getName()), data.getId(), options);
            commands.add(cmd);
            if (contents == null || contents.size() <= 0) continue;
            for (DataObject d : contents) {
                cmd = new DeleteCommand(this.gateway.createDeleteCommand(d.getClass().getName()), d.getId(), options);
                commands.add(cmd);
            }
        }
        return this.gateway.deleteObject(commands.toArray(new DeleteCommand[0]));
    }

    @Override
    public FSFileSystemView getFSRepositories(long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getFSRepositories(userID);
    }
}

