/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import Ice.ConnectionLostException;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.log.LogMessage;

class KeepClientAlive
implements Runnable {
    private OMEROGateway gateway;
    private Container container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            OMEROGateway oMEROGateway = this.gateway;
            synchronized (oMEROGateway) {
                this.gateway.keepSessionAlive();
            }
        }
        catch (Throwable t) {
            LogMessage message = new LogMessage();
            message.append("Exception while keeping the services alive.\n");
            message.print(t);
            this.container.getRegistry().getLogger().error((Object)this, message);
            Throwable cause = t.getCause();
            int index = 1;
            if (cause instanceof ConnectionLostException) {
                index = 0;
            }
            try {
                DataServicesFactory f = DataServicesFactory.getInstance(this.container);
                if (f.isConnected()) {
                    f.sessionExpiredExit(index);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    KeepClientAlive(Container container, OMEROGateway gateway) {
        if (container == null) {
            throw new IllegalArgumentException("No container specified.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway specified.");
        }
        this.gateway = gateway;
        this.container = container;
    }
}

