/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.IObject;
import omero.model.Permissions;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.PermissionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdminServiceImpl
implements AdminService {
    private Registry context;
    private OMEROGateway gateway;

    private ExperimenterData updateExperimenter(ExperimenterData exp, GroupData group, boolean asAdmin) throws DSOutOfServiceException, DSAccessException {
        ExperimenterData currentUser = (ExperimenterData)this.context.lookup("/current_user/details");
        if (!asAdmin && exp.getId() != currentUser.getId()) {
            return exp;
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        this.gateway.updateExperimenter(exp.asExperimenter(), currentUser.getId());
        if (group != null && exp.getDefaultGroup().getId() != group.getId()) {
            this.gateway.changeCurrentGroup(exp, group.getId());
        }
        String userName = uc.getUserName();
        if (asAdmin) {
            userName = exp.getUserName();
        }
        ExperimenterData data = this.gateway.getUserDetails(userName);
        if (currentUser.getId() != exp.getId()) {
            return data;
        }
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            if (!agentInfo.isActive()) continue;
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
        return data;
    }

    AdminServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public String getServerName() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        return uc.getHostName();
    }

    @Override
    public String getServerVersion() {
        try {
            return this.gateway.getServerVersion();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getLoggingName() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        return uc.getUserName();
    }

    @Override
    public long getSpace(int index, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            switch (index) {
                case 100: {
                    return this.gateway.getUsedSpace(userID);
                }
                case 101: {
                    return this.gateway.getFreeSpace();
                }
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public Boolean changePassword(String oldPassword, String newPassword) throws DSOutOfServiceException, DSAccessException {
        if (newPassword == null || newPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (!uc.getPassword().equals(oldPassword)) {
            return false;
        }
        this.gateway.changePassword(newPassword, oldPassword);
        uc.resetPassword(newPassword);
        return true;
    }

    @Override
    public void changeExperimenterGroup(ExperimenterData exp, long groupID) throws DSOutOfServiceException, DSAccessException {
        UserCredentials uc;
        if (exp == null) {
            throw new DSAccessException("No object to update.");
        }
        if (groupID < 0L) {
            throw new DSAccessException("No group specified.");
        }
        if (exp.getDefaultGroup().getId() != groupID) {
            uc = (UserCredentials)this.context.lookup("/user/credentials");
            this.gateway.changeCurrentGroup(exp, groupID);
        }
        uc = (UserCredentials)this.context.lookup("/user/credentials");
        ExperimenterData data = this.gateway.getUserDetails(uc.getUserName());
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            if (!agentInfo.isActive()) continue;
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
    }

    @Override
    public ExperimenterData updateExperimenter(ExperimenterData exp, GroupData group) throws DSOutOfServiceException, DSAccessException {
        return this.updateExperimenter(exp, group, false);
    }

    @Override
    public List<ExperimenterData> createExperimenters(AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
        if (m == null || m.size() == 0) {
            throw new IllegalArgumentException("No experimenters to create.");
        }
        return this.gateway.createExperimenters(object);
    }

    @Override
    public GroupData createGroup(AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (object.getGroup() == null) {
            throw new IllegalArgumentException("No group.");
        }
        return this.gateway.createGroup(object);
    }

    @Override
    public List<ExperimenterData> loadExperimenters(long groupID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> l = new ArrayList<ExperimenterData>();
        return l;
    }

    @Override
    public List<GroupData> loadGroups(long id) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadGroups(id);
    }

    @Override
    public List<ExperimenterData> deleteExperimenters(List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        if (experimenters == null || experimenters.size() == 0) {
            throw new IllegalArgumentException("No experimenters to delete.");
        }
        return this.gateway.deleteExperimenters(experimenters);
    }

    @Override
    public List<GroupData> deleteGroups(List<GroupData> groups) throws DSOutOfServiceException, DSAccessException {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("No groups to delete.");
        }
        return this.gateway.deleteGroups(groups);
    }

    @Override
    public int getPermissionLevel(GroupData group) {
        PermissionData perm;
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        if (group == null) {
            group = exp.getDefaultGroup();
        }
        if ((perm = group.getPermissions()).isGroupRead()) {
            if (perm.isGroupWrite()) {
                return 102;
            }
            return 101;
        }
        if (perm.isWorldRead()) {
            if (perm.isWorldWrite()) {
                return 104;
            }
            return 103;
        }
        return 100;
    }

    @Override
    public int getPermissionLevel() {
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        GroupData g = exp.getDefaultGroup();
        return this.getPermissionLevel(g);
    }

    @Override
    public GroupData updateGroup(GroupData group, int permissions) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group to update.");
        }
        ExperimenterGroup g = group.asGroup();
        Permissions p = null;
        if (permissions != -1) {
            p = g.getDetails().getPermissions();
            this.gateway.setPermissionsLevel(p, permissions);
        }
        return this.gateway.updateGroup(g, p);
    }

    @Override
    public List<ExperimenterData> copyExperimenters(GroupData group, Set experimenters) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        if (experimenters == null || experimenters.size() == 0) {
            return new ArrayList<ExperimenterData>();
        }
        return this.gateway.copyExperimenters(group, experimenters);
    }

    @Override
    public List<ExperimenterData> cutAndPasteExperimenters(Map toPaste, Map toCut) throws DSOutOfServiceException, DSAccessException {
        Object parent;
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        if (toCut == null) {
            toCut = new HashMap();
        }
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        for (Map.Entry entry : toCut.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof GroupData)) continue;
            r.addAll(this.gateway.removeExperimenters((GroupData)parent, (Set)entry.getValue()));
        }
        for (Map.Entry entry : toPaste.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof GroupData)) continue;
            r.addAll(this.copyExperimenters((GroupData)parent, (Set)entry.getValue()));
        }
        return r;
    }

    @Override
    public Map<Long, Long> countExperimenters(List<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.size() == 0) {
            return new HashMap<Long, Long>();
        }
        return this.gateway.countExperimenters(ids);
    }

    @Override
    public Map<ExperimenterData, Exception> updateExperimenters(GroupData group, Map<ExperimenterData, UserCredentials> experimenters) throws DSOutOfServiceException, DSAccessException {
        if (experimenters == null) {
            throw new IllegalArgumentException("No experimenters to update");
        }
        Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = experimenters.entrySet().iterator();
        HashMap<ExperimenterData, Exception> l = new HashMap<ExperimenterData, Exception>();
        ArrayList<Experimenter> ownersToAdd = new ArrayList<Experimenter>();
        ArrayList<Experimenter> ownersToRemove = new ArrayList<Experimenter>();
        ArrayList<Experimenter> administratorsToAdd = new ArrayList<Experimenter>();
        ArrayList<Experimenter> administratorsToRemove = new ArrayList<Experimenter>();
        ArrayList<ExperimenterData> toActivate = new ArrayList<ExperimenterData>();
        ArrayList<ExperimenterData> toDeactivate = new ArrayList<ExperimenterData>();
        boolean reset = false;
        while (i.hasNext()) {
            Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
            ExperimenterData exp = entry.getKey();
            UserCredentials uc = entry.getValue();
            try {
                this.updateExperimenter(exp, group, true);
                Boolean b = uc.isOwner();
                if (b != null) {
                    if (b.booleanValue()) {
                        ownersToAdd.add(exp.asExperimenter());
                    } else {
                        ownersToRemove.add(exp.asExperimenter());
                    }
                }
                if ((b = uc.isAdministrator()) != null) {
                    if (b.booleanValue()) {
                        administratorsToAdd.add(exp.asExperimenter());
                    } else {
                        administratorsToRemove.add(exp.asExperimenter());
                    }
                }
                if ((b = uc.isActive()) != null) {
                    if (b.booleanValue()) {
                        toActivate.add(exp);
                    } else {
                        toDeactivate.add(exp);
                    }
                }
                if (exp.getUserName().equals(uc.getUserName()) || (reset = this.gateway.resetUserName(uc.getUserName(), exp))) continue;
                l.put(exp, new Exception("The selected User Name is already taken."));
            }
            catch (Exception e) {
                l.put(exp, e);
            }
        }
        if (group != null) {
            if (ownersToAdd.size() > 0) {
                this.gateway.handleGroupOwners(true, group.asGroup(), ownersToAdd);
            }
            if (ownersToRemove.size() > 0) {
                this.gateway.handleGroupOwners(false, group.asGroup(), ownersToRemove);
            }
        }
        if (toActivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(true, toActivate, "user");
        }
        if (toDeactivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(false, toDeactivate, "user");
        }
        return l;
    }

    @Override
    public List<ExperimenterData> resetExperimentersPassword(AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        if (4 != object.getIndex()) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        Map<ExperimenterData, UserCredentials> map = object.getExperimenters();
        if (map == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        ArrayList<ExperimenterData> l = new ArrayList<ExperimenterData>();
        for (Map.Entry<ExperimenterData, UserCredentials> entry : map.entrySet()) {
            ExperimenterData exp = entry.getKey();
            UserCredentials uc = entry.getValue();
            try {
                String ldap = this.gateway.lookupLdapAuthExperimenter(exp.getId());
                if (ldap != null && ldap.length() > 0) {
                    l.add(exp);
                    continue;
                }
                this.gateway.resetPassword(exp.getUserName(), exp.getId(), uc.getPassword());
            }
            catch (Exception e) {
                l.add(exp);
            }
        }
        return l;
    }

    @Override
    public List<GroupData> reloadPIGroups(ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        GroupData g;
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        Set<GroupData> groups = this.gateway.getAvailableGroups(exp);
        Iterator<Object> i = groups.iterator();
        HashSet<GroupData> available = new HashSet<GroupData>();
        while (i.hasNext()) {
            g = i.next();
            if (!this.gateway.isSystemGroup(g.asGroup())) {
                available.add(g);
                continue;
            }
            if (!"system".equals(g.getName())) continue;
            uc.setAdministrator(true);
        }
        this.context.bind("/userGroup/details", available);
        ArrayList<Long> ids = new ArrayList<Long>();
        i = available.iterator();
        while (i.hasNext()) {
            g = (GroupData)i.next();
            Set set = g.getExperimenters();
            for (ExperimenterData e : set) {
                if (ids.contains(e.getId())) continue;
                ids.add(e.getId());
                exps.add(e);
            }
        }
        this.context.bind("/users/details", exps);
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        Iterator k = available.iterator();
        while (k.hasNext()) {
            result.add((GroupData)k.next());
        }
        List agents = (List)this.context.lookup("/agents");
        Iterator j = agents.iterator();
        while (i.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)j.next();
            if (!agentInfo.isActive()) continue;
            Registry reg = agentInfo.getRegistry();
            reg.bind("/userGroup/details", available);
            reg.bind("/users/details", exps);
        }
        return result;
    }

    @Override
    public ExperimenterData lookupExperimenter(String name) throws DSOutOfServiceException, DSAccessException {
        Experimenter value = this.gateway.lookupExperimenter(name);
        if (value != null) {
            return (ExperimenterData)PojoMapper.asDataObject((IObject)value);
        }
        return null;
    }

    @Override
    public GroupData lookupGroup(String name) throws DSOutOfServiceException, DSAccessException {
        ExperimenterGroup value = this.gateway.lookupGroup(name);
        if (value != null) {
            return (GroupData)PojoMapper.asDataObject((IObject)value);
        }
        return null;
    }

    @Override
    public BufferedImage uploadUserPhoto(File f, String format, ExperimenterData experimenter) throws DSOutOfServiceException, DSAccessException {
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter specified.");
        }
        if (f == null) {
            throw new IllegalArgumentException("No photo specified.");
        }
        long id = this.gateway.uploadExperimenterPhoto(f, format, experimenter.getId());
        if (id < 0L) {
            return null;
        }
        ArrayList<DataObject> exp = new ArrayList<DataObject>();
        exp.add((DataObject)experimenter);
        Map<DataObject, BufferedImage> map = this.context.getImageService().getExperimenterThumbnailSet(exp, 0);
        return map.get(experimenter);
    }
}

