/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FontEntry
extends Entry {
    private static Map<String, Integer> FONT_STYLES = new HashMap<String, Integer>();
    private static final String FAMILY_TAG = "family";
    private static final String SIZE_TAG = "size";
    private static final String STYLE_TAG = "style";
    private static final int DEFAULT_SIZE = 12;
    private static final int MIN_SIZE = 2;
    private static final int MAX_SIZE = 20;
    private static final int DEFAULT_STYLE = 0;
    private Font value;

    private int getSize(Map fontAttributes) {
        String value = (String)fontAttributes.get(SIZE_TAG);
        int size = 12;
        try {
            size = Integer.parseInt(value);
            if (size < 2 || 20 < size) {
                size = 12;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return size;
    }

    private int getStyle(Map fontAttributes) {
        String value = (String)fontAttributes.get(STYLE_TAG);
        int style = 0;
        Integer id = FONT_STYLES.get(value);
        if (id != null) {
            style = id;
        }
        return style;
    }

    private Map extractValues(Node entry) throws DOMException, ConfigException {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (entry.hasChildNodes()) {
            NodeList children = entry.getChildNodes();
            int n = children.getLength();
            while (0 < n) {
                Node child;
                if ((child = children.item(--n)).getNodeType() != 1) continue;
                this.extractFontTag(child, tags);
            }
        }
        if (tags.keySet().size() != 3) {
            throw new ConfigException("Missing tags within font tag.");
        }
        return tags;
    }

    private void extractFontTag(Node tag, Map<String, String> values) throws DOMException, ConfigException {
        String tagName = tag.getNodeName();
        String tagValue = tag.getFirstChild().getNodeValue();
        if (FAMILY_TAG.equals(tagName) || SIZE_TAG.equals(tagName) || STYLE_TAG.equals(tagName)) {
            values.put(tagName, tagValue);
            return;
        }
        throw new ConfigException("Unrecognized tag within the font entry: " + tagName);
    }

    FontEntry() {
    }

    @Override
    Object getValue() {
        return this.value;
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        try {
            Map tags = this.extractValues(node);
            this.value = new Font((String)tags.get(FAMILY_TAG), this.getStyle(tags), this.getSize(tags));
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse font entry.", dex);
        }
    }

    static {
        FONT_STYLES.put("plain", new Integer(0));
        FONT_STYLES.put("italic", new Integer(2));
        FONT_STYLES.put("bold", new Integer(1));
    }
}

