/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorEntry
extends Entry {
    private static final String RED_TAG = "red";
    private static final String GREEN_TAG = "green";
    private static final String BLUE_TAG = "blue";
    private static final int DEFAULT_RED = 255;
    private static final int DEFAULT_GREEN = 255;
    private static final int DEFAULT_BLUE = 255;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private Color value;

    private int getRedComponent(Map colorAttributes) {
        String value = (String)colorAttributes.get(RED_TAG);
        return this.parseValue(value, 255);
    }

    private int getGreenComponent(Map colorAttributes) {
        String value = (String)colorAttributes.get(GREEN_TAG);
        return this.parseValue(value, 255);
    }

    private int getBlueComponent(Map colorAttributes) {
        String value = (String)colorAttributes.get(BLUE_TAG);
        return this.parseValue(value, 255);
    }

    private int parseValue(String value, int defaultValue) {
        int v = defaultValue;
        try {
            v = Integer.parseInt(value);
            if (v < 0 || 255 < v) {
                v = defaultValue;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return v;
    }

    private Map extractValues(Node entry) throws DOMException, ConfigException {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (entry.hasChildNodes()) {
            NodeList children = entry.getChildNodes();
            int n = children.getLength();
            while (0 < n) {
                Node child;
                if ((child = children.item(--n)).getNodeType() != 1) continue;
                this.extractColorTag(child, tags);
            }
        }
        if (tags.keySet().size() != 3) {
            throw new ConfigException("Missing tags within color tag.");
        }
        return tags;
    }

    private void extractColorTag(Node tag, Map<String, String> values) throws DOMException, ConfigException {
        String tagName = tag.getNodeName();
        String tagValue = tag.getFirstChild().getNodeValue();
        if (RED_TAG.equals(tagName) || GREEN_TAG.equals(tagName) || BLUE_TAG.equals(tagName)) {
            values.put(tagName, tagValue);
            return;
        }
        throw new ConfigException("Unrecognized tag within the color entry: " + tagName);
    }

    ColorEntry() {
    }

    @Override
    Object getValue() {
        return this.value;
    }

    @Override
    protected void setContent(Node tag) throws ConfigException {
        try {
            Map tags = this.extractValues(tag);
            this.value = new Color(this.getRedComponent(tags), this.getGreenComponent(tags), this.getBlueComponent(tags));
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse font entry.", dex);
        }
    }
}

