/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.cache;

import java.io.InputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.openmicroscopy.shoola.env.cache.CacheService;

class CacheServiceImpl
implements CacheService {
    private CacheManager manager;
    private int cacheID;

    CacheServiceImpl(InputStream stream) {
        this.manager = new CacheManager(stream);
        this.cacheID = -1;
    }

    void shutDown() {
        try {
            this.manager.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int createCache() {
        return this.createCache(0);
    }

    public int createCache(int type, int size) {
        if (size < 0) {
            size = 0;
        }
        switch (type) {
            case 1: {
                return -1;
            }
            case 2: {
                ++this.cacheID;
                Cache cache = new Cache("" + this.cacheID, size, MemoryStoreEvictionPolicy.LRU, true, this.manager.getDiskStorePath(), false, 300L, 600L, false, 300L, null, null, 10000000);
                this.manager.addCache(cache);
                break;
            }
            case 0: {
                ++this.cacheID;
                this.manager.addCache("" + this.cacheID);
                break;
            }
            default: {
                return -1;
            }
        }
        return this.cacheID;
    }

    public int createCache(int type) {
        return this.createCache(type, 10);
    }

    public void removeCache(int cacheID) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cache != null) {
            this.manager.removeCache("" + cacheID);
        }
    }

    public void addElement(int cacheID, Object key, Object element) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cache == null) {
            return;
        }
        if (cache.getSize() >= cache.getCacheConfiguration().getMaxElementsInMemory()) {
            cache.flush();
        }
        cache.put(new Element(key, element));
    }

    public Object getElement(int cacheID, Object key) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cache == null) {
            return null;
        }
        Element element = null;
        try {
            element = cache.get(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public void clearCache(int cacheID) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cache == null) {
            return;
        }
        cache.removeAll();
    }

    public void clearAllCaches() {
        String[] names = this.manager.getCacheNames();
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            Cache cache = this.manager.getCache(names[i]);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    public void setCacheEntries(int cacheID, int size) {
        Cache cache = null;
        try {
            cache = this.manager.getCache("" + cacheID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cache == null) {
            return;
        }
        cache.flush();
        cache.getCacheConfiguration().setMaxElementsInMemory(size);
    }
}

