/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarNodesVisitor
implements TreeImageDisplayVisitor {
    private List<TreeImageDisplay> foundNodes;
    private List<TreeImageDisplay> nodes;

    private void handleNode(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        Object ho = node.getUserObject();
        if (ho == null || !(ho instanceof DataObject)) {
            return;
        }
        DataObject ref = (DataObject)ho;
        for (TreeImageDisplay n : this.nodes) {
            DataObject data;
            Object uo = n.getUserObject();
            if (!(uo instanceof DataObject) || !(data = (DataObject)uo).getClass().equals(ref.getClass()) || data.getId() != ref.getId()) continue;
            this.foundNodes.add(node);
            break;
        }
    }

    public SimilarNodesVisitor(List<TreeImageDisplay> nodes) {
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes of reference.");
        }
        this.nodes = nodes;
        this.foundNodes = new ArrayList<TreeImageDisplay>();
    }

    public List<TreeImageDisplay> getFoundNodes() {
        return this.foundNodes;
    }

    @Override
    public void visit(TreeImageNode node) {
        this.handleNode(node);
    }

    @Override
    public void visit(TreeImageSet node) {
        this.handleNode(node);
    }
}

