/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.util.DataObjectListCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.FileAnnotationData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionWizardUI
extends JPanel
implements ActionListener {
    static final String SELECTION_CHANGE = "selectionChangeProperty";
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int ADD_ALL = 2;
    private static final int REMOVE_ALL = 3;
    private List<Object> originalItems;
    private List<Object> originalSelectedItems;
    private Collection<Object> availableItems;
    private Collection<Object> selectedItems;
    private JList availableItemsListbox;
    private JList selectedItemsListbox;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private ViewerSorter sorter;
    private Class type;
    private Collection immutable;
    private DataObjectListCellRenderer cellRendererLeft;
    private DataObjectListCellRenderer cellRendererRight;

    private boolean doesObjectExist(DataObject object) {
        Iterator<Object> i = this.availableItems.iterator();
        if (object instanceof TagAnnotationData) {
            String value = ((TagAnnotationData)object).getTagValue();
            while (i.hasNext()) {
                TagAnnotationData tagAnnotationData = (TagAnnotationData)i.next();
                if (!tagAnnotationData.getTagValue().equals(value)) continue;
                return true;
            }
            for (TagAnnotationData tagAnnotationData : this.selectedItems) {
                if (!tagAnnotationData.getTagValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void initComponents(long userID) {
        this.sorter = new ViewerSorter();
        this.availableItemsListbox = new JList();
        this.cellRendererLeft = new DataObjectListCellRenderer(userID, this);
        this.availableItemsListbox.setCellRenderer(this.cellRendererLeft);
        this.selectedItemsListbox = new JList();
        this.cellRendererRight = new DataObjectListCellRenderer(userID, this);
        this.selectedItemsListbox.setCellRenderer(this.cellRendererRight);
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(86));
        this.removeButton = new JButton(icons.getIcon(87));
        this.addAllButton = new JButton(icons.getIcon(84));
        this.removeAllButton = new JButton(icons.getIcon(85));
        this.addButton.setActionCommand("0");
        this.addButton.addActionListener(this);
        this.addAllButton.setActionCommand("2");
        this.addAllButton.addActionListener(this);
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeAllButton.setActionCommand("3");
        this.removeAllButton.addActionListener(this);
        this.setImmutableElements(null);
    }

    private void createOriginalSelections() {
        this.originalItems = new ArrayList<Object>();
        if (this.availableItems != null) {
            for (Object item : this.availableItems) {
                this.originalItems.add(item);
            }
        }
        this.originalSelectedItems = new ArrayList<Object>();
        if (this.selectedItems != null) {
            for (Object item : this.selectedItems) {
                this.originalSelectedItems.add(item);
            }
        }
    }

    private void addAllItems() {
        for (Object item : this.availableItems) {
            this.selectedItems.add(item);
        }
        this.availableItems.clear();
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setSelectionChange();
    }

    private boolean isImmutable(DataObject data) {
        for (DataObject o : this.immutable) {
            if (data.getId() != o.getId()) continue;
            return true;
        }
        return false;
    }

    private void removeItem() {
        if (this.selectedItemsListbox.getSelectedIndex() == -1) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.selectedItemsListbox.getModel();
        int[] indexes = this.selectedItemsListbox.getSelectedIndices();
        for (int i = 0; i < indexes.length; ++i) {
            Object object = model.getElementAt(indexes[i]);
            if (!this.selectedItems.contains(object)) continue;
            if (TagAnnotationData.class.equals((Object)this.type) || FileAnnotationData.class.equals((Object)this.type)) {
                DataObject data = (DataObject)object;
                if (!this.originalSelectedItems.contains(object)) {
                    this.selectedItems.remove(object);
                    if (data.getId() <= 0L) continue;
                    this.availableItems.add(object);
                    continue;
                }
                if (this.isImmutable(data)) continue;
                this.selectedItems.remove(object);
                this.availableItems.add(object);
                continue;
            }
            this.selectedItems.remove(object);
            this.availableItems.add(object);
        }
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setSelectionChange();
    }

    private void removeAllItems() {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        if (TagAnnotationData.class.equals((Object)this.type) || FileAnnotationData.class.equals((Object)this.type)) {
            for (Object item : this.selectedItems) {
                DataObject data = (DataObject)item;
                if (!this.originalSelectedItems.contains(data)) {
                    if (data.getId() <= 0L) continue;
                    this.availableItems.add(item);
                    toRemove.add(item);
                    continue;
                }
                if (this.isImmutable(data)) continue;
                toRemove.add(item);
                this.availableItems.add(data);
            }
            Iterator i = toRemove.iterator();
            while (i.hasNext()) {
                this.selectedItems.remove(i.next());
            }
        } else {
            for (Object item : this.selectedItems) {
                this.availableItems.add(item);
            }
            this.selectedItems.clear();
        }
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setSelectionChange();
    }

    private void addItem() {
        if (this.availableItemsListbox.getSelectedIndex() == -1) {
            return;
        }
        int[] indexes = this.availableItemsListbox.getSelectedIndices();
        DefaultListModel model = (DefaultListModel)this.availableItemsListbox.getModel();
        for (int i = 0; i < indexes.length; ++i) {
            Object object = model.getElementAt(indexes[i]);
            if (!this.availableItems.contains(object)) continue;
            this.selectedItems.add(object);
            this.availableItems.remove(object);
        }
        this.sortLists();
        this.populateSelectedItems();
        this.populateAvailableItems();
        this.setSelectionChange();
    }

    private void setSelectionChange() {
        boolean b = false;
        if (this.originalSelectedItems.size() != this.selectedItems.size()) {
            b = true;
        } else {
            int n = 0;
            Iterator<Object> i = this.selectedItems.iterator();
            while (i.hasNext()) {
                if (!this.originalSelectedItems.contains(i.next())) continue;
                ++n;
            }
            b = n != this.originalSelectedItems.size();
        }
        this.firePropertyChange(SELECTION_CHANGE, (Object)(!b ? 1 : 0), (Object)b);
    }

    private void populateSelectedItems() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object item : this.selectedItems) {
            listModel.addElement(item);
        }
        this.selectedItemsListbox.setModel(listModel);
    }

    private void populateAvailableItems() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object item : this.availableItems) {
            listModel.addElement(item);
        }
        this.availableItemsListbox.setModel(listModel);
    }

    private void sortLists() {
        if (this.availableItems != null) {
            this.availableItems = this.sorter.sort(this.availableItems);
        }
        if (this.selectedItems != null) {
            this.selectedItems = this.sorter.sort(this.selectedItems);
        }
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        double[][] size = new double[][]{{-1.0, 40.0, -1.0}, {-1.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.createAvailableItemsPane(), "0, 0");
        this.add((Component)this.createSelectionPane(), "1, 0, CENTER, CENTER");
        this.add((Component)this.createSelectedItemsPane(), "2, 0");
    }

    private JPanel createAvailableItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)UIUtilities.setTextFont("Available:"), "North");
        p.add((Component)new JScrollPane(this.availableItemsListbox), "Center");
        this.populateAvailableItems();
        return p;
    }

    private JPanel createSelectionPane() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(Box.createVerticalStrut(30));
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.addAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        return buttonPanel;
    }

    private JPanel createSelectedItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)UIUtilities.setTextFont("Selected:"), "North");
        p.add((Component)new JScrollPane(this.selectedItemsListbox), "Center");
        this.populateSelectedItems();
        return p;
    }

    public SelectionWizardUI(Collection<Object> available, Class type, long userID) {
        this(available, null, type, userID);
    }

    public SelectionWizardUI(Collection<Object> available, Collection<Object> selected, Class type, long userID) {
        if (selected == null) {
            selected = new ArrayList<Object>();
        }
        if (available == null) {
            available = new ArrayList<Object>();
        }
        this.availableItems = available;
        this.selectedItems = selected;
        this.type = type;
        this.createOriginalSelections();
        this.initComponents(userID);
        this.sortLists();
        this.buildGUI();
    }

    void reset() {
        this.availableItems.clear();
        this.selectedItems.clear();
        for (Object item : this.originalItems) {
            this.availableItems.add(item);
        }
        for (Object item : this.originalSelectedItems) {
            this.selectedItems.add(item);
        }
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setSelectionChange();
    }

    void addObjects(List<DataObject> toAdd) {
        if (toAdd == null || toAdd.size() == 0) {
            return;
        }
        for (DataObject data : toAdd) {
            if (this.doesObjectExist(data)) continue;
            this.selectedItems.add(data);
        }
        this.sortLists();
        this.populateSelectedItems();
        this.setSelectionChange();
    }

    void setImmutableElements(Collection immutable) {
        if (immutable == null) {
            immutable = new ArrayList();
        }
        this.immutable = immutable;
        this.cellRendererRight.setImmutableElements(immutable);
    }

    boolean isAddedNode(Object value) {
        return !this.originalSelectedItems.contains(value);
    }

    public Collection<Object> getSelection() {
        Iterator<Object> i = this.selectedItems.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        while (i.hasNext()) {
            Object object = i.next();
            if (this.isAddedNode(object)) {
                results.add(object);
                continue;
            }
            if (object instanceof DataObject) {
                if (this.isImmutable((DataObject)object)) continue;
                results.add(object);
                continue;
            }
            results.add(object);
        }
        return this.selectedItems;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = Integer.parseInt(evt.getActionCommand());
        switch (id) {
            case 0: {
                this.addItem();
                break;
            }
            case 2: {
                this.addAllItems();
                break;
            }
            case 1: {
                this.removeItem();
                break;
            }
            case 3: {
                this.removeAllItems();
            }
        }
    }
}

