/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.AdminCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectRemover;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectUpdater;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.ImagesImporter;
import org.openmicroscopy.shoola.agents.treeviewer.OriginalFileLoader;
import org.openmicroscopy.shoola.agents.treeviewer.PlateWellsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ProjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RndSettingsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.TagHierarchyLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TimeIntervalsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.ImportObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerModel {
    private int state;
    private DataTreeViewerLoader currentLoader;
    private Map<Integer, Browser> browsers;
    private Browser selectedBrowser;
    private long rootID;
    private long userGroupID;
    private ExperimenterData experimenter;
    private Finder finder;
    private TreeImageDisplay[] nodesToCopy;
    private int copyIndex;
    private boolean recycled;
    private boolean rollOver;
    private ImageData refImage;
    private MetadataViewer metadataViewer;
    private DataBrowser dataViewer;
    private AdvancedFinder advancedFinder;
    protected TreeViewer component;
    private Map<Integer, ImagesImporter> importLoaders;
    private int importID;
    private boolean fullScreen;

    private Map buildCopyMap(TreeImageDisplay[] parents) {
        Object uo = this.nodesToCopy[0].getUserObject();
        Object uoParent = parents[0].getUserObject();
        if (!(uo instanceof DataObject)) {
            return null;
        }
        if (!(uoParent instanceof DataObject)) {
            return null;
        }
        DataObject obj = (DataObject)uo;
        DataObject objParent = (DataObject)uoParent;
        if (objParent instanceof ProjectData && obj instanceof DatasetData || objParent instanceof DatasetData && obj instanceof ImageData || objParent instanceof ScreenData && obj instanceof PlateData || objParent instanceof GroupData && obj instanceof ExperimenterData) {
            HashMap map = new HashMap(parents.length);
            for (int i = 0; i < parents.length; ++i) {
                HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                for (int j = 0; j < this.nodesToCopy.length; ++j) {
                    children.add(this.nodesToCopy[j].getUserObject());
                }
                map.put(parents[i].getUserObject(), children);
            }
            return map;
        }
        if (obj instanceof TagAnnotationData && objParent instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)obj;
            TagAnnotationData tagSet = (TagAnnotationData)objParent;
            String nsSet = tagSet.getNameSpace();
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(nsSet) && ns == null) {
                HashMap map = new HashMap(parents.length);
                for (int i = 0; i < parents.length; ++i) {
                    HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                    for (int j = 0; j < this.nodesToCopy.length; ++j) {
                        children.add(this.nodesToCopy[j].getUserObject());
                    }
                    map.put(parents[i].getUserObject(), children);
                }
                return map;
            }
        }
        return null;
    }

    private Map buildCutMap(TreeImageDisplay[] nodes) {
        HashMap<Object, HashSet<Object>> map = new HashMap<Object, HashSet<Object>>();
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay child = nodes[i];
            TreeImageDisplay parent = child.getParentDisplay();
            if (parent == null) continue;
            Object po = parent.getUserObject();
            HashSet<Object> children = (HashSet<Object>)map.get(po);
            if (children == null) {
                children = new HashSet<Object>();
                map.put(po, children);
            }
            children.add(nodes[i].getUserObject());
        }
        return map;
    }

    private void createBrowsers() {
        Browser browser;
        this.selectedBrowser = browser = BrowserFactory.createBrowser(100, this.component, this.experimenter, true);
        browser.setSelected(true);
        this.browsers.put(100, browser);
        browser = BrowserFactory.createBrowser(103, this.component, this.experimenter, true);
        this.browsers.put(103, browser);
        browser = BrowserFactory.createBrowser(102, this.component, this.experimenter, true);
        this.browsers.put(102, browser);
        browser = BrowserFactory.createBrowser(101, this.component, this.experimenter, true);
        this.browsers.put(101, browser);
        browser = BrowserFactory.createBrowser(104, this.component, this.experimenter, true);
        this.browsers.put(104, browser);
        browser = BrowserFactory.createBrowser(105, this.component, this.experimenter, true);
        this.browsers.put(105, browser);
        browser = BrowserFactory.createBrowser(107, this.component, this.experimenter, true);
        this.browsers.put(107, browser);
    }

    private void initialize() {
        this.state = 1;
        this.browsers = new HashMap<Integer, Browser>();
        this.importLoaders = new HashMap<Integer, ImagesImporter>();
        this.importID = 0;
        this.recycled = false;
        this.refImage = null;
        this.fullScreen = true;
    }

    protected TreeViewerModel() {
        this.initialize();
    }

    protected TreeViewerModel(ExperimenterData exp, long userGroupID) {
        this.initialize();
        this.experimenter = exp;
        this.setHierarchyRoot(exp.getId(), userGroupID);
    }

    void initialize(TreeViewer component) {
        this.component = component;
        this.createBrowsers();
    }

    void setHierarchyRoot(long rootID, long userGroupID) {
        this.rootID = rootID;
        this.userGroupID = userGroupID;
    }

    boolean isSameDisplay(TreeViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.rootID == this.rootID && other.userGroupID == this.userGroupID;
    }

    boolean isRecycled() {
        return this.recycled;
    }

    void setRecycled(boolean b) {
        this.recycled = b;
    }

    long getUserGroupID() {
        return this.userGroupID;
    }

    void setSelectedBrowser(Browser browser) {
        this.selectedBrowser = browser;
    }

    Browser getSelectedBrowser() {
        return this.selectedBrowser;
    }

    Map getBrowsers() {
        return this.browsers;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 7;
    }

    void fireObjectsDeletion(List<DataObject> values) {
        this.state = 3;
        this.currentLoader = new DataObjectRemover(this.component, values);
        this.currentLoader.load();
    }

    Finder getFinder() {
        return this.finder;
    }

    void setFinder(Finder finder) {
        this.finder = finder;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setState(int state) {
        this.state = state;
    }

    void fireDataExistingObjectsLoader(DataObject ho) {
        this.state = 5;
        this.currentLoader = new ExistingObjectsLoader(this.component, ho);
        this.currentLoader.load();
    }

    void fireAddExistingObjects(Set children) {
        TreeImageDisplay parent = this.selectedBrowser.getLastSelectedDisplay();
        if (parent == null) {
            return;
        }
        Object po = parent.getUserObject();
        if (po instanceof ProjectData || po instanceof DatasetData) {
            this.currentLoader = new ExistingObjectsSaver(this.component, (DataObject)po, children);
            this.currentLoader.load();
        }
        this.state = 7;
    }

    void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        this.copyIndex = index;
        this.nodesToCopy = nodes;
    }

    TreeImageDisplay[] getNodesToCopy() {
        return this.nodesToCopy;
    }

    boolean paste(TreeImageDisplay[] parents) {
        Map map = this.buildCopyMap(parents);
        if (map == null) {
            return false;
        }
        if (this.copyIndex == 400) {
            this.currentLoader = new DataObjectUpdater(this.component, map, 0);
        } else if (this.copyIndex == 401) {
            Map toRemove = this.buildCutMap(this.nodesToCopy);
            this.currentLoader = new DataObjectUpdater(this.component, map, toRemove, 1);
        }
        this.currentLoader.load();
        this.state = 3;
        this.nodesToCopy = null;
        return true;
    }

    boolean cut() {
        if (this.copyIndex != 401) {
            return false;
        }
        if (this.nodesToCopy == null || this.nodesToCopy.length == 0) {
            return false;
        }
        Map toRemove = this.buildCutMap(this.nodesToCopy);
        this.currentLoader = new DataObjectUpdater(this.component, new HashMap(), toRemove, 2);
        this.currentLoader.load();
        this.state = 3;
        return true;
    }

    String getExperimenterNames() {
        ExperimenterData exp = this.getExperimenter();
        return exp.getFirstName() + " " + exp.getLastName();
    }

    ExperimenterData getExperimenter() {
        if (this.experimenter == null) {
            this.experimenter = this.getUserDetails();
        }
        return this.experimenter;
    }

    boolean isRollOver() {
        return this.rollOver;
    }

    void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }

    void setRndSettings(ImageData refImage) {
        this.refImage = refImage;
    }

    boolean hasRndSettingsToPaste() {
        return this.refImage != null;
    }

    void firePasteRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        long id = this.refImage.getId();
        ArrayList<Long> toKeep = new ArrayList<Long>();
        for (long id1 : ids) {
            if (id1 == id) continue;
            toKeep.add(id1);
        }
        if (toKeep.size() == 0) {
            return;
        }
        this.currentLoader = new RndSettingsSaver(this.component, klass, toKeep, this.refImage.getDefaultPixels().getId());
        this.currentLoader.load();
    }

    void firePasteRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, this.refImage.getDefaultPixels().getId());
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, 1);
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, 1);
        this.currentLoader.load();
    }

    void fireSetMinMax(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, 2);
        this.currentLoader.load();
    }

    void fireSetOwnerRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, 3);
        this.currentLoader.load();
    }

    void fireSetOriginalRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, 2);
        this.currentLoader.load();
    }

    void fireSetOwnerRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, 2);
        this.currentLoader.load();
    }

    void fireDataObjectCreation(DataObject object, boolean withParent) {
        Browser browser;
        TreeImageDisplay node;
        DataObject data = null;
        if (withParent && (node = (browser = this.getSelectedBrowser()).getLastSelectedDisplay()) != null) {
            TagAnnotationData tag;
            String ns;
            Object p = node.getUserObject();
            if (object instanceof DatasetData) {
                if (p instanceof ProjectData) {
                    data = (DataObject)p;
                }
            } else if (object instanceof PlateData) {
                if (p instanceof ScreenData) {
                    data = (DataObject)p;
                }
            } else if (object instanceof TagAnnotationData && p instanceof TagAnnotationData && (ns = (tag = (TagAnnotationData)p).getNameSpace()) != null && "openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                data = tag;
            }
        }
        this.currentLoader = new DataObjectCreator(this.component, object, data);
        this.currentLoader.load();
    }

    MetadataViewer getMetadataViewer() {
        if (this.metadataViewer == null) {
            this.metadataViewer = MetadataViewerFactory.getViewer("");
        }
        return this.metadataViewer;
    }

    AdvancedFinder getAdvancedFinder() {
        if (this.advancedFinder == null) {
            this.advancedFinder = FinderFactory.getAdvancedFinder(TreeViewerAgent.getRegistry());
        }
        return this.advancedFinder;
    }

    void browseProject(TreeImageDisplay node) {
        this.state = 5;
        ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(node);
        this.currentLoader = new ProjectsLoader(this.component, node, exp.getId(), this.getUserGroupID());
        this.currentLoader.load();
    }

    void browsePlates(List<TreeImageDisplay> nodes, boolean withThumbnails) {
        this.state = 5;
        ArrayList<TreeImageSet> plates = new ArrayList<TreeImageSet>();
        Iterator<TreeImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            plates.add((TreeImageSet)i.next());
        }
        this.currentLoader = new PlateWellsLoader(this.component, plates, withThumbnails);
        this.currentLoader.load();
    }

    void browseTimeInterval(TreeImageTimeSet node) {
        this.state = 5;
        this.currentLoader = new TimeIntervalsLoader(this.component, node);
        this.currentLoader.load();
    }

    void browseTag(TreeImageDisplay node) {
        this.state = 5;
        ExperimenterData exp = this.getSelectedBrowser().getNodeOwner(node);
        if (exp == null) {
            exp = TreeViewerAgent.getUserDetails();
        }
        this.currentLoader = new TagHierarchyLoader(this.component, node, exp.getId());
        this.currentLoader.load();
    }

    Browser getBrowser(int index) {
        return this.browsers.get(index);
    }

    String getRefImagePartialName() {
        if (this.refImage == null) {
            return null;
        }
        return EditorUtil.getPartialName(this.refImage.getName());
    }

    String getRefImageName() {
        if (this.refImage == null) {
            return null;
        }
        return UIUtilities.removeFileExtension(this.refImage.getName());
    }

    Class getDataToCopyType() {
        TreeImageDisplay[] nodes = this.getNodesToCopy();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        Object ho = nodes[0].getUserObject();
        return ho.getClass();
    }

    void setDataViewer(DataBrowser dataViewer) {
        this.dataViewer = dataViewer;
    }

    DataBrowser getDataViewer() {
        return this.dataViewer;
    }

    void importFiles(List<TreeImageDisplay> nodes, List<ImportObject> files, boolean archived) {
        ImagesImporter loader = new ImagesImporter(this.component, nodes, files, archived, this.importID);
        this.importLoaders.put(this.importID, loader);
        ++this.importID;
        loader.load();
    }

    void importFiles(TreeImageDisplay node, List<ImportObject> files, boolean archived) {
        ImagesImporter loader = new ImagesImporter(this.component, node, files, archived, this.importID);
        this.importLoaders.put(this.importID, loader);
        ++this.importID;
        loader.load();
    }

    void removeLoader(int importID) {
        this.importLoaders.remove(importID);
    }

    void cancelImport() {
        for (Map.Entry<Integer, ImagesImporter> entry : this.importLoaders.entrySet()) {
            entry.getValue().cancel();
        }
        this.importLoaders.clear();
    }

    boolean isFileImportable(File f) {
        if (f.isDirectory()) {
            return false;
        }
        if (f.isHidden()) {
            return false;
        }
        if (!f.canRead()) {
            return false;
        }
        if (!f.exists()) {
            return false;
        }
        Browser b = this.getSelectedBrowser();
        if (b != null && b.getBrowserType() == 105 && b.isFileImported(f.getAbsolutePath())) {
            return false;
        }
        String path = f.getAbsolutePath();
        if ((path = path.toLowerCase()).endsWith(".zip")) {
            return true;
        }
        List<FileFilter> filters = this.getSupportedFormats();
        for (FileFilter filter : filters) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    List<FileFilter> getSupportedFormats() {
        OmeroImageService svc = TreeViewerAgent.getRegistry().getImageService();
        return svc.getSupportedFileFilters();
    }

    boolean isMultiUser() {
        Boolean b = (Boolean)TreeViewerAgent.getRegistry().lookup("MultiUser");
        if (!b.booleanValue()) {
            return false;
        }
        ExperimenterData exp = this.getExperimenter();
        List l = exp.getGroups();
        for (GroupData group : l) {
            if (group.getId() != this.userGroupID) continue;
            PermissionData permission = group.getPermissions();
            return permission.isGroupRead() && permission.isGroupWrite();
        }
        return false;
    }

    void downloadImages(List<ImageData> images, File folder, ApplicationData application) {
        if (images == null || images.isEmpty()) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (ImageData o : images) {
            ImageData img;
            if (!(o instanceof ImageData) || !(img = o).isArchived()) continue;
            PixelsData data = img.getDefaultPixels();
            ids.add(data.getId());
        }
        OriginalFileLoader loader = new OriginalFileLoader(this.component, ids, folder, application);
        loader.load();
    }

    void refreshRenderer() {
        if (this.metadataViewer == null) {
            return;
        }
        Renderer rnd = this.metadataViewer.getRenderer();
        if (rnd != null) {
            rnd.refresh();
            this.metadataViewer.renderPlane();
        }
    }

    void resetMetadataViewer() {
        this.metadataViewer = null;
    }

    void reloadThumbnails(List<Long> ids) {
        DataBrowser db = this.getDataViewer();
        if (db != null) {
            db.reloadThumbnails(ids);
        }
    }

    String getObjectMimeType(Object object) {
        File f = null;
        if (object instanceof ImageData) {
            ImageData img = (ImageData)object;
            f = new File(img.getName());
        } else if (object instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)object;
            f = new File(fa.getFileName());
        }
        if (f == null) {
            return null;
        }
        return null;
    }

    String getObjectMimeType() {
        Browser browser = this.getSelectedBrowser();
        if (browser == null) {
            return null;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return null;
        }
        return this.getObjectMimeType(d.getUserObject());
    }

    boolean isFullScreen() {
        return true;
    }

    void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    boolean isLeader() {
        return TreeViewerAgent.getGroupsLeaderOf().size() > 0;
    }

    boolean isAdministrator() {
        return TreeViewerAgent.isAdministrator();
    }

    void setGroupId(long groupID) {
        this.userGroupID = groupID;
    }

    boolean isLeaderOfSelectedGroup() {
        Set groups = TreeViewerAgent.getGroupsLeaderOf();
        if (groups.size() == 0) {
            return false;
        }
        for (GroupData group : groups) {
            if (group.getId() != this.userGroupID) continue;
            return true;
        }
        return false;
    }

    void fireAdmin(AdminObject object) {
        this.currentLoader = new AdminCreator(this.component, object);
        this.currentLoader.load();
    }
}

