/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerComponent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.events.SaveEventRequest;
import org.openmicroscopy.shoola.env.data.events.SaveEventResponse;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.util.StringComparator;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerFactory
implements ChangeListener {
    private static final String FILE_NAME = "externalApplication.txt";
    private static final String MENU_NAME = "Data Manager";
    private static final String SEPARATOR = "=";
    private static final TreeViewerFactory singleton = new TreeViewerFactory();
    private Set<TreeViewer> viewers = new HashSet<TreeViewer>();
    private JMenu windowMenu = new JMenu("Data Manager");
    private boolean isAttached = false;
    private Map<String, List<ApplicationData>> applications = null;
    private StringComparator comparator = new StringComparator();

    static void register(ApplicationData data, String mimeType) {
        if (mimeType == null) {
            return;
        }
        List<ApplicationData> list = TreeViewerFactory.singleton.applications.get(mimeType);
        if (list == null) {
            list = new ArrayList<ApplicationData>();
            list.add(data);
            TreeViewerFactory.singleton.applications.put(mimeType, list);
        } else {
            String path = data.getApplicationPath();
            Iterator<ApplicationData> i = list.iterator();
            boolean registered = false;
            while (i.hasNext()) {
                ApplicationData app = i.next();
                if (!app.getApplicationPath().equals(path)) continue;
                registered = true;
                break;
            }
            if (!registered) {
                list.add(data);
                Collections.sort(list, TreeViewerFactory.singleton.comparator);
            }
        }
    }

    static List<ApplicationData> getApplications(String type) {
        return TreeViewerFactory.singleton.applications.get(type);
    }

    static JMenu getWindowMenu() {
        return TreeViewerFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return TreeViewerFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (TreeViewerFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, TreeViewerFactory.getWindowMenu());
        TreeViewerFactory.singleton.isAttached = true;
    }

    static Set getViewers() {
        return TreeViewerFactory.singleton.viewers;
    }

    static boolean isLastViewer() {
        return TreeViewerFactory.singleton.viewers.size() <= 1;
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, null);
    }

    public static void copyRndSettings(ImageData image) {
        for (TreeViewerComponent treeViewerComponent : TreeViewerFactory.singleton.viewers) {
            treeViewerComponent.setRndSettings(image);
        }
    }

    public static void onRndSettingsCopied(Collection imageIds) {
        for (TreeViewerComponent treeViewerComponent : TreeViewerFactory.singleton.viewers) {
            treeViewerComponent.onRndSettingsCopied(imageIds);
        }
    }

    public static void saveOnClose(SaveEventRequest evt, Object agent) {
        Iterator<TreeViewer> v = TreeViewerFactory.singleton.viewers.iterator();
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        while (v.hasNext()) {
            TreeViewerComponent comp = (TreeViewerComponent)v.next();
            comp.saveOnClose((SaveData)evt.getAnswer());
            bus.post(new SaveEventResponse(evt, (Agent)agent));
        }
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        for (TreeViewerComponent treeViewerComponent : TreeViewerFactory.singleton.viewers) {
            treeViewerComponent.onGroupSwitched(success);
        }
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID, Rectangle bounds) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, bounds);
    }

    public static void writeExternalApplications() {
        if (TreeViewerFactory.singleton.applications == null || TreeViewerFactory.singleton.applications.size() == 0) {
            return;
        }
        try {
            Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
            String name = env.getOmeroHome() + File.separator + FILE_NAME;
            File f = new File(name);
            if (f.exists()) {
                f.delete();
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(name));
            for (Map.Entry<String, List<ApplicationData>> entry : TreeViewerFactory.singleton.applications.entrySet()) {
                String format = entry.getKey();
                List<ApplicationData> list = entry.getValue();
                if (list == null) continue;
                for (ApplicationData data : list) {
                    output.write(format + SEPARATOR + data.getApplicationPath());
                    output.newLine();
                }
            }
            if (output != null) {
                output.close();
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("An error occurred while writing the external applications back to the file.");
            msg.print(e);
            TreeViewerAgent.getRegistry().getLogger().error(TreeViewerFactory.class, msg);
        }
    }

    private TreeViewerFactory() {
    }

    private TreeViewer getTreeViewer(TreeViewerModel model, Rectangle bounds) {
        for (TreeViewerComponent treeViewerComponent : this.viewers) {
            if (!model.isSameDisplay(treeViewerComponent.getModel())) continue;
            treeViewerComponent.setRecycled(true);
            return treeViewerComponent;
        }
        this.readExternalApplications();
        TreeViewerComponent treeViewerComponent = new TreeViewerComponent(model);
        model.initialize(treeViewerComponent);
        treeViewerComponent.initialize(bounds);
        treeViewerComponent.addChangeListener(this);
        this.viewers.add(treeViewerComponent);
        return treeViewerComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalApplications() {
        if (this.applications != null) {
            return;
        }
        this.applications = new HashMap<String, List<ApplicationData>>();
        Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
        String name = env.getOmeroHome() + File.separator + FILE_NAME;
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(f));
            try {
                List<ApplicationData> list;
                String line = null;
                while ((line = input.readLine()) != null) {
                    String[] values;
                    if (!line.contains(SEPARATOR) || (values = line.split(SEPARATOR)).length < 2) continue;
                    String mimeType = values[0];
                    String v = "";
                    int index = 1;
                    for (int i = 1; i < values.length; ++i) {
                        v = v + values[i];
                        if (index != values.length - 1) {
                            v = v + SEPARATOR;
                        }
                        ++index;
                    }
                    list = this.applications.get(mimeType);
                    if (list == null) {
                        list = new ArrayList<ApplicationData>();
                        this.applications.put(mimeType, list);
                    }
                    list.add(new ApplicationData(v));
                }
                Iterator<String> k = this.applications.keySet().iterator();
                while (k.hasNext()) {
                    list = this.applications.get(k.next());
                    Collections.sort(list, TreeViewerFactory.singleton.comparator);
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("An error occurred while reading the external applications file.");
            msg.print(e);
            TreeViewerAgent.getRegistry().getLogger().error(TreeViewerFactory.class, msg);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        TreeViewerComponent comp = (TreeViewerComponent)ce.getSource();
        if (comp.getState() == 2) {
            this.viewers.remove(comp);
        }
    }
}

