/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.util.ui.TitlePanel;

public class OpenWithDialog
extends JDialog
implements ActionListener {
    public static final String OPEN_DOCUMENT_PROPERTY = "openDocument";
    private final String TITLE = "Choose Application";
    private final String TEXT = "Choose an application to open the document ";
    private JFileChooser chooser;

    private void open() {
        ApplicationData data = new ApplicationData(this.chooser.getSelectedFile());
        this.firePropertyChange(OPEN_DOCUMENT_PROPERTY, null, data);
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents(String directory) {
        this.setDefaultCloseOperation(0);
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(0);
        if (directory != null && directory.length() > 0) {
            this.chooser.setCurrentDirectory(new File(directory));
        }
        this.chooser.setApproveButtonText("Open");
        this.chooser.setApproveButtonToolTipText("Open the document with the selected application");
        this.chooser.addActionListener(this);
    }

    private void buildGUI(String name) {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel("Choose Application", "Choose an application to open the document " + name, icons.getIcon(111));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.chooser, "Center");
    }

    public OpenWithDialog(JFrame parent, String directory, String name) {
        super(parent);
        this.initComponents(directory);
        this.buildGUI(name);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        if ("ApproveSelection".equals(name)) {
            this.open();
        } else if ("CancelSelection".equals(name)) {
            this.close();
        }
    }
}

