/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.SortVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class SortCmd
implements ActionCmd {
    private Browser model;
    private int sortType;
    private List sortedNodes;
    private TreeImageDisplay node;

    private void checkSortType(int type) {
        switch (type) {
            case 300: 
            case 301: {
                return;
            }
        }
        throw new IllegalArgumentException("Sort type not supported");
    }

    private List sort(List nodes, final boolean ascending) {
        Comparator c;
        switch (this.sortType) {
            case 300: {
                c = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Timestamp t2;
                        Timestamp t1;
                        ImageData i1 = (ImageData)((TreeImageDisplay)o1).getUserObject();
                        ImageData i2 = (ImageData)((TreeImageDisplay)o2).getUserObject();
                        try {
                            t1 = i1.getInserted();
                        }
                        catch (Exception e) {
                            t1 = null;
                        }
                        try {
                            t2 = i2.getInserted();
                        }
                        catch (Exception e) {
                            t2 = null;
                        }
                        if (t1 == null) {
                            t1 = UIUtilities.getDefaultTimestamp();
                        }
                        if (t2 == null) {
                            t2 = UIUtilities.getDefaultTimestamp();
                        }
                        int r = t1.compareTo(t2);
                        int v = 0;
                        if (r < 0) {
                            v = -1;
                        } else if (r > 0) {
                            v = 1;
                        }
                        if (ascending) {
                            return v;
                        }
                        return -v;
                    }
                };
                break;
            }
            default: {
                c = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String s1 = o1.toString().toLowerCase();
                        String s2 = o2.toString().toLowerCase();
                        int result = s1.compareTo(s2);
                        int v = 0;
                        if (result < 0) {
                            v = -1;
                        } else if (result > 0) {
                            v = 1;
                        }
                        if (ascending) {
                            return v;
                        }
                        return -v;
                    }
                };
            }
        }
        Collections.sort(nodes, c);
        return nodes;
    }

    public SortCmd(Browser model, int sortType, TreeImageDisplay node) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.checkSortType(sortType);
        this.sortType = sortType;
        this.node = node;
    }

    public List getSortedNodes() {
        return this.sortedNodes;
    }

    public void execute() {
        SortVisitor visitor = new SortVisitor(this.model);
        if (this.node == null) {
            this.model.accept(visitor, 0);
        } else {
            this.node.accept(visitor, 0);
        }
        this.sortedNodes = this.sort(visitor.getNodes(), true);
    }
}

