/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class TaggingAction
extends TreeViewerAction {
    private static final String NAME = "Tag...";
    private static final String DESCRIPTION = "Add or remove tags.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof ImageData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else {
            this.setEnabled(false);
        }
    }

    public TaggingAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(69));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.showTagWizard();
    }
}

