/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.util.PasswordDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

public class PasswordResetAction
extends TreeViewerAction {
    private static final String NAME = "Reset Password...";
    private static final String DESCRIPTION = "Resets the password of the selected experimenters.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (browser.getBrowserType() != 107) {
                    this.setEnabled(false);
                    break;
                }
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.isAdministrator()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (browser.getBrowserType() != 107) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(ho instanceof ExperimenterData);
    }

    public PasswordResetAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(122));
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
    }

    public void actionPerformed(ActionEvent e) {
        PasswordDialog d = new PasswordDialog(this.model.getUI());
        d.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("resetPassword".equals(evt.getPropertyName())) {
                    String value = (String)evt.getNewValue();
                    PasswordResetAction.this.model.resetPassword(value);
                }
            }
        });
        UIUtilities.centerAndShow(d);
    }
}

