/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class NewObjectAction
extends TreeViewerAction
implements MouseListener {
    public static final int NEW_TAGS = 0;
    public static final int NEW_CONTAINERS = 1;
    public static final int NEW_ADMIN = 2;
    public static final String NAME = "New";
    private static final String DESCRIPTION = "Create new Project, Dataset, etc.";
    private static final String DESCRIPTION_TAGS = "Create new Tag Set or Tag";
    private static final String DESCRIPTION_ADMIN = "Create new Group or Experimenter.";
    private Point point;
    private int index;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(true);
            }
        }
    }

    public NewObjectAction(TreeViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        IconManager im = IconManager.getInstance();
        switch (index) {
            case 0: {
                this.putValue("SmallIcon", im.getIcon(69));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAGS));
                break;
            }
            case 1: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
                break;
            }
            case 2: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ADMIN));
            }
        }
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            switch (this.index) {
                case 0: {
                    this.model.showMenu(4, (Component)source, this.point);
                    break;
                }
                case 1: {
                    this.model.showMenu(3, (Component)source, this.point);
                    break;
                }
                case 2: {
                    this.model.showMenu(6, (Component)source, this.point);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

