/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class BrowseContainerAction
extends TreeViewerAction {
    private static final String NAME_NO_TUMBNAILS = "Browse w/o thumbnails";
    private static final String NAME = "Browse";
    private static final String DESCRIPTION_DEFAULT = "Browse.";
    private static final String DESCRIPTION_PROJECT = "Browse the selected Project.";
    private static final String DESCRIPTION_TAG = "Browse the selected Tag.";
    private static final String DESCRIPTION_TIME = "Browse the selected period.";
    private static final String DESCRIPTION_PLATE = "Browse the selected Plate.";
    private static final String DESCRIPTION_DATASET = "Browse the selected Dataset.";
    private static final String DESCRIPTION_FOLDER = "Browse the selected Folder.";
    private static final String DESCRIPTION_MULTIIMAGE = "Browse the selected Image.";
    private static IconManager icons = IconManager.getInstance();
    private boolean withThumnails;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || this.model.getSelectedBrowser() == null) {
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.name = NAME;
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (selectedDisplay instanceof TreeImageTimeSet) {
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TIME));
            if (!this.withThumnails) {
                this.name = NAME_NO_TUMBNAILS;
                this.setEnabled(false);
                return;
            }
            this.name = NAME;
            TreeImageDisplay[] array = browser.getSelectedDisplays();
            if (array != null && array.length > 1) {
                this.setEnabled(false);
            } else {
                TreeImageTimeSet timeNode = (TreeImageTimeSet)selectedDisplay;
                long number = timeNode.getNumberItems();
                this.setEnabled(number > 0L);
            }
            return;
        }
        if (ho == null || ho instanceof ExperimenterData || ho instanceof ImageData || ho instanceof FileAnnotationData) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            this.setEnabled(false);
        } else if (ho instanceof File) {
            File f = (File)ho;
            if (f.isDirectory() && !f.isHidden()) {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_FOLDER));
                this.setEnabled(true);
            }
        } else if (ho instanceof PlateAcquisitionData) {
            this.setEnabled(true);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PLATE));
        } else if (!(ho instanceof DataObject)) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            this.setEnabled(false);
        } else {
            if (browser != null && browser.getSelectedDisplays().length > 1) {
                this.setEnabled(true);
                this.name = this.withThumnails ? NAME : NAME_NO_TUMBNAILS;
                this.putValue("SmallIcon", icons.getIcon(60));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
                return;
            }
            this.name = this.withThumnails ? NAME : NAME_NO_TUMBNAILS;
            this.putValue("SmallIcon", icons.getIcon(60));
            String description = DESCRIPTION_DEFAULT;
            if (selectedDisplay instanceof TreeImageSet) {
                long n = ((TreeImageSet)selectedDisplay).getNumberItems();
                if (ho instanceof ScreenData) {
                    this.setEnabled(false);
                } else if (ho instanceof PlateData) {
                    List l = selectedDisplay.getChildrenDisplay();
                    description = DESCRIPTION_PLATE;
                    this.setEnabled(l == null || l.size() == 0);
                } else if (ho instanceof PlateAcquisitionData) {
                    description = DESCRIPTION_PLATE;
                    this.setEnabled(true);
                } else if (ho instanceof ProjectData) {
                    description = DESCRIPTION_PROJECT;
                    this.setEnabled(n > 0L);
                    if (!this.withThumnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof DatasetData) {
                    description = DESCRIPTION_DATASET;
                    this.setEnabled(n > 0L);
                    if (!this.withThumnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof TagAnnotationData) {
                    String ns = ((TagAnnotationData)ho).getNameSpace();
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                        this.setEnabled(false);
                    } else {
                        description = DESCRIPTION_TAG;
                        this.setEnabled(n > 0L);
                    }
                    if (!this.withThumnails) {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof MultiImageData) {
                    MultiImageData mi = (MultiImageData)ho;
                    if (!mi.isHidden()) {
                        this.setEnabled(mi.getComponents().size() > 0);
                        description = DESCRIPTION_MULTIIMAGE;
                    } else {
                        this.setEnabled(false);
                    }
                } else if (ho instanceof FileData) {
                    FileData f = (FileData)ho;
                    if (f.isDirectory() && !f.isHidden()) {
                        this.setEnabled(true);
                        description = DESCRIPTION_FOLDER;
                    } else {
                        this.setEnabled(false);
                    }
                }
            }
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(description));
        }
    }

    public BrowseContainerAction(TreeViewer model) {
        this(model, true);
    }

    public BrowseContainerAction(TreeViewer model, boolean withThumbnails) {
        super(model);
        this.withThumnails = withThumbnails;
        this.name = withThumbnails ? NAME : NAME_NO_TUMBNAILS;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
        this.putValue("SmallIcon", icons.getIcon(60));
    }

    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model, this.withThumnails);
        cmd.execute();
    }
}

