/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.metadata.AdminEditor;
import org.openmicroscopy.shoola.agents.metadata.ContainersLoader;
import org.openmicroscopy.shoola.agents.metadata.DataBatchSaver;
import org.openmicroscopy.shoola.agents.metadata.DataSaver;
import org.openmicroscopy.shoola.agents.metadata.ExperimenterEditor;
import org.openmicroscopy.shoola.agents.metadata.GroupEditor;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.RenderingSettingsLoader;
import org.openmicroscopy.shoola.agents.metadata.StructuredDataLoader;
import org.openmicroscopy.shoola.agents.metadata.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorFactory;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataViewerModel {
    private int state = 1;
    private MetadataViewer component;
    private Object refObject;
    private Object parentRefObject;
    private StructuredDataResults data;
    private Browser browser;
    private Editor editor;
    private Map<TreeBrowserDisplay, MetadataLoader> loaders;
    private Class dataType;
    private boolean singleMode;
    private List relatedNodes;
    private int index;
    private long userID;
    private Map viewedBy;

    private List<FileAnnotationData> getTabularData() {
        StructuredDataResults data = this.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection attachements = data.getAttachments();
        if (attachements == null) {
            return l;
        }
        for (FileAnnotationData f : attachements) {
            String ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/bulk_annotations".equals(ns)) continue;
            l.add(f);
        }
        return l;
    }

    MetadataViewerModel(Object refObject, int index) {
        switch (index) {
            case 0: 
            case 1: {
                this.index = index;
                break;
            }
            default: {
                this.index = 0;
            }
        }
        this.refObject = refObject;
        this.loaders = new HashMap<TreeBrowserDisplay, MetadataLoader>();
        this.data = null;
        this.dataType = null;
        this.singleMode = true;
        this.userID = MetadataViewerAgent.getUserDetails().getId();
    }

    void initialize(MetadataViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, this.refObject);
        this.editor = EditorFactory.createEditor(component, this.refObject, this.browser);
    }

    long getUserID() {
        return this.userID;
    }

    void setDataType(Class dataType) {
        this.dataType = dataType;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.state = 4;
        Iterator<TreeBrowserDisplay> i = this.loaders.keySet().iterator();
        while (i.hasNext()) {
            MetadataLoader loader = this.loaders.get(i.next());
            if (loader == null) continue;
            loader.cancel();
        }
        this.loaders.clear();
    }

    void setRootObject(Object refObject) {
        this.refObject = refObject;
        this.browser.setRootObject(refObject);
        this.editor.setRootObject(refObject);
        this.data = null;
        this.parentRefObject = null;
        this.viewedBy = null;
    }

    void setParentRootObject(Object parentRefObject, Object grandParent) {
        this.parentRefObject = parentRefObject;
        this.editor.setParentRootObject(parentRefObject, grandParent);
    }

    Object getParentRefObject() {
        return this.parentRefObject;
    }

    Object getRefObject() {
        if (this.data == null) {
            return this.refObject;
        }
        Object o = this.data.getRelatedObject();
        return this.refObject;
    }

    Browser getBrowser() {
        return this.browser;
    }

    Editor getEditor() {
        return this.editor;
    }

    void cancel(TreeBrowserDisplay refNode) {
        MetadataLoader loader = this.loaders.get(refNode);
        if (loader != null) {
            loader.cancel();
            this.loaders.remove(refNode);
        }
    }

    void notifyLoadingEnd(TreeBrowserDisplay refNode) {
        MetadataLoader loader = this.loaders.get(refNode);
        if (loader != null) {
            this.loaders.remove(refNode);
        }
    }

    void fireParentLoading(TreeBrowserSet refNode) {
        this.cancel(refNode);
        Object ho = refNode.getUserObject();
        if (ho instanceof DataObject) {
            ContainersLoader loader = new ContainersLoader(this.component, refNode, ho.getClass(), ((DataObject)ho).getId());
            this.loaders.put(refNode, loader);
            loader.load();
        }
    }

    void fireStructuredDataLoading(TreeBrowserDisplay refNode) {
        Object uo = refNode.getUserObject();
        if (uo instanceof ExperimenterData) {
            return;
        }
        if (uo instanceof DataObject) {
            this.cancel(refNode);
            if (uo instanceof WellSampleData) {
                WellSampleData wsd = (WellSampleData)uo;
                uo = wsd.getImage();
            }
            StructuredDataLoader loader = new StructuredDataLoader(this.component, refNode, uo);
            this.loaders.put(refNode, loader);
            loader.load();
            this.state = 2;
        }
    }

    boolean isSameObject(DataObject uo) {
        if (uo == null || !(this.refObject instanceof DataObject)) {
            return false;
        }
        Class<?> klass = this.refObject.getClass();
        if (this.refObject instanceof WellSampleData) {
            klass = ((WellSampleData)this.refObject).getImage().getClass();
        }
        if (!uo.getClass().equals(klass)) {
            return false;
        }
        Object object = this.refObject instanceof WellSampleData ? ((WellSampleData)this.refObject).getImage() : (DataObject)this.refObject;
        if (uo.getId() != object.getId()) {
            return false;
        }
        if (this.data == null) {
            return false;
        }
        Object o = this.data.getRelatedObject();
        if (!(o instanceof DataObject)) {
            return false;
        }
        object = (DataObject)o;
        if (!uo.getClass().equals(object.getClass())) {
            return false;
        }
        return uo.getId() == object.getId();
    }

    String getRefObjectPath() {
        return this.getRefObjectName();
    }

    String getRefObjectName() {
        Object ref = this.getRefObject();
        if (ref instanceof ImageData) {
            return ((ImageData)ref).getName();
        }
        if (ref instanceof DatasetData) {
            return ((DatasetData)ref).getName();
        }
        if (ref instanceof ProjectData) {
            return ((ProjectData)ref).getName();
        }
        if (ref instanceof PlateData) {
            return ((PlateData)ref).getName();
        }
        if (ref instanceof ScreenData) {
            return ((ScreenData)ref).getName();
        }
        return "";
    }

    void fireSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata, Collection<DataObject> data, boolean asynch) {
        if (asynch) {
            DataSaver loader = new DataSaver(this.component, data, toAdd, toRemove, metadata);
            loader.load();
            this.state = 6;
        } else {
            OmeroMetadataService os = MetadataViewerAgent.getRegistry().getMetadataService();
            try {
                if (metadata != null) {
                    Iterator<Object> i = metadata.iterator();
                    while (i.hasNext()) {
                        os.saveAcquisitionData(i.next());
                    }
                }
                os.saveData(data, toAdd, toRemove, this.userID);
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.print("Unable to save annotation and/or edited data");
                msg.print(e);
                MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        }
    }

    void fireExperimenterSaving(ExperimenterData data, boolean async) {
        if (async) {
            ExperimenterEditor loader = new ExperimenterEditor(this.component, data);
            loader.load();
            this.state = 6;
        } else {
            AdminService svc = MetadataViewerAgent.getRegistry().getAdminService();
            try {
                svc.updateExperimenter(data, null);
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.print("Unable to update the experimenter");
                msg.print(e);
                MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        }
    }

    void fireAdminSaving(AdminObject data, boolean asynch) {
        if (asynch) {
            MetadataLoader loader = null;
            switch (data.getIndex()) {
                case 2: {
                    GroupData group = data.getGroup();
                    loader = new GroupEditor(this.component, group, data.getPermissions());
                    break;
                }
                case 3: {
                    loader = new AdminEditor(this.component, data.getGroup(), data.getExperimenters());
                }
            }
            if (loader != null) {
                loader.load();
                this.state = 6;
            }
        } else {
            AdminService svc = MetadataViewerAgent.getRegistry().getAdminService();
            LogMessage msg = new LogMessage();
            switch (data.getIndex()) {
                case 2: {
                    try {
                        GroupData group = data.getGroup();
                        GroupData g = svc.lookupGroup(group.getName());
                        if (g == null || group.getId() == g.getId()) {
                            svc.updateGroup(data.getGroup(), data.getPermissions());
                            break;
                        }
                        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                        un.notifyInfo("Update Group", "A group with the same name already exists.");
                    }
                    catch (Exception e) {
                        msg.print("Unable to update the group");
                        msg.print(e);
                        MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                    break;
                }
                case 3: {
                    try {
                        svc.updateExperimenters(data.getGroup(), data.getExperimenters());
                        break;
                    }
                    catch (Exception e) {
                        msg.print("Unable to update experimenters");
                        msg.print(e);
                        MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                }
            }
        }
    }

    void setStructuredDataResults(StructuredDataResults data) {
        this.data = data;
        this.state = 3;
    }

    StructuredDataResults getStructuredData() {
        return this.data;
    }

    boolean isArchived() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.isArchived();
    }

    void fireBatchSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, Collection<DataObject> toSave) {
        DataBatchSaver loader = new DataBatchSaver(this.component, toSave, toAdd, toRemove);
        loader.load();
        this.state = 5;
    }

    void setSelectionMode(boolean singleMode) {
        this.singleMode = singleMode;
    }

    boolean isSingleMode() {
        return this.singleMode;
    }

    void setRelatedNodes(List relateNodes) {
        this.relatedNodes = relateNodes;
    }

    List getRelatedNodes() {
        return this.relatedNodes;
    }

    void setState(int state) {
        this.state = state;
    }

    void loadParents(Class type, long id) {
        ContainersLoader loader = new ContainersLoader(this.component, type, id);
        loader.load();
    }

    void createMovie(MovieExportParam parameters) {
        if (parameters == null) {
            return;
        }
        if (!(this.refObject instanceof ImageData)) {
            return;
        }
    }

    int getIndex() {
        return this.index;
    }

    FileAnnotationData getIRF() {
        if (!(this.refObject instanceof ImageData)) {
            return null;
        }
        if (this.data == null) {
            return null;
        }
        Collection l = this.data.getAttachments();
        if (l == null || l.size() == 0) {
            return null;
        }
        for (FileAnnotationData fa : l) {
            if (!fa.getFileName().contains("irf")) continue;
            return fa;
        }
        return null;
    }

    boolean isNumerousChannel() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.getDefaultPixels().getSizeC() >= 10;
    }

    void setUserID(long userID) {
        this.userID = userID;
    }

    Map getViewedBy() {
        return this.viewedBy;
    }

    void setViewedBy(Map viewedBy) {
        HashMap m = new HashMap();
        if (viewedBy != null) {
            long id = MetadataViewerAgent.getUserDetails().getId();
            for (Map.Entry entry : viewedBy.entrySet()) {
                ExperimenterData exp = (ExperimenterData)entry.getKey();
                if (exp.getId() == id) continue;
                m.put(exp, entry.getValue());
            }
        }
        this.viewedBy = m;
        this.getEditor().getRenderer().loadRndSettings(true, null);
    }

    void fireViewedByLoading() {
        ImageData img = null;
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        } else if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (img == null) {
            return;
        }
        this.getEditor().getRenderer().loadRndSettings(false, null);
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, img.getDefaultPixels().getId());
        loader.load();
    }

    void fireThumbnailsLoading() {
        ImageData image = null;
        if (this.refObject instanceof ImageData) {
            image = (ImageData)this.refObject;
        } else if (this.refObject instanceof WellSampleData) {
            image = ((WellSampleData)this.refObject).getImage();
        }
        Set experimenters = this.viewedBy.keySet();
        HashSet<Long> ids = new HashSet<Long>();
        Iterator i = experimenters.iterator();
        while (i.hasNext()) {
            ids.add(((ExperimenterData)i.next()).getId());
        }
        if (ids.size() == 0) {
            return;
        }
        ThumbnailLoader loader = new ThumbnailLoader(this.component, image, ids);
        loader.load();
    }

    void applyRenderingSettings(RndProxyDef rndDef) {
        Renderer rnd = this.getEditor().getRenderer();
        if (rnd != null) {
            rnd.resetSettings(rndDef, true);
        }
    }

    boolean isWritable() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isWritable();
    }
}

