/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsSaved;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.ChannelSelectionDialog;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerUI;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.MovieExportDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.AnnotationData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataViewerComponent
extends AbstractComponent
implements MetadataViewer {
    private MetadataViewerModel model;
    private MetadataViewerControl controller;
    private MetadataViewerUI view;

    private void deleteAnnotations(List<AnnotationData> toDelete) {
        if (toDelete == null || toDelete.size() == 0) {
            return;
        }
        ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
        Iterator<AnnotationData> j = toDelete.iterator();
        while (j.hasNext()) {
            l.add(new DeletableObject((DataObject)j.next()));
        }
        IconManager icons = IconManager.getInstance();
        DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(115), l);
        p.setFailureIcon(icons.getIcon(114));
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(p);
    }

    private void createMovie(MovieExportParam parameters) {
        if (parameters == null) {
            return;
        }
        if (parameters == null) {
            return;
        }
        Object refObject = this.model.getRefObject();
        ImageData img = null;
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
        }
        if (img == null) {
            return;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        MovieActivityParam activity = new MovieActivityParam(parameters, null, img);
        IconManager icons = IconManager.getInstance();
        activity.setIcon(icons.getIcon(75));
        un.notifyActivity(activity);
    }

    MetadataViewerComponent(MetadataViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MetadataViewerControl();
        this.view = new MetadataViewerUI();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        if (!(this.model.getRefObject() instanceof String)) {
            this.setSelectionMode(true);
        }
    }

    void saveBeforeClose() {
        this.firePropertyChange("saveData", true, false);
    }

    @Override
    public void activate(Map channelData) {
        switch (this.model.getState()) {
            case 1: {
                this.model.getEditor().setChannelsData(channelData, false);
                this.setRootObject(this.model.getRefObject(), this.model.getUserID());
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public void discard() {
        this.model.discard();
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void cancel(TreeBrowserDisplay refNode) {
        this.model.cancel(refNode);
    }

    @Override
    public void loadMetadata(TreeBrowserDisplay node) {
        File f;
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof DataObject) {
            if (this.model.isSingleMode()) {
                this.model.fireStructuredDataLoading(node);
                this.fireStateChange();
            }
        } else if (userObject instanceof File && (f = (File)userObject).isDirectory() && this.model.isSingleMode()) {
            this.model.fireStructuredDataLoading(node);
            this.fireStateChange();
        }
    }

    @Override
    public void setMetadata(TreeBrowserDisplay node, Object result) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        Object userObject = node.getUserObject();
        Object refObject = this.model.getRefObject();
        if (refObject == userObject) {
            Browser browser = this.model.getBrowser();
            if (result instanceof StructuredDataResults) {
                this.model.setStructuredDataResults((StructuredDataResults)result);
                browser.setParents(node, this.model.getStructuredData().getParents());
                this.model.getEditor().setStructuredDataResults();
                this.view.setOnScreen();
                this.fireStateChange();
                return;
            }
            if (!(userObject instanceof String)) {
                return;
            }
            String name = (String)userObject;
            if (browser == null) {
                return;
            }
            if ("Datasets".equals(name) || "Projects".equals(name)) {
                browser.setParents((TreeBrowserSet)node, (Collection)result);
            }
            this.model.notifyLoadingEnd(node);
        }
    }

    @Override
    public JComponent getSelectionUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUI();
    }

    @Override
    public JComponent getEditorUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getEditor().getUI();
    }

    @Override
    public JComponent getUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getUI();
    }

    @Override
    public void setRootObject(Object root, long userID) {
        Renderer rnd;
        WellSampleData ws;
        if (root instanceof WellSampleData && (ws = (WellSampleData)root).getId() < 0L) {
            root = null;
        }
        if (root == null) {
            root = "";
            userID = -1L;
        }
        if ((rnd = this.model.getEditor().getRenderer()) != null && this.getRndIndex() == 0) {
            long imageID = -1L;
            long pixelsID = -1L;
            Object obj = this.model.getRefObject();
            if (obj instanceof WellSampleData) {
                WellSampleData wsd = (WellSampleData)obj;
                obj = wsd.getImage();
            }
            if (obj instanceof ImageData) {
                ImageData data = (ImageData)obj;
                imageID = data.getId();
                pixelsID = data.getDefaultPixels().getId();
            }
            if (this.model.isWritable()) {
                Registry reg = MetadataViewerAgent.getRegistry();
                RndProxyDef def = null;
                try {
                    def = rnd.saveCurrentSettings();
                }
                catch (Exception e) {
                    try {
                        reg.getImageService().resetRenderingService(pixelsID);
                        def = rnd.saveCurrentSettings();
                    }
                    catch (Exception ex) {
                        String s = "Data Retrieval Failure: ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print(e);
                        reg.getLogger().error((Object)this, msg);
                    }
                }
                EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
                bus.post(new RndSettingsSaved(pixelsID, def));
            }
            if (imageID >= 0L && this.model.isWritable()) {
                this.firePropertyChange("renderThumbnail", -1, imageID);
            }
        }
        this.model.setRootObject(root);
        this.view.setRootObject();
        this.model.setUserID(userID);
        this.setParentRootObject(null, null);
    }

    @Override
    public void setParentRootObject(Object parent, Object grandParent) {
        this.model.setParentRootObject(parent, grandParent);
    }

    @Override
    public void loadContainers(TreeBrowserDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        this.model.fireParentLoading((TreeBrowserSet)node);
    }

    @Override
    public void setContainers(TreeBrowserDisplay node, Object result) {
        Browser browser = this.model.getBrowser();
        if (node == null) {
            StructuredDataResults data = this.model.getStructuredData();
            if (data != null) {
                data.setParents((Collection)result);
                browser.setParents(null, (Collection)result);
            }
        } else {
            browser.setParents((TreeBrowserSet)node, (Collection)result);
        }
        this.model.getEditor().setStatus(false);
    }

    @Override
    public List getRelatedNodes() {
        return this.model.getRelatedNodes();
    }

    @Override
    public void saveData(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<AnnotationData> toDelete, List<Object> metadata, DataObject data, boolean asynch) {
        if (data == null) {
            return;
        }
        Object refObject = this.model.getRefObject();
        ArrayList<DataObject> toSave = new ArrayList<DataObject>();
        if (refObject instanceof FileData) {
            FileData fa = (FileData)data;
            if (fa.getId() <= 0L) {
                DataObjectRegistration r = new DataObjectRegistration(toAdd, toRemove, toDelete, metadata, data);
                this.firePropertyChange("register", null, r);
                return;
            }
            toSave.add(data);
            this.model.fireSaving(toAdd, toRemove, metadata, toSave, asynch);
            this.fireStateChange();
            this.deleteAnnotations(toDelete);
            return;
        }
        List nodes = this.model.getRelatedNodes();
        toSave.add(data);
        if (!this.model.isSingleMode() && nodes != null) {
            Iterator n = nodes.iterator();
            while (n.hasNext()) {
                toSave.add((DataObject)n.next());
            }
        }
        boolean b = true;
        if (refObject instanceof ProjectData || refObject instanceof ScreenData || refObject instanceof PlateData || refObject instanceof DatasetData || refObject instanceof WellSampleData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave, asynch);
        } else if (refObject instanceof ImageData) {
            ImageData img = (ImageData)refObject;
            if (img.getId() < 0L) {
                DataObjectRegistration r = new DataObjectRegistration(toAdd, toRemove, toDelete, metadata, data);
                this.firePropertyChange("register", null, r);
                return;
            }
            this.model.fireSaving(toAdd, toRemove, metadata, toSave, asynch);
        } else if (refObject instanceof TagAnnotationData && toAdd.size() == 0 && toRemove.size() == 0) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave, asynch);
            b = false;
        }
        if (toDelete != null && toDelete.size() > 0) {
            this.deleteAnnotations(toDelete);
        }
        if (b) {
            this.fireStateChange();
        }
    }

    @Override
    public boolean hasDataToSave() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return false;
        }
        return editor.hasDataToSave();
    }

    @Override
    public void saveData() {
        this.firePropertyChange("saveData", false, true);
    }

    @Override
    public void clearDataToSave() {
        this.firePropertyChange("clearSaveData", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void onDataSave(List<DataObject> data) {
        if (data == null) {
            return;
        }
        if (this.model.getState() == 4) {
            return;
        }
        DataObject dataObject = null;
        if (data.size() == 1) {
            dataObject = data.get(0);
        }
        if (dataObject != null && this.model.isSameObject(dataObject)) {
            this.setRootObject(this.model.getRefObject(), this.model.getUserID());
            this.firePropertyChange("onDataSave", null, dataObject);
        } else {
            this.firePropertyChange("onDataSave", null, data);
        }
        this.model.setState(3);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.fireStateChange();
    }

    @Override
    public void setSelectionMode(boolean single) {
        this.model.setSelectionMode(single);
        this.model.getEditor().setSelectionMode(single);
    }

    @Override
    public boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    @Override
    public void setRelatedNodes(List nodes) {
        this.setRootObject(this.model.getRefObject(), this.model.getUserID());
        this.model.setRelatedNodes(nodes);
    }

    @Override
    public void onAdminUpdated(Object data) {
        Object o = data;
        if (data instanceof Map) {
            o = this.model.getRefObject();
            Map l = (Map)data;
            if (l.size() > 0) {
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                StringBuffer buf = new StringBuffer();
                buf.append("Unable to update the following experimenters:\n");
                for (Map.Entry entry : l.entrySet()) {
                    Object node = entry.getKey();
                    if (!(node instanceof ExperimenterData)) continue;
                    ExperimenterData exp = (ExperimenterData)node;
                    Exception ex = (Exception)entry.getValue();
                    buf.append(exp.getFirstName() + " " + exp.getLastName());
                    buf.append("\n->" + ex.getMessage());
                    buf.append("\n");
                }
                un.notifyInfo("Update experimenters", buf.toString());
            }
            this.firePropertyChange("clearSaveData", null, data);
            this.setRootObject(null, -1L);
        } else {
            this.setRootObject(o, this.model.getUserID());
        }
        this.firePropertyChange("adminUpdated", null, data);
    }

    @Override
    public void loadParents() {
        StructuredDataResults data = this.model.getStructuredData();
        if (data == null) {
            return;
        }
        if (data.getParents() != null) {
            return;
        }
        Object ho = data.getRelatedObject();
        if (ho != null && ho instanceof DataObject) {
            this.model.loadParents(ho.getClass(), ((DataObject)ho).getId());
            this.setStatus(true);
            this.firePropertyChange("loadingParents", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public StructuredDataResults getStructuredData() {
        return this.model.getStructuredData();
    }

    @Override
    public void setStatus(boolean busy) {
        this.model.getEditor().setStatus(busy);
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.getEditor().loadExistingTags();
    }

    @Override
    public String getObjectPath() {
        return this.model.getRefObjectPath();
    }

    @Override
    public void makeMovie(int scaleBar, Color overlayColor) {
        int maxZ;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)refObject;
            refObject = wsd.getImage();
        }
        if (!(refObject instanceof ImageData)) {
            return;
        }
        PixelsData data = null;
        ImageData img = (ImageData)refObject;
        try {
            data = ((ImageData)refObject).getDefaultPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (data == null) {
            return;
        }
        int maxT = data.getSizeT();
        int defaultZ = maxZ = data.getSizeZ();
        int defaultT = maxT;
        String name = EditorUtil.getPartialName(img.getName());
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        MovieExportDialog dialog = new MovieExportDialog(f, name, maxT, maxZ, defaultZ, defaultT);
        dialog.setBinaryAvailable(MetadataViewerAgent.isBinaryAvailable());
        dialog.setScaleBarDefault(scaleBar, overlayColor);
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object src;
                String name = evt.getPropertyName();
                if ("createMovie".equals(name) && (src = evt.getSource()) instanceof MovieExportDialog) {
                    MovieExportDialog d = (MovieExportDialog)src;
                    MetadataViewerComponent.this.createMovie(d.getParameters());
                }
            }
        });
        dialog.centerDialog();
    }

    @Override
    public void uploadMovie(FileAnnotationData data, File folder) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (data == null) {
            if (folder == null) {
                un.notifyInfo("Movie Creation", "A problem occured while creating the movie");
            }
        } else {
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            OriginalFile f = (OriginalFile)data.getContent();
            IconManager icons = IconManager.getInstance();
            DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
            un.notifyActivity(activity);
        }
        this.firePropertyChange("creatingMovie", true, false);
    }

    @Override
    public int getRndIndex() {
        if (this.model.getState() == 4) {
            return -1;
        }
        return this.model.getIndex();
    }

    @Override
    public void renderPlane() {
        Object obj = this.model.getRefObject();
        if (obj instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)obj;
            obj = wsd.getImage();
        }
        if (!(obj instanceof ImageData)) {
            return;
        }
        long imageID = ((ImageData)obj).getId();
        switch (this.getRndIndex()) {
            case 0: {
                this.model.getEditor().getRenderer().renderPreview();
                break;
            }
            case 1: {
                this.firePropertyChange("renderPlane", -1, imageID);
            }
        }
    }

    @Override
    public void applyToAll() {
        Object obj = this.model.getRefObject();
        if (obj instanceof ImageData) {
            this.firePropertyChange("applySettings", null, obj);
        } else if (obj instanceof WellSampleData) {
            Object[] objects = new Object[]{obj, this.model.getParentRefObject()};
            this.firePropertyChange("applySettings", null, objects);
        }
    }

    @Override
    public void onSettingsApplied() {
        this.firePropertyChange("settingsApplied", false, true);
    }

    @Override
    public void onRndLoaded(boolean reload) {
        this.getRenderer().addPropertyChangeListener(this.controller);
        this.firePropertyChange("rndLoaded", !reload, reload);
    }

    @Override
    public Renderer getRenderer() {
        if (this.model.getEditor() == null) {
            return null;
        }
        return this.model.getEditor().getRenderer();
    }

    @Override
    public void onChannelSelected(int index) {
        if (this.getRndIndex() != 1) {
            return;
        }
        this.firePropertyChange("selectedChannel", -1, index);
    }

    @Override
    public Dimension getIdealRendererSize() {
        Renderer rnd = this.getRenderer();
        if (rnd == null) {
            return new Dimension(0, 0);
        }
        return rnd.getUI().getPreferredSize();
    }

    @Override
    public void analyse(int index) {
        if (index != 1) {
            return;
        }
        Object refObject = this.model.getRefObject();
        if (!(refObject instanceof ImageData)) {
            return;
        }
        ArrayList<ChannelData> channels = null;
        Map m = this.model.getEditor().getChannelData();
        if (m != null && m.size() == 1) {
            this.controller.analyseFRAP(0);
            return;
        }
        if (m != null) {
            Iterator j = m.keySet().iterator();
            channels = new ArrayList<ChannelData>();
            while (j.hasNext()) {
                channels.add((ChannelData)j.next());
            }
        }
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(72);
        switch (index) {
            case 1: {
                icon = icons.getIcon(86);
            }
        }
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        ChannelSelectionDialog d = new ChannelSelectionDialog(f, icon, channels, index);
        d.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void uploadFret(FileAnnotationData data, File folder) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (data == null) {
            if (folder == null) {
                un.notifyInfo("Data Analysis", "A problem occured while analyzing the data.");
            }
        } else {
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            if (data == null) {
                return;
            }
            OriginalFile f = (OriginalFile)data.getContent();
            IconManager icons = IconManager.getInstance();
            DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
            un.notifyActivity(activity);
        }
        this.firePropertyChange("analyse", true, false);
    }

    @Override
    public void onRndSettingsCopied(Collection imageIds) {
        if (imageIds == null || imageIds.size() == 0) {
            return;
        }
        Renderer rnd = this.getRenderer();
        if (rnd == null) {
            return;
        }
        Object ob = this.model.getRefObject();
        ImageData img = null;
        if (ob instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ob;
            img = wsd.getImage();
        } else if (ob instanceof ImageData) {
            img = (ImageData)ob;
        }
        if (img == null) {
            return;
        }
        if (!imageIds.contains(img.getId())) {
            return;
        }
        rnd.refresh();
    }

    @Override
    public boolean isNumerousChannel() {
        return this.model.isNumerousChannel();
    }

    @Override
    public void setSelectedTab(int index) {
        this.model.getEditor().setSelectedTab(index);
    }

    @Override
    public void activityOptions(Component source, Point location, int index) {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        l.add(source);
        l.add(location);
        l.add(Integer.valueOf(index));
        this.firePropertyChange("activityOptions", null, l);
    }

    @Override
    public void createFigure(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof FigureParam) {
            this.firePropertyChange("generateFigure", null, value);
        }
    }

    @Override
    public void manageScript(ScriptObject value, int index) {
        if (value == null) {
            return;
        }
        ScriptActivityParam p = null;
        switch (index) {
            case 100: {
                p = new ScriptActivityParam(value, 0);
                break;
            }
            case 101: {
                p = new ScriptActivityParam(value, 2);
                break;
            }
            case 102: {
                p = new ScriptActivityParam(value, 3);
            }
        }
        if (p != null) {
            this.firePropertyChange("handleScript", null, p);
        }
    }

    @Override
    public void reloadRenderingControl(boolean value) {
        if (value) {
            this.model.getEditor().loadRenderingControl(1);
        } else {
            this.firePropertyChange("closeRenderer", null, this.model.getRefObject());
        }
    }

    @Override
    public void onChannelColorChanged(int index) {
        this.view.onChannelColorChanged(index);
        this.firePropertyChange("channelColorChanged", -1, index);
    }

    @Override
    public Object getRefObject() {
        return this.model.getRefObject();
    }

    @Override
    public void updateAdminObject(Object data, boolean async) {
        if (data instanceof ExperimenterData) {
            this.model.fireExperimenterSaving((ExperimenterData)data, async);
        } else if (data instanceof AdminObject) {
            this.model.fireAdminSaving((AdminObject)data, async);
        }
    }

    @Override
    public long getUserID() {
        return this.model.getUserID();
    }

    @Override
    public void resetPassword(String newPass) {
        this.firePropertyChange("resetPassword", null, newPass);
    }

    @Override
    public void loadViewedBy() {
        Object ref = this.model.getRefObject();
        if (ref instanceof ImageData || ref instanceof WellSampleData) {
            if (this.model.getViewedBy() != null) {
                this.setViewedBy(this.model.getViewedBy());
            } else {
                this.model.fireViewedByLoading();
            }
        }
    }

    @Override
    public void setViewedBy(Map result) {
        this.model.setViewedBy(result);
        this.view.viewedBy();
        this.model.fireThumbnailsLoading();
    }

    @Override
    public void setThumbnails(Map<Long, BufferedImage> thumbnails, long imageID) {
        Object ref = this.model.getRefObject();
        ImageData image = null;
        if (ref instanceof ImageData) {
            image = (ImageData)ref;
        } else if (ref instanceof WellSampleData) {
            image = ((WellSampleData)ref).getImage();
        }
        if (image == null) {
            return;
        }
        if (image.getId() == imageID) {
            this.view.setThumbnails(thumbnails);
        }
    }

    @Override
    public void uploadScript() {
        this.firePropertyChange("uploadScript", false, true);
    }

    public String toString() {
        return this.model.getRefObjectName();
    }
}

