/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OptionsDialog;

public class BasicAnalyseDialog
extends OptionsDialog
implements PropertyChangeListener {
    public static final String ANALYSE_PARAMETERS_PROPERTY = "analyseParameters";
    private NumericalTextField field;

    private void initialize() {
        this.field = new NumericalTextField();
        this.setYesEnabled(false);
        this.field.addPropertyChangeListener(this);
        this.field.setColumns(5);
        this.setYesText("Analyse");
        this.hideNoButton();
        this.addCancelButton();
        this.setResizable(true);
        this.setSize(250, 200);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Image ID: "));
        p.add(this.field);
        this.addBodyComponent(p);
        this.setSize(450, 200);
    }

    protected void onYesSelection() {
        Number text = this.field.getValueAsNumber();
        String oldValue = null;
        if (text == null) {
            oldValue = "";
        }
        this.firePropertyChange(ANALYSE_PARAMETERS_PROPERTY, oldValue, text);
    }

    public BasicAnalyseDialog(JFrame parent, Icon icon) {
        super(parent, "Analyse", "Enter information about the image to analyse", icon);
        this.initialize();
        this.buildGUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("textUpdated".equals(name)) {
            Number n = this.field.getValueAsNumber();
            this.setYesEnabled(n != null);
        }
    }
}

