/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PreviewToolBar
extends JPanel {
    static final int SPACE = 3;
    private RendererControl control;
    private RendererModel model;
    private JLabel selectedPlane;

    private void initComponents() {
        this.selectedPlane = new JLabel();
        Font font = this.selectedPlane.getFont();
        this.selectedPlane.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.setSelectedPlane();
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.setFloatable(false);
        JButton b = new JButton(this.control.getAction(RendererControl.VIEW));
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(b);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(bar);
        this.add(Box.createHorizontalStrut(5));
        JPanel p = UIUtilities.buildComponentPanelRight(this.selectedPlane);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add(p);
    }

    PreviewToolBar(RendererControl control, RendererModel model) {
        this.control = control;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedPlane() {
        String s = "Z=" + (this.model.getDefaultZ() + 1) + "/" + this.model.getMaxZ();
        s = s + " T=" + (this.model.getDefaultT() + 1) + "/" + this.model.getMaxT();
        if (this.model.isNumerousChannel()) {
            s = s + " L=" + (this.model.getSelectedBin() + 1);
            s = s + "/" + this.model.getMaxLifetimeBin();
        }
        this.selectedPlane.setText(s);
    }
}

