/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.WellSampleData;

class PublishingDialog
extends JPopupMenu {
    private static final String MOVIE_TOOLTIP = "Creates a movie of the image and attaches it to the originating image.";
    private static final String EXPORT_AS_OME_TIFF_TOOLTIP = "Export the image as OME-TIFF.";
    private static final String SPLIT_VIEW_FIGURE_TOOLTIP = "Create a figure of split-view images.";
    private static final String SPLIT_VIEW_ROI_FIGURE_TOOLTIP = "Create a figure of an ROI region as separate zoomed split-channel panels.";
    private static final String MOVIE_TEXT = "Make Movie...";
    private static final String EXPORT_AS_OME_TIFF_TEXT = "Export As OME-TIFF...";
    private static final String SPLIT_VIEW_FIGURE_TEXT = "Split View Figure...";
    private static final String SPLIT_VIEW_ROI_FIGURE_TEXT = "ROI Split Figure...";
    private static final String THUMBNAILS_FIGURE_TOOLTIP = "Export a figure of thumbnails, optionally sorted by tag.";
    private static final String THUMBNAILS_FIGURE_TEXT = "Thumbnail Figure...";
    private static final String MOVIE_FIGURE_TOOLTIP = "Export a figure of a movie.";
    private static final String MOVIE_FIGURE_TEXT = "Movie Figure...";
    private EditorControl controller;
    private EditorModel model;
    private JButton movieButton;
    private JButton exportAsOmeTiffButton;
    private JButton splitViewFigureButton;
    private JMenuItem movieItem;
    private JMenuItem exportAsOmeTiffItem;
    private JMenuItem splitViewFigureItem;
    private JMenuItem splitViewROIFigureItem;
    private JMenuItem thumbnailsFigureItem;
    private JMenuItem movieFigureItem;
    private JPopupMenu menu;

    private JButton createButton(Icon icon, String text, int id) {
        JButton b = new JButton(icon);
        b.setToolTipText(text);
        b.addActionListener(this.controller);
        b.setActionCommand("" + id);
        b.setEnabled(false);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    private JMenuItem createMenuItem(Icon icon, String tooltip, String text, int id) {
        JMenuItem b = new JMenuItem(icon);
        b.setText(text);
        b.setToolTipText(tooltip);
        b.addActionListener(this.controller);
        b.setActionCommand("" + id);
        b.setEnabled(false);
        return b;
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.movieButton = this.createButton(icons.getIcon(110), MOVIE_TOOLTIP, 7);
        this.exportAsOmeTiffButton = this.createButton(icons.getIcon(73), EXPORT_AS_OME_TIFF_TOOLTIP, 11);
        this.splitViewFigureButton = this.createButton(icons.getIcon(110), SPLIT_VIEW_FIGURE_TEXT, 12);
        this.splitViewFigureButton.setEnabled(true);
        this.movieItem = this.createMenuItem(icons.getIcon(110), MOVIE_TOOLTIP, MOVIE_TEXT, 7);
        this.exportAsOmeTiffItem = this.createMenuItem(icons.getIcon(73), EXPORT_AS_OME_TIFF_TOOLTIP, EXPORT_AS_OME_TIFF_TEXT, 11);
        this.splitViewFigureItem = this.createMenuItem(icons.getIcon(110), SPLIT_VIEW_FIGURE_TOOLTIP, SPLIT_VIEW_FIGURE_TEXT, 12);
        this.splitViewFigureItem.setEnabled(true);
        this.splitViewROIFigureItem = this.createMenuItem(icons.getIcon(110), SPLIT_VIEW_ROI_FIGURE_TOOLTIP, SPLIT_VIEW_ROI_FIGURE_TEXT, 13);
        this.splitViewFigureButton.setEnabled(true);
        this.thumbnailsFigureItem = this.createMenuItem(icons.getIcon(110), THUMBNAILS_FIGURE_TOOLTIP, THUMBNAILS_FIGURE_TEXT, 14);
        this.thumbnailsFigureItem.setEnabled(true);
        this.movieFigureItem = this.createMenuItem(icons.getIcon(110), MOVIE_FIGURE_TOOLTIP, MOVIE_FIGURE_TEXT, 16);
        this.movieFigureItem.setEnabled(true);
    }

    private void buildGUI() {
        this.add(this.movieItem);
        this.add(this.splitViewFigureItem);
        this.add(this.splitViewROIFigureItem);
        this.add(this.thumbnailsFigureItem);
        this.add(this.movieFigureItem);
    }

    PublishingDialog(EditorControl controller, EditorModel model) {
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.setRootObject();
        this.buildGUI();
    }

    void setRootObject() {
        Object refObject = this.model.getRefObject();
        ImageData img = null;
        this.exportAsOmeTiffButton.setEnabled(false);
        this.movieButton.setEnabled(false);
        this.splitViewFigureButton.setEnabled(false);
        this.exportAsOmeTiffItem.setEnabled(false);
        this.movieItem.setEnabled(false);
        this.splitViewFigureItem.setEnabled(false);
        this.splitViewROIFigureItem.setEnabled(false);
        this.movieFigureItem.setEnabled(false);
        this.thumbnailsFigureItem.setEnabled(true);
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
            this.thumbnailsFigureItem.setEnabled(false);
        }
        if (img != null) {
            PixelsData data = null;
            try {
                data = img.getDefaultPixels();
                this.exportAsOmeTiffButton.setEnabled(true);
                this.movieButton.setEnabled(data.getSizeT() > 1 || data.getSizeZ() > 1);
                this.splitViewFigureButton.setEnabled(data.getSizeC() > 1);
                this.exportAsOmeTiffItem.setEnabled(true);
                this.movieItem.setEnabled(data.getSizeT() > 1 || data.getSizeZ() > 1);
                this.splitViewFigureItem.setEnabled(data.getSizeC() > 1);
                this.splitViewROIFigureItem.setEnabled(data.getSizeC() > 1);
                this.movieFigureItem.setEnabled(true);
            }
            catch (Exception e) {}
        } else if (refObject instanceof DatasetData) {
            this.thumbnailsFigureItem.setEnabled(true);
        } else if (refObject instanceof PlateData) {
            this.thumbnailsFigureItem.setEnabled(false);
        }
    }
}

