/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import omero.model.OriginalFile;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.FileAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OriginalMetadataComponent
extends JPanel
implements PropertyChangeListener {
    private static final String[] COLUMNS = new String[2];
    private EditorModel model;
    private boolean metadataLoaded;
    private JButton downloadButton;
    private JComponent toolBar;
    private JComponent statusBar;

    private void download() {
        JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the file.", null, true);
        chooser.setSelectedFileFull("original_metadata.txt");
        chooser.setApproveButtonText("Download");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(78));
        chooser.addPropertyChangeListener(this);
        chooser.centerDialog();
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(18);
        this.downloadButton = new JButton(icon);
        this.downloadButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.downloadButton.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.downloadButton);
        this.downloadButton.setToolTipText("Download the metadata file.");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OriginalMetadataComponent.this.download();
            }
        });
        this.toolBar = this.buildToolBar();
        this.toolBar.setBackground(UIUtilities.BACKGROUND_COLOR);
        JXBusyLabel label = new JXBusyLabel(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setBusy(true);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 0));
        p.add((Component)label);
        p.add(Box.createHorizontalStrut(5));
        JLabel l = new JLabel("Loading metadata");
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(l);
        this.statusBar = UIUtilities.buildComponentPanel(p);
        this.statusBar.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.statusBar, "North");
    }

    private JComponent buildToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.downloadButton);
        return bar;
    }

    private void buildGUI(Map<String, List<String>> components) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        Iterator<Map.Entry<String, List<String>>> i = components.entrySet().iterator();
        p.add(new JSeparator());
        while (i.hasNext()) {
            Map.Entry<String, List<String>> entry = i.next();
            String key = entry.getKey();
            List<String> l = entry.getValue();
            if (l == null || l.size() <= 0) continue;
            JLabel label = UIUtilities.setTextFont(key);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            JPanel row = UIUtilities.buildComponentPanel(label);
            row.setBackground(UIUtilities.BACKGROUND_COLOR);
            p.add(row);
            p.add(this.createTable(l));
        }
        this.removeAll();
        this.add((Component)this.toolBar, "North");
        this.add((Component)p, "Center");
    }

    private JScrollPane createTable(List<String> list) {
        Iterator<String> i = list.iterator();
        Object[][] data = new Object[list.size()][2];
        int index = 0;
        while (i.hasNext()) {
            String line = i.next();
            String[] values = line.split("=");
            switch (values.length) {
                case 0: {
                    data[index][0] = line;
                    break;
                }
                case 1: {
                    data[index][0] = values[0];
                    break;
                }
                case 2: {
                    data[index][0] = values[0];
                    data[index][1] = values[1];
                    break;
                }
                default: {
                    String s = values[values.length - 1];
                    String[] numbers = s.split(" ");
                    if (numbers != null) {
                        int j;
                        int count = 0;
                        for (j = 0; j < numbers.length; ++j) {
                            try {
                                Double.parseDouble(numbers[j]);
                                ++count;
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (count == numbers.length && count > 1) {
                            s = "";
                            for (j = 0; j < values.length - 1; ++j) {
                                s = s + values[j];
                                if (j >= values.length - 2) continue;
                                s = s + "=";
                            }
                            data[index][0] = s;
                            data[index][1] = values[values.length - 1];
                            break;
                        }
                        data[index][0] = values[0];
                        s = "";
                        for (j = 1; j < values.length; ++j) {
                            s = s + values[j];
                            if (j >= values.length - 1) continue;
                            s = s + "=";
                        }
                        data[index][1] = s;
                        break;
                    }
                    data[index][0] = line;
                }
            }
            ++index;
        }
        JXTable table = new JXTable((TableModel)new OriginalMetadataTableModel(data, COLUMNS));
        Highlighter h = HighlighterFactory.createAlternateStriping((Color)UIUtilities.BACKGROUND_COLOUR_EVEN, (Color)UIUtilities.BACKGROUND_COLOUR_ODD);
        table.addHighlighter(h);
        return new JScrollPane((Component)table);
    }

    private int getStart(String line) {
        if (line == null || line.length() == 0) {
            return 0;
        }
        if (line.startsWith("[")) {
            return 1;
        }
        return 0;
    }

    OriginalMetadataComponent(EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
    }

    boolean isMetadataLoaded() {
        return this.metadataLoaded;
    }

    void clear() {
        this.metadataLoaded = false;
        this.removeAll();
        this.add((Component)this.statusBar, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOriginalFile(File file) {
        this.metadataLoaded = true;
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            LinkedHashMap<String, List<String>> components = new LinkedHashMap<String, List<String>>();
            try {
                String line = null;
                String key = null;
                int start = 0;
                while ((line = input.readLine()) != null) {
                    if (line.contains("=")) {
                        List l;
                        if (key == null || key.trim().length() <= 0 || (l = (List)components.get(key)) == null) continue;
                        l.add(line);
                        continue;
                    }
                    if ((line = line.trim()).length() <= 0 || (key = line.substring(start = this.getStart(line), line.length() - 1)) == null || key.trim().length() <= 0) continue;
                    components.put(key, new ArrayList());
                }
                this.buildGUI(components);
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            file.delete();
            JLabel l = new JLabel("Loading metadata");
            l.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.statusBar = UIUtilities.buildComponentPanel(l);
            this.removeAll();
            this.add((Component)this.statusBar, "North");
            Logger logger = MetadataViewerAgent.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print("An error occurred while reading metadata file.");
            msg.print(e);
            logger.error((Object)this, msg);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            File folder = (File)evt.getNewValue();
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
            FileAnnotationData fa = this.model.getOriginalMetadata();
            if (fa == null) {
                return;
            }
            OriginalFile f = (OriginalFile)fa.getContent();
            IconManager icons = IconManager.getInstance();
            DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(77));
            un.notifyActivity(activity);
        }
    }

    static {
        OriginalMetadataComponent.COLUMNS[0] = "Tag";
        OriginalMetadataComponent.COLUMNS[1] = "Value";
    }

    class OriginalMetadataTableModel
    extends DefaultTableModel {
        OriginalMetadataTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

