/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.util.FigureDialog;
import org.openmicroscopy.shoola.agents.metadata.util.ScriptMenuItem;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.HTMLFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.OMETIFFFilter;
import org.openmicroscopy.shoola.util.filter.file.PDFFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.PowerPointFilter;
import org.openmicroscopy.shoola.util.filter.file.TEXTFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.filter.file.WordFilter;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;
import pojos.AnnotationData;
import pojos.ChannelData;
import pojos.FileAnnotationData;
import pojos.PixelsData;
import pojos.TagAnnotationData;

class EditorControl
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    static final String SAVE_PROPERTY = "save";
    static final int ADD_LOCAL_DOCS = 0;
    static final int ADD_UPLOADED_DOCS = 1;
    static final int ADD_TAGS = 2;
    static final int SAVE = 3;
    static final int DOWNLOAD = 4;
    static final int ACQUISITION_METADATA = 5;
    static final int CREATE_NEW_EXPERIMENT = 6;
    static final int CREATE_MOVIE = 7;
    static final int RENDERER = 8;
    static final int ANALYSE_FLIM = 9;
    static final int REFRESH = 10;
    static final int EXPORT_AS_OMETIFF = 11;
    static final int SPLIT_VIEW_FIGURE = 12;
    static final int SPLIT_VIEW_ROI_FIGURE = 13;
    static final int THUMBNAILS_FIGURE = 14;
    static final int ANALYSE_FRAP = 15;
    static final int MOVIE_FIGURE = 16;
    static final int UPLOAD_SCRIPT = 17;
    static final int RELOAD_SCRIPT = 18;
    static final int REMOVE_TAGS = 19;
    static final int REMOVE_DOCS = 20;
    private Editor model;
    private EditorUI view;
    private List<FileFilter> filters;
    private List<FileFilter> exportFilters;
    private FigureDialog figureDialog;

    EditorControl() {
    }

    private void createFileFilters() {
        this.filters = new ArrayList<FileFilter>();
        this.filters.add(new PDFFilter());
        this.filters.add(new PNGFilter());
        this.filters.add(new HTMLFilter());
        this.filters.add(new JPEGFilter());
        this.filters.add(new ExcelFilter());
        this.filters.add(new WordFilter());
        this.filters.add(new PowerPointFilter());
        this.filters.add(new EditorFileFilter());
        this.filters.add(new XMLFilter());
        this.filters.add(new TIFFFilter());
        this.filters.add(new TEXTFilter());
        this.exportFilters = new ArrayList<FileFilter>();
        this.exportFilters.add(new OMETIFFFilter());
    }

    private void selectFileToAttach() {
        JFrame owner = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(owner, 0, "Choose File", "Select the file to attach.", this.filters, true);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(42));
        chooser.setApproveButtonText("Attach");
        chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(chooser);
    }

    private void viewImage(long imageID) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new ViewImage(imageID, null));
    }

    private void viewImage(String imageName) {
    }

    private void viewProtocol(long protocolID) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new EditFileEvent(protocolID));
    }

    private void download() {
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 2, "Download", "Select where to download the file.", null, true);
        chooser.setSelectedFileFull(this.view.getRefObjectName());
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(78));
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    String path = (String)evt.getNewValue();
                    if (path == null) {
                        path = UIUtilities.getDefaultFolderAsString();
                    }
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separator;
                    }
                    EditorControl.this.model.download(new File(path));
                }
            }
        });
        chooser.centerDialog();
    }

    private void export() {
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Export", "Select where to export the image as OME-TIFF.", this.exportFilters);
        String s = UIUtilities.removeFileExtension(this.view.getRefObjectName());
        if (s != null && s.trim().length() > 0) {
            chooser.setSelectedFile(s);
        }
        chooser.setApproveButtonText("Export");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(74));
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    Object src;
                    File folder = (File)evt.getNewValue();
                    if (folder == null) {
                        folder = UIUtilities.getDefaultFolder();
                    }
                    if ((src = evt.getSource()) instanceof FileChooser) {
                        ((FileChooser)src).setVisible(false);
                        ((FileChooser)src).dispose();
                    }
                    EditorControl.this.model.exportImageAsOMETIFF(folder);
                }
            }
        });
        chooser.centerDialog();
    }

    void initialize(Editor model, EditorUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = view;
        this.createFileFilters();
    }

    void loadChannelData() {
        this.model.loadChannelData();
    }

    void loadParents() {
        this.model.loadParents();
    }

    void loadImageAcquisitionData() {
        this.model.loadImageAcquisitionData();
    }

    void loadChannelAcquisitionData(ChannelData channel) {
        this.model.loadChannelAcquisitionData(channel);
    }

    void loadInstrumentData() {
        this.model.loadInstrumentData();
    }

    void loadExistingTags() {
        this.model.loadExistingTags();
    }

    boolean isSingleMode() {
        return this.view.isSingleMode();
    }

    FigureDialog createFigureDialog(String name, PixelsData pixels, int index) {
        if (this.figureDialog != null) {
            return this.figureDialog;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (FigureDialog.needPixels(index) && pixels == null) {
            un.notifyInfo("Figure", "The image is not valid, cannot create the figure.");
            return null;
        }
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        this.figureDialog = new FigureDialog(f, name, pixels, index, this.view.getRefObject().getClass());
        this.figureDialog.addPropertyChangeListener(this);
        return this.figureDialog;
    }

    FigureDialog getFigureDialog() {
        return this.figureDialog;
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane;
        if (e.getSource() instanceof JTabbedPane && (pane = (JTabbedPane)e.getSource()).getSelectedIndex() == 2) {
            this.model.loadRenderingControl(0);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (SAVE_PROPERTY.equals(name) || "dataModified".equals(name) || "previewEdited".equals(name)) {
            this.view.setDataToSave(this.view.hasDataToSave());
        } else if ("saveData".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.view.saveData(b);
        } else if ("clearSaveData".equals(name) || "onDataSave".equals(name) || "adminUpdated".equals(name)) {
            this.view.clearData();
        } else if ("collapsed".equals(name)) {
            this.view.handleTaskPaneCollapsed((JXTaskPane)evt.getSource());
        } else if ("approveSelection".equals(name)) {
            this.view.attachFile((File)evt.getNewValue());
        } else if ("removeAnnotation".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                DocComponent doc = (DocComponent)object;
                Object data = doc.getData();
                if (data instanceof File) {
                    this.view.removeAttachedFile(data);
                } else if (data instanceof FileAnnotationData) {
                    this.view.removeAttachedFile(data);
                } else if (data instanceof TagAnnotationData) {
                    this.view.removeTag((TagAnnotationData)data);
                }
            }
        } else if ("deleteAnnotation".equals(name)) {
            DocComponent doc;
            Object data;
            Object object = evt.getNewValue();
            if (object instanceof DocComponent && (data = (doc = (DocComponent)object).getData()) instanceof FileAnnotationData) {
                this.view.deleteAnnotation((AnnotationData)((FileAnnotationData)data));
                this.view.removeAttachedFile(data);
            }
        } else if ("editTag".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                this.view.setDataToSave(this.view.hasDataToSave());
            }
        } else if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            switch (object.getIndex()) {
                case 2: {
                    long id = object.getId();
                    if (id < 0L) {
                        this.viewImage(object.getName());
                        break;
                    }
                    this.viewImage(id);
                    break;
                }
                case 4: {
                    this.viewProtocol(object.getId());
                }
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.view.handleObjectsSelection(type, (Collection)entry.getValue());
            }
        } else if ("openFile".equals(name)) {
            Long id = (Long)evt.getNewValue();
            if (id != null) {
                this.viewProtocol(id);
            }
        } else if ("settingsApplied".equals(name)) {
            this.model.loadRenderingControl(1);
            this.view.onSettingsApplied(true);
        } else if ("activityOptions".equals(name)) {
            List l = (List)evt.getNewValue();
            this.view.activityOptions((Component)l.get(0), (Point)l.get(1), (Integer)l.get(2));
        } else if ("createFigure".equals(name)) {
            this.view.createFigure(evt.getNewValue());
        } else if ("closeFigure".equals(name)) {
            this.figureDialog = null;
        } else if ("closeRenderer".equals(name)) {
            this.view.discardRenderer(evt.getNewValue());
        } else if ("runSelectedScript".equals(name)) {
            this.view.manageScript((ScriptObject)evt.getNewValue(), 100);
        } else if ("downloadSelectedScript".equals(name)) {
            ScriptObject script;
            Object value = evt.getNewValue();
            if (value instanceof ScriptObject) {
                this.view.manageScript((ScriptObject)value, 101);
            } else if (value instanceof String && (script = this.view.getScriptFromName((String)value)) != null) {
                this.view.manageScript(script, 101);
            }
        } else if ("viewSelectedScript".equals(name)) {
            ScriptObject script;
            Object value = evt.getNewValue();
            if (value instanceof ScriptObject) {
                this.view.manageScript((ScriptObject)value, 102);
            } else if (value instanceof String && (script = this.view.getScriptFromName((String)value)) != null) {
                this.view.manageScript(script, 102);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ScriptMenuItem) {
            ScriptMenuItem item = (ScriptMenuItem)e.getSource();
            if (item.isScriptWithUI()) {
                switch (item.getIndex()) {
                    case 2: {
                        this.model.createFigure(2);
                        break;
                    }
                    case 0: {
                        this.model.createFigure(1);
                        break;
                    }
                    case 1: {
                        this.model.createFigure(3);
                        break;
                    }
                    case 3: {
                        this.model.createFigure(0);
                        break;
                    }
                    case 4: {
                        this.view.makeMovie(-1, null);
                    }
                }
            } else {
                ScriptObject object = item.getScript();
                if (!object.isParametersLoaded()) {
                    this.model.loadScript(object.getScriptID());
                } else {
                    this.model.setScript(object);
                }
            }
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.selectFileToAttach();
                break;
            }
            case 1: {
                this.model.loadExistingAttachments();
                break;
            }
            case 3: {
                this.view.saveData(true);
                break;
            }
            case 4: {
                this.download();
                break;
            }
            case 2: {
                this.loadExistingTags();
                break;
            }
            case 6: {
                this.view.createNewExperiment();
                break;
            }
            case 7: {
                this.view.makeMovie(-1, null);
                break;
            }
            case 8: {
                this.model.loadRenderingControl(0);
                break;
            }
            case 9: {
                this.view.analyse(0);
                break;
            }
            case 15: {
                this.view.analyse(1);
                break;
            }
            case 10: {
                this.model.refresh();
                break;
            }
            case 11: {
                this.export();
                break;
            }
            case 12: {
                this.model.createFigure(0);
                break;
            }
            case 13: {
                this.model.createFigure(1);
                break;
            }
            case 14: {
                this.model.createFigure(3);
                break;
            }
            case 16: {
                this.model.createFigure(2);
                break;
            }
            case 17: {
                this.view.uploadScript();
                break;
            }
            case 18: {
                this.view.reloadScript();
                break;
            }
            case 19: {
                this.view.removeTags();
                break;
            }
            case 20: {
                this.view.removeAttachedFiles();
            }
        }
    }
}

