/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultsWizard
extends JDialog
implements ActionListener {
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int ADD_ALL = 2;
    private static final int REMOVE_ALL = 3;
    private static final int ACCEPT = 4;
    private static final int CANCEL = 5;
    private static final int RESET = 6;
    private List<AnnotationField> currentFields;
    private List<AnnotationField> allFields;
    private List<AnnotationField> originalSelection;
    private JList currentFieldsListbox;
    private JList remainingFieldsListbox;
    private JButton addFieldButton;
    private JButton removeFieldButton;
    private JButton addAllFieldsButton;
    private JButton removeAllFieldsButton;
    private JButton acceptButton;
    private JButton resetButton;
    private JButton cancelButton;

    private void initComponents() {
        this.currentFieldsListbox = new JList();
        this.remainingFieldsListbox = new JList();
        this.createButtons();
        this.addActionListeners();
    }

    private void resetSelection() {
        this.currentFields.clear();
        for (AnnotationField field : this.originalSelection) {
            this.currentFields.add(field);
        }
    }

    private void createOriginalSelection() {
        this.originalSelection = new ArrayList<AnnotationField>();
        for (AnnotationField field : this.currentFields) {
            this.originalSelection.add(field);
        }
    }

    private void addActionListeners() {
        this.addFieldButton.setActionCommand("0");
        this.addFieldButton.addActionListener(this);
        this.addAllFieldsButton.setActionCommand("2");
        this.addAllFieldsButton.addActionListener(this);
        this.removeFieldButton.setActionCommand("1");
        this.removeFieldButton.addActionListener(this);
        this.removeAllFieldsButton.setActionCommand("3");
        this.removeAllFieldsButton.addActionListener(this);
        this.acceptButton.setActionCommand("4");
        this.acceptButton.addActionListener(this);
        this.cancelButton.setActionCommand("5");
        this.cancelButton.addActionListener(this);
        this.resetButton.setActionCommand("6");
        this.resetButton.addActionListener(this);
    }

    private void addField() {
        if (this.remainingFieldsListbox.getSelectedIndex() == -1) {
            return;
        }
        int[] indexes = this.remainingFieldsListbox.getSelectedIndices();
        DefaultListModel model = (DefaultListModel)this.remainingFieldsListbox.getModel();
        block0: for (int i = 0; i < indexes.length; ++i) {
            String annotationName = (String)model.getElementAt(indexes[i]);
            for (AnnotationField field : this.allFields) {
                if (!field.getName().equals(annotationName)) continue;
                this.currentFields.add(field);
                continue block0;
            }
        }
        this.sortCurrentFields();
        this.populateCurrentFieldsPanel();
        this.populateRemainingFieldsPanel();
    }

    private void sortCurrentFields() {
        ArrayList<AnnotationField> sortedList = new ArrayList<AnnotationField>();
        for (AnnotationField allFieldsField : this.allFields) {
            for (AnnotationField currentFieldsField : this.currentFields) {
                if (!currentFieldsField.getName().equals(allFieldsField.getName())) continue;
                sortedList.add(currentFieldsField);
            }
        }
        this.currentFields.clear();
        this.currentFields.addAll(sortedList);
    }

    private void addAllFields() {
        this.currentFields.clear();
        for (AnnotationField field : this.allFields) {
            this.currentFields.add(field);
        }
        this.populateCurrentFieldsPanel();
        this.populateRemainingFieldsPanel();
    }

    private void removeField() {
        if (this.currentFieldsListbox.getSelectedIndex() == -1) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.currentFieldsListbox.getModel();
        int[] indexes = this.currentFieldsListbox.getSelectedIndices();
        block0: for (int i = 0; i < indexes.length; ++i) {
            String annotationName = (String)model.getElementAt(indexes[i]);
            for (AnnotationField field : this.currentFields) {
                if (!field.getName().equals(annotationName)) continue;
                this.currentFields.remove(field);
                continue block0;
            }
        }
        this.sortCurrentFields();
        this.populateCurrentFieldsPanel();
        this.populateRemainingFieldsPanel();
    }

    private void removeAllFields() {
        this.currentFields.clear();
        this.populateCurrentFieldsPanel();
        this.populateRemainingFieldsPanel();
    }

    private void cancelButtonClicked() {
        this.resetSelection();
        this.acceptButtonClicked();
    }

    private void acceptButtonClicked() {
        this.setVisible(false);
        this.dispose();
    }

    private void resetButtonClicked() {
        this.resetSelection();
        this.populateCurrentFieldsPanel();
        this.populateRemainingFieldsPanel();
    }

    private void createButtons() {
        this.addFieldButton = new JButton(IconManager.getInstance().getIcon(7));
        this.removeFieldButton = new JButton(IconManager.getInstance().getIcon(6));
        this.addAllFieldsButton = new JButton(IconManager.getInstance().getIcon(9));
        this.removeAllFieldsButton = new JButton(IconManager.getInstance().getIcon(8));
        this.acceptButton = new JButton("Accept");
        this.cancelButton = new JButton("Cancel");
        this.resetButton = new JButton("Reset");
        this.getRootPane().setDefaultButton(this.acceptButton);
    }

    private void buildUI() {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 0));
        JPanel leftPanel = this.createRemainingFieldsPanel();
        JPanel buttonPanel = this.createButtonPanel();
        JPanel rightPanel = this.createCurrentFieldsPanel();
        container.add(Box.createHorizontalStrut(10));
        container.add(leftPanel);
        container.add(Box.createHorizontalStrut(20));
        container.add(buttonPanel);
        container.add(Box.createHorizontalStrut(20));
        container.add(rightPanel);
        container.add(Box.createHorizontalStrut(10));
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel("Results Wizard", "Select the measurements you wish to record.", icons.getIcon(10));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)((Object)tp), "North");
        c.add((Component)container, "Center");
        c.add((Component)this.createControlPanel(), "South");
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.resetButton);
        controlPanel.add(this.acceptButton);
        controlPanel.add(this.cancelButton);
        return controlPanel;
    }

    private JPanel createRemainingFieldsPanel() {
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.remainingFieldsListbox);
        fieldsPanel.add((Component)new JLabel("Unused Measurements:"), "North");
        fieldsPanel.add((Component)pane, "Center");
        this.populateRemainingFieldsPanel();
        return fieldsPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(Box.createVerticalStrut(30));
        buttonPanel.add(this.addFieldButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeFieldButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.addAllFieldsButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeAllFieldsButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        return buttonPanel;
    }

    private JPanel createCurrentFieldsPanel() {
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.currentFieldsListbox);
        fieldsPanel.add((Component)new JLabel("Selected Measurements:"), "North");
        fieldsPanel.add((Component)pane, "Center");
        this.populateCurrentFieldsPanel();
        return fieldsPanel;
    }

    private void populateCurrentFieldsPanel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (AnnotationField annotation : this.currentFields) {
            listModel.addElement(annotation.getName());
        }
        this.currentFieldsListbox.setModel(listModel);
    }

    private void populateRemainingFieldsPanel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (AnnotationField allFieldAnnotation : this.allFields) {
            boolean found = false;
            for (AnnotationField currentFieldAnnotation : this.currentFields) {
                if (!currentFieldAnnotation.getKey().equals((Object)allFieldAnnotation.getKey())) continue;
                found = true;
            }
            if (found) continue;
            listModel.addElement(allFieldAnnotation.getName());
        }
        this.remainingFieldsListbox.setModel(listModel);
    }

    ResultsWizard(JFrame owner, List<AnnotationField> cFields, List<AnnotationField> aFields) {
        super((Frame)owner, true);
        this.currentFields = cFields;
        this.allFields = aFields;
        this.createOriginalSelection();
        this.initComponents();
        this.buildUI();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = -1;
        try {
            id = Integer.parseInt(evt.getActionCommand());
            switch (id) {
                case 0: {
                    this.addField();
                    break;
                }
                case 2: {
                    this.addAllFields();
                    break;
                }
                case 1: {
                    this.removeField();
                    break;
                }
                case 3: {
                    this.removeAllFields();
                    break;
                }
                case 4: {
                    this.acceptButtonClicked();
                    break;
                }
                case 5: {
                    this.cancelButtonClicked();
                    break;
                }
                case 6: {
                    this.resetButtonClicked();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

